/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare function getVolumeValueId(endpointIndex: number | undefined): ValueID;
export declare function getToneIdValueId(endpointIndex: number | undefined): ValueID;
export declare enum SoundSwitchCommand {
    TonesNumberGet = 1,
    TonesNumberReport = 2,
    ToneInfoGet = 3,
    ToneInfoReport = 4,
    ConfigurationSet = 5,
    ConfigurationGet = 6,
    ConfigurationReport = 7,
    TonePlaySet = 8,
    TonePlayGet = 9,
    TonePlayReport = 10
}
export declare enum ToneId {
    Off = 0,
    Default = 255
}
export declare class SoundSwitchCCAPI extends CCAPI {
    supportsCommand(cmd: SoundSwitchCommand): Maybe<boolean>;
    getToneCount(): Promise<number | undefined>;
    getToneInfo(toneId: number): Promise<Pick<SoundSwitchCCToneInfoReport, "duration" | "name"> | undefined>;
    setConfiguration(defaultToneId: number, defaultVolume: number): Promise<void>;
    getConfiguration(): Promise<Pick<SoundSwitchCCConfigurationReport, "defaultVolume" | "defaultToneId"> | undefined>;
    play(toneId: number, volume?: number): Promise<void>;
    stopPlaying(): Promise<void>;
    getPlaying(): Promise<Pick<SoundSwitchCCTonePlayReport, "volume" | "toneId"> | undefined>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class SoundSwitchCC extends CommandClass {
    ccCommand: SoundSwitchCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class SoundSwitchCCTonesNumberReport extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly toneCount: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SoundSwitchCCTonesNumberGet extends SoundSwitchCC {
}
export declare class SoundSwitchCCToneInfoReport extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly toneId: number;
    readonly duration: number;
    readonly name: string;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SoundSwitchCCToneInfoGetOptions extends CCCommandOptions {
    toneId: number;
}
export declare class SoundSwitchCCToneInfoGet extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SoundSwitchCCToneInfoGetOptions);
    toneId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SoundSwitchCCConfigurationSetOptions extends CCCommandOptions {
    defaultVolume: number;
    defaultToneId: number;
}
export declare class SoundSwitchCCConfigurationSet extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SoundSwitchCCConfigurationSetOptions);
    defaultVolume: number;
    defaultToneId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SoundSwitchCCConfigurationReport extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly defaultVolume: number;
    readonly defaultToneId: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SoundSwitchCCConfigurationGet extends SoundSwitchCC {
}
interface SoundSwitchCCTonePlaySetOptions extends CCCommandOptions {
    toneId: ToneId | number;
    volume?: number;
}
export declare class SoundSwitchCCTonePlaySet extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SoundSwitchCCTonePlaySetOptions);
    toneId: ToneId | number;
    volume?: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SoundSwitchCCTonePlayReport extends SoundSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly toneId: ToneId | number;
    volume?: number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SoundSwitchCCTonePlayGet extends SoundSwitchCC {
}
export {};
