"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCodeCCExtendedUserCodeGet = exports.UserCodeCCExtendedUserCodeReport = exports.UserCodeCCExtendedUserCodeSet = exports.UserCodeCCUserCodeChecksumGet = exports.UserCodeCCUserCodeChecksumReport = exports.UserCodeCCMasterCodeGet = exports.UserCodeCCMasterCodeReport = exports.UserCodeCCMasterCodeSet = exports.UserCodeCCKeypadModeGet = exports.UserCodeCCKeypadModeReport = exports.UserCodeCCKeypadModeSet = exports.UserCodeCCCapabilitiesGet = exports.UserCodeCCCapabilitiesReport = exports.UserCodeCCUsersNumberGet = exports.UserCodeCCUsersNumberReport = exports.UserCodeCCGet = exports.UserCodeCCReport = exports.UserCodeCCSet = exports.UserCodeCC = exports.UserCodeCCAPI = exports.getSupportsMultipleUserCodeSetValueID = exports.getSupportedASCIICharsValueID = exports.getKeypadModeValueID = exports.getSupportedKeypadModesValueID = exports.getSupportedUserIDStatusesValueID = exports.getSupportsUserCodeChecksumValueID = exports.getSupportsMasterCodeDeactivationValueID = exports.getSupportsMasterCodeValueID = exports.getUserCodeChecksumValueID = exports.getUserCodeValueID = exports.getUserIdStatusValueID = exports.getSupportedUsersValueID = exports.KeypadMode = exports.UserIDStatus = exports.UserCodeCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const API_1 = require("../commandclass/API");
const Constants_1 = require("../message/Constants");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var UserCodeCommand;
(function (UserCodeCommand) {
    UserCodeCommand[UserCodeCommand["Set"] = 1] = "Set";
    UserCodeCommand[UserCodeCommand["Get"] = 2] = "Get";
    UserCodeCommand[UserCodeCommand["Report"] = 3] = "Report";
    // V2+
    UserCodeCommand[UserCodeCommand["UsersNumberGet"] = 4] = "UsersNumberGet";
    UserCodeCommand[UserCodeCommand["UsersNumberReport"] = 5] = "UsersNumberReport";
    UserCodeCommand[UserCodeCommand["CapabilitiesGet"] = 6] = "CapabilitiesGet";
    UserCodeCommand[UserCodeCommand["CapabilitiesReport"] = 7] = "CapabilitiesReport";
    UserCodeCommand[UserCodeCommand["KeypadModeSet"] = 8] = "KeypadModeSet";
    UserCodeCommand[UserCodeCommand["KeypadModeGet"] = 9] = "KeypadModeGet";
    UserCodeCommand[UserCodeCommand["KeypadModeReport"] = 10] = "KeypadModeReport";
    UserCodeCommand[UserCodeCommand["ExtendedUserCodeSet"] = 11] = "ExtendedUserCodeSet";
    UserCodeCommand[UserCodeCommand["ExtendedUserCodeGet"] = 12] = "ExtendedUserCodeGet";
    UserCodeCommand[UserCodeCommand["ExtendedUserCodeReport"] = 13] = "ExtendedUserCodeReport";
    UserCodeCommand[UserCodeCommand["MasterCodeSet"] = 14] = "MasterCodeSet";
    UserCodeCommand[UserCodeCommand["MasterCodeGet"] = 15] = "MasterCodeGet";
    UserCodeCommand[UserCodeCommand["MasterCodeReport"] = 16] = "MasterCodeReport";
    UserCodeCommand[UserCodeCommand["UserCodeChecksumGet"] = 17] = "UserCodeChecksumGet";
    UserCodeCommand[UserCodeCommand["UserCodeChecksumReport"] = 18] = "UserCodeChecksumReport";
})(UserCodeCommand = exports.UserCodeCommand || (exports.UserCodeCommand = {}));
// @publicAPI
var UserIDStatus;
(function (UserIDStatus) {
    UserIDStatus[UserIDStatus["Available"] = 0] = "Available";
    UserIDStatus[UserIDStatus["Enabled"] = 1] = "Enabled";
    UserIDStatus[UserIDStatus["Disabled"] = 2] = "Disabled";
    UserIDStatus[UserIDStatus["Messaging"] = 3] = "Messaging";
    UserIDStatus[UserIDStatus["PassageMode"] = 4] = "PassageMode";
    UserIDStatus[UserIDStatus["StatusNotAvailable"] = 254] = "StatusNotAvailable";
})(UserIDStatus = exports.UserIDStatus || (exports.UserIDStatus = {}));
// @publicAPI
var KeypadMode;
(function (KeypadMode) {
    KeypadMode[KeypadMode["Normal"] = 0] = "Normal";
    KeypadMode[KeypadMode["Vacation"] = 1] = "Vacation";
    KeypadMode[KeypadMode["Privacy"] = 2] = "Privacy";
    KeypadMode[KeypadMode["LockedOut"] = 3] = "LockedOut";
})(KeypadMode = exports.KeypadMode || (exports.KeypadMode = {}));
function getSupportedUsersValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportedUsers",
    };
}
exports.getSupportedUsersValueID = getSupportedUsersValueID;
function getUserIdStatusValueID(endpoint, userId) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "userIdStatus",
        propertyKey: userId,
    };
}
exports.getUserIdStatusValueID = getUserIdStatusValueID;
function getUserCodeValueID(endpoint, userId) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "userCode",
        propertyKey: userId,
    };
}
exports.getUserCodeValueID = getUserCodeValueID;
function getUserCodeChecksumValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "userCodeChecksum",
    };
}
exports.getUserCodeChecksumValueID = getUserCodeChecksumValueID;
function getSupportsMasterCodeValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportsMasterCode",
    };
}
exports.getSupportsMasterCodeValueID = getSupportsMasterCodeValueID;
function getSupportsMasterCodeDeactivationValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportsMasterCodeDeactivation",
    };
}
exports.getSupportsMasterCodeDeactivationValueID = getSupportsMasterCodeDeactivationValueID;
function getSupportsUserCodeChecksumValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportsUserCodeChecksum",
    };
}
exports.getSupportsUserCodeChecksumValueID = getSupportsUserCodeChecksumValueID;
function getSupportedUserIDStatusesValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportedUserIDStatuses",
    };
}
exports.getSupportedUserIDStatusesValueID = getSupportedUserIDStatusesValueID;
function getSupportedKeypadModesValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportedKeypadModes",
    };
}
exports.getSupportedKeypadModesValueID = getSupportedKeypadModesValueID;
function getKeypadModeValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "keypadMode",
    };
}
exports.getKeypadModeValueID = getKeypadModeValueID;
function getSupportedASCIICharsValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportedASCIIChars",
    };
}
exports.getSupportedASCIICharsValueID = getSupportedASCIICharsValueID;
function getSupportsMultipleUserCodeSetValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["User Code"],
        endpoint,
        property: "supportsMultipleUserCodeSet",
    };
}
exports.getSupportsMultipleUserCodeSetValueID = getSupportsMultipleUserCodeSetValueID;
function parseExtendedUserCode(payload) {
    core_1.validatePayload(payload.length >= 4);
    const userId = payload.readUInt16BE(0);
    const status = payload[2];
    const codeLength = payload[3] & 0b1111;
    core_1.validatePayload(payload.length >= 4 + codeLength);
    const code = payload.slice(4, 4 + codeLength).toString("ascii");
    return {
        code: {
            userId,
            userIdStatus: status,
            userCode: code,
        },
        bytesRead: 4 + codeLength,
    };
}
function validateCode(code, supportedChars) {
    if (code.length < 4 || code.length > 10)
        return false;
    return [...code].every((char) => supportedChars.includes(char));
}
function persistUserCode(userId, userIdStatus, userCode) {
    var _c;
    const statusValueId = getUserIdStatusValueID(this.endpointIndex, userId);
    const codeValueId = getUserCodeValueID(this.endpointIndex, userId);
    const valueDB = this.getValueDB();
    const supportedUserIDStatuses = (_c = valueDB.getValue(getSupportedUserIDStatusesValueID(this.endpointIndex))) !== null && _c !== void 0 ? _c : (this.version === 1
        ? [
            UserIDStatus.Available,
            UserIDStatus.Enabled,
            UserIDStatus.Disabled,
        ]
        : [
            UserIDStatus.Available,
            UserIDStatus.Enabled,
            UserIDStatus.Disabled,
            UserIDStatus.Messaging,
            UserIDStatus.PassageMode,
        ]);
    // Check if this code is supported
    if (userIdStatus === UserIDStatus.StatusNotAvailable) {
        // It is not, remove all values if any exist
        valueDB.removeValue(statusValueId);
        valueDB.removeValue(codeValueId);
        valueDB.setMetadata(statusValueId, undefined);
        valueDB.setMetadata(codeValueId, undefined);
    }
    else {
        // Always create metadata if it does not exist
        if (!valueDB.hasMetadata(statusValueId)) {
            valueDB.setMetadata(statusValueId, {
                ...core_1.ValueMetadata.Number,
                label: `User ID status (${userId})`,
                states: core_1.enumValuesToMetadataStates(UserIDStatus, supportedUserIDStatuses),
            });
        }
        if (!valueDB.hasMetadata(codeValueId)) {
            valueDB.setMetadata(codeValueId, {
                ...core_1.ValueMetadata.String,
                minLength: 4,
                maxLength: 10,
                label: `User Code (${userId})`,
            });
        }
        valueDB.setValue(statusValueId, userIdStatus);
        valueDB.setValue(codeValueId, userCode);
    }
    return true;
}
let UserCodeCCAPI = class UserCodeCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            if (property === "keypadMode") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.setKeypadMode(value);
            }
            else if (property === "masterCode") {
                if (typeof value !== "string") {
                    API_1.throwWrongValueType(this.ccId, property, "string", typeof value);
                }
                await this.setMasterCode(value);
            }
            else if (property === "userIdStatus") {
                if (propertyKey == undefined) {
                    API_1.throwMissingPropertyKey(this.ccId, property);
                }
                else if (typeof propertyKey !== "number") {
                    API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                }
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                if (value === UserIDStatus.Available) {
                    // Clear Code
                    await this.clear(propertyKey);
                }
                else {
                    // We need to set the user code along with the status
                    const node = this.endpoint.getNodeUnsafe();
                    const userCode = node.getValue(getUserCodeValueID(this.endpoint.index, propertyKey));
                    await this.set(propertyKey, value, userCode);
                }
            }
            else if (property === "userCode") {
                if (propertyKey == undefined) {
                    API_1.throwMissingPropertyKey(this.ccId, property);
                }
                else if (typeof propertyKey !== "number") {
                    API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                }
                if (typeof value !== "string" && !Buffer.isBuffer(value)) {
                    API_1.throwWrongValueType(this.ccId, property, "string or Buffer", typeof value);
                }
                // We need to set the user id status along with the code
                const node = this.endpoint.getNodeUnsafe();
                let userIdStatus = node.getValue(getUserIdStatusValueID(this.endpoint.index, propertyKey));
                if (userIdStatus === UserIDStatus.Available ||
                    userIdStatus == undefined) {
                    userIdStatus = UserIDStatus.Enabled;
                }
                await this.set(propertyKey, userIdStatus, value);
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            // Verify the current value after a delay
            this.schedulePoll({ property, propertyKey });
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "keypadMode":
                    return this.getKeypadMode();
                case "masterCode":
                    return this.getMasterCode();
                case "userIdStatus":
                case "userCode": {
                    if (propertyKey == undefined) {
                        API_1.throwMissingPropertyKey(this.ccId, property);
                    }
                    else if (typeof propertyKey !== "number") {
                        API_1.throwUnsupportedPropertyKey(this.ccId, property, propertyKey);
                    }
                    return (_c = (await this.get(propertyKey))) === null || _c === void 0 ? void 0 : _c[property];
                }
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        var _c, _d;
        switch (cmd) {
            case UserCodeCommand.Get:
            case UserCodeCommand.Set:
            case UserCodeCommand.UsersNumberGet:
                return true; // This is mandatory
            case UserCodeCommand.CapabilitiesGet:
            case UserCodeCommand.KeypadModeSet:
            case UserCodeCommand.KeypadModeGet:
            case UserCodeCommand.ExtendedUserCodeSet:
            case UserCodeCommand.ExtendedUserCodeGet:
                return this.version >= 2;
            case UserCodeCommand.MasterCodeSet:
            case UserCodeCommand.MasterCodeGet: {
                if (this.version < 2)
                    return false;
                const node = this.endpoint.getNodeUnsafe();
                const ret = (_c = node.getValue(getSupportsMasterCodeValueID(this.endpoint.index))) !== null && _c !== void 0 ? _c : core_1.unknownBoolean;
                return ret;
            }
            case UserCodeCommand.UserCodeChecksumGet: {
                if (this.version < 2)
                    return false;
                const node = this.endpoint.getNodeUnsafe();
                const ret = (_d = node.getValue(getSupportsUserCodeChecksumValueID(this.endpoint.index))) !== null && _d !== void 0 ? _d : core_1.unknownBoolean;
                return ret;
            }
        }
        return super.supportsCommand(cmd);
    }
    async getUsersCount() {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.UsersNumberGet);
        const cc = new UserCodeCCUsersNumberGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedUsers;
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(userId, multiple = false) {
        if (userId > 255 || multiple) {
            this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.ExtendedUserCodeGet);
            const cc = new UserCodeCCExtendedUserCodeGet(this.driver, {
                nodeId: this.endpoint.nodeId,
                endpoint: this.endpoint.index,
                userId,
                reportMore: multiple,
            });
            const response = await this.driver.sendCommand(cc, this.commandOptions);
            if (!response) {
                return;
            }
            else if (multiple) {
                return shared_1.pick(response, ["userCodes", "nextUserId"]);
            }
            else {
                return shared_1.pick(response.userCodes[0], [
                    "userIdStatus",
                    "userCode",
                ]);
            }
        }
        else {
            this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.Get);
            const cc = new UserCodeCCGet(this.driver, {
                nodeId: this.endpoint.nodeId,
                endpoint: this.endpoint.index,
                userId,
            });
            const response = await this.driver.sendCommand(cc, this.commandOptions);
            if (response)
                return shared_1.pick(response, ["userIdStatus", "userCode"]);
        }
    }
    /** Configures a single user code */
    async set(userId, userIdStatus, userCode) {
        if (this.version > 1 || userId > 255) {
            return this.setMany([{ userId, userIdStatus, userCode }]);
        }
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.Set);
        const cc = new UserCodeCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            userId,
            userIdStatus,
            userCode,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    /** Configures multiple user codes */
    async setMany(codes) {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.ExtendedUserCodeSet);
        const cc = new UserCodeCCExtendedUserCodeSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            userCodes: codes,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    /**
     * Clears one or all user code
     * @param userId The user code to clear. If none or 0 is given, all codes are cleared
     */
    async clear(userId = 0) {
        if (this.version > 1 || userId > 255) {
            await this.setMany([
                { userId, userIdStatus: UserIDStatus.Available },
            ]);
        }
        else {
            this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.Set);
            const cc = new UserCodeCCSet(this.driver, {
                nodeId: this.endpoint.nodeId,
                endpoint: this.endpoint.index,
                userId,
                userIdStatus: UserIDStatus.Available,
            });
            await this.driver.sendCommand(cc, this.commandOptions);
        }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities() {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.CapabilitiesGet);
        const cc = new UserCodeCCCapabilitiesGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "supportsMasterCode",
                "supportsMasterCodeDeactivation",
                "supportsUserCodeChecksum",
                "supportsMultipleUserCodeReport",
                "supportsMultipleUserCodeSet",
                "supportedUserIDStatuses",
                "supportedKeypadModes",
                "supportedASCIIChars",
            ]);
        }
    }
    async getKeypadMode() {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.KeypadModeGet);
        const cc = new UserCodeCCKeypadModeGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.keypadMode;
    }
    async setKeypadMode(keypadMode) {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.KeypadModeSet);
        const cc = new UserCodeCCKeypadModeSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            keypadMode,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getMasterCode() {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.MasterCodeGet);
        const cc = new UserCodeCCMasterCodeGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.masterCode;
    }
    async setMasterCode(masterCode) {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.MasterCodeSet);
        const cc = new UserCodeCCMasterCodeSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            masterCode,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getUserCodeChecksum() {
        this.assertSupportsCommand(UserCodeCommand, UserCodeCommand.UserCodeChecksumGet);
        const cc = new UserCodeCCUserCodeChecksumGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.userCodeChecksum;
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
UserCodeCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["User Code"])
], UserCodeCCAPI);
exports.UserCodeCCAPI = UserCodeCCAPI;
let UserCodeCC = class UserCodeCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c, _d, _e, _f, _g;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["User Code"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Query capabilities first because they determine the next steps
        let supportsMasterCode = false;
        let supportsUserCodeChecksum = false;
        let supportedKeypadModes = [];
        let supportedUsers;
        if (complete) {
            if (this.version >= 2) {
                this.driver.controllerLog.logNode(node.id, {
                    message: "querying capabilities...",
                    direction: "outbound",
                });
                const caps = await api.getCapabilities();
                if (caps) {
                    supportsMasterCode = caps.supportsMasterCode;
                    supportsUserCodeChecksum = caps.supportsUserCodeChecksum;
                    supportedKeypadModes = caps.supportedKeypadModes;
                }
            }
            this.driver.controllerLog.logNode(node.id, {
                message: "querying number of user codes...",
                direction: "outbound",
            });
            supportedUsers = await api.getUsersCount();
            if (supportedUsers == undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying number of user codes timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
        }
        else {
            supportsMasterCode = (_c = node.getValue(getSupportsMasterCodeValueID(this.endpointIndex))) !== null && _c !== void 0 ? _c : false;
            supportsUserCodeChecksum = (_d = node.getValue(getSupportsUserCodeChecksumValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : false;
            supportedKeypadModes = (_e = node.getValue(getSupportedKeypadModesValueID(this.endpointIndex))) !== null && _e !== void 0 ? _e : [];
            supportedUsers = (_f = node.getValue(getSupportedUsersValueID(this.endpointIndex))) !== null && _f !== void 0 ? _f : 0;
        }
        // Now check for changed values and codes
        if (this.version >= 2) {
            if (supportsMasterCode) {
                this.driver.controllerLog.logNode(node.id, {
                    message: "querying master code...",
                    direction: "outbound",
                });
                await api.getMasterCode();
            }
            if (supportedKeypadModes.length > 1) {
                this.driver.controllerLog.logNode(node.id, {
                    message: "querying active keypad mode...",
                    direction: "outbound",
                });
                await api.getKeypadMode();
            }
            const storedUserCodeChecksum = (_g = node.getValue(getUserCodeChecksumValueID(this.endpointIndex))) !== null && _g !== void 0 ? _g : 0;
            let currentUserCodeChecksum = 0;
            if (supportsUserCodeChecksum) {
                this.driver.controllerLog.logNode(node.id, {
                    message: "retrieving current user code checksum...",
                    direction: "outbound",
                });
                currentUserCodeChecksum = await api.getUserCodeChecksum();
            }
            if (!supportsUserCodeChecksum ||
                currentUserCodeChecksum !== storedUserCodeChecksum) {
                this.driver.controllerLog.logNode(node.id, {
                    message: "checksum changed or is not supported, querying all user codes...",
                    direction: "outbound",
                });
                let nextUserId = 1;
                while (nextUserId > 0 && nextUserId <= supportedUsers) {
                    const response = await api.get(nextUserId, true);
                    if (response) {
                        nextUserId = response.nextUserId;
                    }
                    else {
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: `Querying user code #${nextUserId} timed out, skipping the remaining interview...`,
                            level: "warn",
                        });
                        break;
                    }
                }
            }
        }
        else {
            // V1
            this.driver.controllerLog.logNode(node.id, {
                message: "querying all user codes...",
                direction: "outbound",
            });
            for (let userId = 1; userId <= supportedUsers; userId++) {
                await api.get(userId);
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
UserCodeCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["User Code"]),
    CommandClass_1.implementedVersion(2)
], UserCodeCC);
exports.UserCodeCC = UserCodeCC;
let UserCodeCCSet = class UserCodeCCSet extends UserCodeCC {
    constructor(driver, options) {
        var _c, _d;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            const numUsers = (_d = (_c = this.getNode()) === null || _c === void 0 ? void 0 : _c.getValue(getSupportedUsersValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : 0;
            this.userId = options.userId;
            this.userIdStatus = options.userIdStatus;
            // Validate options
            if (this.userId < 0 || this.userId > numUsers) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The user ID must be between 0 and the number of supported users ${numUsers}.`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.userId === 0 &&
                this.userIdStatus !== UserIDStatus.Available) {
                throw new core_1.ZWaveError(`${this.constructor.name}: User ID 0 may only be used to clear all user codes`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.userIdStatus === UserIDStatus.Available) {
                this.userCode = "\0".repeat(4);
            }
            else {
                this.userCode = options.userCode;
                // Specs say ASCII 0-9, manufacturers don't care :)
                if (this.userCode.length < 4 || this.userCode.length > 10) {
                    throw new core_1.ZWaveError(`${this.constructor.name}: The user code must have a length of 4 to 10 ${typeof this.userCode === "string"
                        ? "characters"
                        : "bytes"}`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
            }
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.userId, this.userIdStatus]),
            typeof this.userCode === "string"
                ? Buffer.from(this.userCode, "ascii")
                : this.userCode,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "user id": this.userId,
                "id status": shared_1.getEnumMemberName(UserIDStatus, this.userIdStatus),
                "user code": typeof this.userCode === "string"
                    ? this.userCode
                    : shared_1.buffer2hex(this.userCode),
            },
        };
    }
};
UserCodeCCSet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.Set)
], UserCodeCCSet);
exports.UserCodeCCSet = UserCodeCCSet;
let UserCodeCCReport = class UserCodeCCReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.userId = this.payload[0];
        this.userIdStatus = this.payload[1];
        if (this.payload.length === 2 &&
            (this.userIdStatus === UserIDStatus.Available ||
                this.userIdStatus === UserIDStatus.StatusNotAvailable)) {
            // The user code is not set or not available and this report contains no user code
            this.userCode = "";
        }
        else {
            // The specs require the user code to be at least 4 digits
            core_1.validatePayload(this.payload.length >= 6);
            let userCodeBuffer = this.payload.slice(2);
            // Specs say infer user code from payload length, manufacturers send zero-padded strings
            while (userCodeBuffer[userCodeBuffer.length - 1] === 0) {
                userCodeBuffer = userCodeBuffer.slice(0, -1);
            }
            // Specs say ASCII 0-9, manufacturers don't care :)
            // Thus we check if the code is printable using ASCII, if not keep it as a Buffer
            const userCodeString = userCodeBuffer.toString("utf8");
            if (shared_1.isPrintableASCII(userCodeString)) {
                this.userCode = userCodeString;
            }
            else {
                this.userCode = userCodeBuffer;
            }
        }
        this.persistValues();
    }
    persistValues() {
        persistUserCode.call(this, this.userId, this.userIdStatus, this.userCode);
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "user id": this.userId,
                "id status": shared_1.getEnumMemberName(UserIDStatus, this.userIdStatus),
                "user code": typeof this.userCode === "string"
                    ? this.userCode
                    : shared_1.buffer2hex(this.userCode),
            },
        };
    }
};
UserCodeCCReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.Report)
], UserCodeCCReport);
exports.UserCodeCCReport = UserCodeCCReport;
let UserCodeCCGet = class UserCodeCCGet extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.userId = options.userId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.userId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "user id": this.userId },
        };
    }
};
UserCodeCCGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.Get),
    CommandClass_1.expectedCCResponse(UserCodeCCReport)
], UserCodeCCGet);
exports.UserCodeCCGet = UserCodeCCGet;
let UserCodeCCUsersNumberReport = class UserCodeCCUsersNumberReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        if (this.payload.length >= 3) {
            // V2+
            this.supportedUsers = this.payload.readUInt16BE(1);
        }
        else {
            // V1
            this.supportedUsers = this.payload[0];
        }
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "supported users": this.supportedUsers },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCUsersNumberReport.prototype, "supportedUsers", void 0);
UserCodeCCUsersNumberReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.UsersNumberReport)
], UserCodeCCUsersNumberReport);
exports.UserCodeCCUsersNumberReport = UserCodeCCUsersNumberReport;
let UserCodeCCUsersNumberGet = class UserCodeCCUsersNumberGet extends UserCodeCC {
};
UserCodeCCUsersNumberGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.UsersNumberGet),
    CommandClass_1.expectedCCResponse(UserCodeCCUsersNumberReport)
], UserCodeCCUsersNumberGet);
exports.UserCodeCCUsersNumberGet = UserCodeCCUsersNumberGet;
let UserCodeCCCapabilitiesReport = class UserCodeCCCapabilitiesReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        let offset = 0;
        core_1.validatePayload(this.payload.length >= offset + 1);
        this.supportsMasterCode = !!(this.payload[offset] & 128);
        this.supportsMasterCodeDeactivation = !!(this.payload[offset] & 64);
        const statusBitMaskLength = this.payload[offset] & 31;
        offset += 1;
        core_1.validatePayload(this.payload.length >= offset + statusBitMaskLength + 1);
        this.supportedUserIDStatuses = core_1.parseBitMask(this.payload.slice(offset, offset + statusBitMaskLength), UserIDStatus.Available);
        offset += statusBitMaskLength;
        this.supportsUserCodeChecksum = !!(this.payload[offset] & 128);
        this.supportsMultipleUserCodeReport = !!(this.payload[offset] & 64);
        this.supportsMultipleUserCodeSet = !!(this.payload[offset] & 32);
        const keypadModesBitMaskLength = this.payload[offset] & 31;
        offset += 1;
        core_1.validatePayload(this.payload.length >= offset + keypadModesBitMaskLength + 1);
        this.supportedKeypadModes = core_1.parseBitMask(this.payload.slice(offset, offset + keypadModesBitMaskLength), KeypadMode.Normal);
        offset += keypadModesBitMaskLength;
        const keysBitMaskLength = this.payload[offset] & 31;
        offset += 1;
        core_1.validatePayload(this.payload.length >= offset + keysBitMaskLength);
        this.supportedASCIIChars = Buffer.from(core_1.parseBitMask(this.payload.slice(offset, offset + keysBitMaskLength), 0)).toString("ascii");
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supports master code": this.supportsMasterCode,
                "supports master code deactivation": this
                    .supportsMasterCodeDeactivation,
                "supports user code checksum": this.supportsUserCodeChecksum,
                "supports multiple codes in report": this
                    .supportsMultipleUserCodeReport,
                "supports multiple codes in set": this
                    .supportsMultipleUserCodeSet,
                "supported user id statuses": this.supportedUserIDStatuses
                    .map((status) => `\n· ${shared_1.getEnumMemberName(UserIDStatus, status)}`)
                    .join(""),
                "supported keypad modes": this.supportedKeypadModes
                    .map((mode) => `\n· ${shared_1.getEnumMemberName(KeypadMode, mode)}`)
                    .join(""),
                "supported ASCII chars": this.supportedASCIIChars,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportsMasterCode", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportsMasterCodeDeactivation", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportsUserCodeChecksum", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportsMultipleUserCodeReport", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportsMultipleUserCodeSet", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportedUserIDStatuses", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportedKeypadModes", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCCapabilitiesReport.prototype, "supportedASCIIChars", void 0);
UserCodeCCCapabilitiesReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.CapabilitiesReport)
], UserCodeCCCapabilitiesReport);
exports.UserCodeCCCapabilitiesReport = UserCodeCCCapabilitiesReport;
let UserCodeCCCapabilitiesGet = class UserCodeCCCapabilitiesGet extends UserCodeCC {
};
UserCodeCCCapabilitiesGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.CapabilitiesGet),
    CommandClass_1.expectedCCResponse(UserCodeCCCapabilitiesReport)
], UserCodeCCCapabilitiesGet);
exports.UserCodeCCCapabilitiesGet = UserCodeCCCapabilitiesGet;
let UserCodeCCKeypadModeSet = class UserCodeCCKeypadModeSet extends UserCodeCC {
    constructor(driver, options) {
        var _c, _d;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (!this.interviewComplete) {
                throw new core_1.ZWaveError(`${this.constructor.name}: This CC can only be used after the interview is complete!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.keypadMode = options.keypadMode;
            const supportedModes = (_d = (_c = this.getNode()) === null || _c === void 0 ? void 0 : _c.getValue(getSupportedKeypadModesValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : [];
            if (!supportedModes.includes(this.keypadMode)) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The keypad mode ${shared_1.getEnumMemberName(KeypadMode, this.keypadMode)} is not supported by the node!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
        }
    }
    serialize() {
        this.payload = Buffer.from([this.keypadMode]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { mode: shared_1.getEnumMemberName(KeypadMode, this.keypadMode) },
        };
    }
};
UserCodeCCKeypadModeSet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.KeypadModeSet)
], UserCodeCCKeypadModeSet);
exports.UserCodeCCKeypadModeSet = UserCodeCCKeypadModeSet;
let UserCodeCCKeypadModeReport = class UserCodeCCKeypadModeReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.keypadMode = this.payload[0];
        this.persistValues();
    }
    persistValues() {
        var _c;
        if (!super.persistValues())
            return false;
        // Update the keypad modes metadata
        const supportedKeypadModes = (_c = this.getValueDB().getValue(getSupportedKeypadModesValueID(this.endpointIndex))) !== null && _c !== void 0 ? _c : [this.keypadMode];
        const valueId = getKeypadModeValueID(this.endpointIndex);
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.ReadOnlyNumber,
            label: "Keypad Mode",
            states: core_1.enumValuesToMetadataStates(KeypadMode, supportedKeypadModes),
        });
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                keypadMode: shared_1.getEnumMemberName(KeypadMode, this.keypadMode),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 })
], UserCodeCCKeypadModeReport.prototype, "keypadMode", void 0);
UserCodeCCKeypadModeReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.KeypadModeReport)
], UserCodeCCKeypadModeReport);
exports.UserCodeCCKeypadModeReport = UserCodeCCKeypadModeReport;
let UserCodeCCKeypadModeGet = class UserCodeCCKeypadModeGet extends UserCodeCC {
};
UserCodeCCKeypadModeGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.KeypadModeGet),
    CommandClass_1.expectedCCResponse(UserCodeCCKeypadModeReport)
], UserCodeCCKeypadModeGet);
exports.UserCodeCCKeypadModeGet = UserCodeCCKeypadModeGet;
let UserCodeCCMasterCodeSet = class UserCodeCCMasterCodeSet extends UserCodeCC {
    constructor(driver, options) {
        var _c, _d, _e, _f;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (!this.interviewComplete) {
                throw new core_1.ZWaveError(`${this.constructor.name}: This CC can only be used after the interview is complete!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            const supportedAsciiChars = (_d = (_c = this.getNode()) === null || _c === void 0 ? void 0 : _c.getValue(getSupportedASCIICharsValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : "";
            this.masterCode = options.masterCode;
            // Validate the code
            if (!this.masterCode) {
                const supportsDeactivation = (_f = (_e = this.getNode()) === null || _e === void 0 ? void 0 : _e.getValue(getSupportsMasterCodeDeactivationValueID(this.endpointIndex))) !== null && _f !== void 0 ? _f : false;
                if (!supportsDeactivation) {
                    throw new core_1.ZWaveError(`${this.constructor.name}: The node does not support deactivating the master code!`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
            }
            else if (!validateCode(this.masterCode, supportedAsciiChars)) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The master code must consist of 4 to 10 of the following characters: ${supportedAsciiChars}`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
        }
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.masterCode.length & 0b11111]),
            Buffer.from(this.masterCode, "ascii"),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "master code": this.masterCode },
        };
    }
};
UserCodeCCMasterCodeSet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.MasterCodeSet)
], UserCodeCCMasterCodeSet);
exports.UserCodeCCMasterCodeSet = UserCodeCCMasterCodeSet;
let UserCodeCCMasterCodeReport = class UserCodeCCMasterCodeReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        const codeLength = this.payload[0] & 0b1111;
        core_1.validatePayload(this.payload.length >= 1 + codeLength);
        this.masterCode = this.payload
            .slice(1, 1 + codeLength)
            .toString("ascii");
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "master code": this.masterCode },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.String,
        label: "Master Code",
        minLength: 4,
        maxLength: 10,
    })
], UserCodeCCMasterCodeReport.prototype, "masterCode", void 0);
UserCodeCCMasterCodeReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.MasterCodeReport)
], UserCodeCCMasterCodeReport);
exports.UserCodeCCMasterCodeReport = UserCodeCCMasterCodeReport;
let UserCodeCCMasterCodeGet = class UserCodeCCMasterCodeGet extends UserCodeCC {
};
UserCodeCCMasterCodeGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.MasterCodeGet),
    CommandClass_1.expectedCCResponse(UserCodeCCMasterCodeReport)
], UserCodeCCMasterCodeGet);
exports.UserCodeCCMasterCodeGet = UserCodeCCMasterCodeGet;
let UserCodeCCUserCodeChecksumReport = class UserCodeCCUserCodeChecksumReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.userCodeChecksum = this.payload.readUInt16BE(0);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "user code checksum": shared_1.num2hex(this.userCodeChecksum) },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], UserCodeCCUserCodeChecksumReport.prototype, "userCodeChecksum", void 0);
UserCodeCCUserCodeChecksumReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.UserCodeChecksumReport)
], UserCodeCCUserCodeChecksumReport);
exports.UserCodeCCUserCodeChecksumReport = UserCodeCCUserCodeChecksumReport;
let UserCodeCCUserCodeChecksumGet = class UserCodeCCUserCodeChecksumGet extends UserCodeCC {
};
UserCodeCCUserCodeChecksumGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.UserCodeChecksumGet),
    CommandClass_1.expectedCCResponse(UserCodeCCUserCodeChecksumReport)
], UserCodeCCUserCodeChecksumGet);
exports.UserCodeCCUserCodeChecksumGet = UserCodeCCUserCodeChecksumGet;
let UserCodeCCExtendedUserCodeSet = class UserCodeCCExtendedUserCodeSet extends UserCodeCC {
    constructor(driver, options) {
        var _c, _d, _e, _f, _g, _h, _j, _k;
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (!this.interviewComplete) {
                throw new core_1.ZWaveError(`${this.constructor.name}: This CC can only be used after the interview is complete!`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.userCodes = options.userCodes;
            const numUsers = (_d = (_c = this.getNode()) === null || _c === void 0 ? void 0 : _c.getValue(getSupportedUsersValueID(this.endpointIndex))) !== null && _d !== void 0 ? _d : 0;
            const supportedStatuses = (_f = (_e = this.getNode()) === null || _e === void 0 ? void 0 : _e.getValue(getSupportedUserIDStatusesValueID(this.endpointIndex))) !== null && _f !== void 0 ? _f : [];
            const supportedAsciiChars = (_h = (_g = this.getNode()) === null || _g === void 0 ? void 0 : _g.getValue(getSupportedASCIICharsValueID(this.endpointIndex))) !== null && _h !== void 0 ? _h : "";
            const supportsMultipleUserCodeSet = (_k = (_j = this.getNode()) === null || _j === void 0 ? void 0 : _j.getValue(getSupportsMultipleUserCodeSetValueID(this.endpointIndex))) !== null && _k !== void 0 ? _k : false;
            // Validate options
            if (this.userCodes.some((code) => code.userId < 0 || code.userId > numUsers)) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The user ID must be between 0 and the number of supported users ${numUsers}.`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.userCodes.some((code) => code.userId === 0) &&
                this.userCodes.length > 1) {
                throw new core_1.ZWaveError(`${this.constructor.name}: If user ID 0 is used, only one code may be set`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.userCodes.some((code) => code.userId === 0 &&
                code.userIdStatus !== UserIDStatus.Available)) {
                throw new core_1.ZWaveError(`${this.constructor.name}: User ID 0 may only be used to clear all user codes`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            else if (this.userCodes.length > 1 &&
                !supportsMultipleUserCodeSet) {
                throw new core_1.ZWaveError(`${this.constructor.name}: The node does not support setting multiple user codes at once`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            for (const code of this.userCodes) {
                if (!supportedStatuses.includes(code.userIdStatus)) {
                    throw new core_1.ZWaveError(`${this.constructor.name}: The user ID status ${shared_1.getEnumMemberName(UserIDStatus, code.userIdStatus)} is not supported by the node`, core_1.ZWaveErrorCodes.Argument_Invalid);
                }
                else if (code.userIdStatus === UserIDStatus.Available) {
                    code.userCode = "";
                }
                else {
                    if (!validateCode(code.userCode, supportedAsciiChars)) {
                        throw new core_1.ZWaveError(`${this.constructor.name}: The user code must consist of 4 to 10 of the following characters: ${supportedAsciiChars}`, core_1.ZWaveErrorCodes.Argument_Invalid);
                    }
                }
            }
        }
    }
    serialize() {
        const userCodeBuffers = this.userCodes.map((code) => {
            const ret = Buffer.concat([
                Buffer.from([0, 0, code.userIdStatus, code.userCode.length]),
                Buffer.from(code.userCode, "ascii"),
            ]);
            ret.writeUInt16BE(code.userId, 0);
            return ret;
        });
        this.payload = Buffer.concat([
            Buffer.from([this.userCodes.length]),
            ...userCodeBuffers,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = {};
        for (const { userId, userIdStatus, userCode } of this.userCodes) {
            message[`code #${userId}`] = `${userCode} (status: ${shared_1.getEnumMemberName(UserIDStatus, userIdStatus)})`;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
UserCodeCCExtendedUserCodeSet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.ExtendedUserCodeSet)
], UserCodeCCExtendedUserCodeSet);
exports.UserCodeCCExtendedUserCodeSet = UserCodeCCExtendedUserCodeSet;
let UserCodeCCExtendedUserCodeReport = class UserCodeCCExtendedUserCodeReport extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        const numCodes = this.payload[0];
        let offset = 1;
        const userCodes = [];
        // parse each user code
        for (let i = 0; i < numCodes; i++) {
            const { code, bytesRead } = parseExtendedUserCode(this.payload.slice(offset));
            userCodes.push(code);
            offset += bytesRead;
        }
        this.userCodes = userCodes;
        core_1.validatePayload(this.payload.length >= offset + 2);
        this.nextUserId = this.payload.readUInt16BE(offset);
        this.persistValues();
    }
    persistValues() {
        for (const { userId, userIdStatus, userCode } of this.userCodes) {
            persistUserCode.call(this, userId, userIdStatus, userCode);
        }
        return true;
    }
    toLogEntry() {
        const message = {};
        for (const { userId, userIdStatus, userCode } of this.userCodes) {
            message[`code #${userId}`] = `${userCode} (status: ${shared_1.getEnumMemberName(UserIDStatus, userIdStatus)})`;
        }
        message["next user id"] = this.nextUserId;
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
UserCodeCCExtendedUserCodeReport = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.ExtendedUserCodeReport)
], UserCodeCCExtendedUserCodeReport);
exports.UserCodeCCExtendedUserCodeReport = UserCodeCCExtendedUserCodeReport;
let UserCodeCCExtendedUserCodeGet = class UserCodeCCExtendedUserCodeGet extends UserCodeCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.userId = options.userId;
            this.reportMore = !!options.reportMore;
        }
    }
    serialize() {
        this.payload = Buffer.from([0, 0, this.reportMore ? 1 : 0]);
        this.payload.writeUInt16BE(this.userId, 0);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "user id": this.userId,
                "report more": this.reportMore,
            },
        };
    }
};
UserCodeCCExtendedUserCodeGet = __decorate([
    CommandClass_1.CCCommand(UserCodeCommand.ExtendedUserCodeGet),
    CommandClass_1.expectedCCResponse(UserCodeCCExtendedUserCodeReport)
], UserCodeCCExtendedUserCodeGet);
exports.UserCodeCCExtendedUserCodeGet = UserCodeCCExtendedUserCodeGet;

//# sourceMappingURL=UserCodeCC.js.map
