/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import type { ZWaveNode } from "../node/Node";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare function getWakeUpIntervalValueId(): ValueID;
export declare enum WakeUpCommand {
    IntervalSet = 4,
    IntervalGet = 5,
    IntervalReport = 6,
    WakeUpNotification = 7,
    NoMoreInformation = 8,
    IntervalCapabilitiesGet = 9,
    IntervalCapabilitiesReport = 10
}
export declare class WakeUpCCAPI extends CCAPI {
    supportsCommand(cmd: WakeUpCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    getInterval(): Promise<Pick<WakeUpCCIntervalReport, "wakeUpInterval" | "controllerNodeId"> | undefined>;
    getIntervalCapabilities(): Promise<Pick<WakeUpCCIntervalCapabilitiesReport, "defaultWakeUpInterval" | "minWakeUpInterval" | "maxWakeUpInterval" | "wakeUpIntervalSteps"> | undefined>;
    setInterval(wakeUpInterval: number, controllerNodeId: number): Promise<void>;
    sendNoMoreInformation(): Promise<void>;
}
export declare class WakeUpCC extends CommandClass {
    ccCommand: WakeUpCommand;
    isAwake(): boolean;
    static isAwake(node: ZWaveNode): boolean;
    interview(complete?: boolean): Promise<void>;
}
interface WakeUpCCIntervalSetOptions extends CCCommandOptions {
    wakeUpInterval: number;
    controllerNodeId: number;
}
export declare class WakeUpCCIntervalSet extends WakeUpCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | WakeUpCCIntervalSetOptions);
    wakeUpInterval: number;
    controllerNodeId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class WakeUpCCIntervalReport extends WakeUpCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _wakeUpInterval;
    get wakeUpInterval(): number;
    private _controllerNodeId;
    get controllerNodeId(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class WakeUpCCIntervalGet extends WakeUpCC {
}
export declare class WakeUpCCWakeUpNotification extends WakeUpCC {
}
export declare class WakeUpCCNoMoreInformation extends WakeUpCC {
}
export declare class WakeUpCCIntervalCapabilitiesReport extends WakeUpCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _minWakeUpInterval;
    get minWakeUpInterval(): number;
    private _maxWakeUpInterval;
    get maxWakeUpInterval(): number;
    private _defaultWakeUpInterval;
    get defaultWakeUpInterval(): number;
    private _wakeUpIntervalSteps;
    get wakeUpIntervalSteps(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class WakeUpCCIntervalCapabilitiesGet extends WakeUpCC {
}
export {};
