"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteReturnRouteRequestTransmitReport = exports.DeleteReturnRouteResponse = exports.DeleteReturnRouteRequest = exports.DeleteReturnRouteRequestBase = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const SendDataMessages_1 = require("./SendDataMessages");
let DeleteReturnRouteRequestBase = class DeleteReturnRouteRequestBase extends Message_1.Message {
    constructor(driver, options) {
        if (Message_1.gotDeserializationOptions(options) &&
            (new.target) !== DeleteReturnRouteRequestTransmitReport) {
            return new DeleteReturnRouteRequestTransmitReport(driver, options);
        }
        super(driver, options);
    }
};
DeleteReturnRouteRequestBase = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.DeleteReturnRoute),
    Message_1.priority(Constants_1.MessagePriority.NodeQuery)
], DeleteReturnRouteRequestBase);
exports.DeleteReturnRouteRequestBase = DeleteReturnRouteRequestBase;
let DeleteReturnRouteRequest = class DeleteReturnRouteRequest extends DeleteReturnRouteRequestBase {
    constructor(driver, options) {
        super(driver, options);
        if (Message_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.nodeId = options.nodeId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.nodeId, this.callbackId]);
        return super.serialize();
    }
};
DeleteReturnRouteRequest = __decorate([
    Message_1.expectedResponse(Constants_1.FunctionType.DeleteReturnRoute),
    Message_1.expectedCallback(Constants_1.FunctionType.DeleteReturnRoute)
], DeleteReturnRouteRequest);
exports.DeleteReturnRouteRequest = DeleteReturnRouteRequest;
let DeleteReturnRouteResponse = class DeleteReturnRouteResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this.hasStarted = this.payload[0] !== 0;
    }
    isOK() {
        return this.hasStarted;
    }
    toJSON() {
        return super.toJSONInherited({
            hasStarted: this.hasStarted,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "has started": this.hasStarted },
        };
    }
};
DeleteReturnRouteResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.DeleteReturnRoute)
], DeleteReturnRouteResponse);
exports.DeleteReturnRouteResponse = DeleteReturnRouteResponse;
class DeleteReturnRouteRequestTransmitReport extends DeleteReturnRouteRequestBase {
    constructor(driver, options) {
        super(driver, options);
        this.callbackId = this.payload[0];
        this._transmitStatus = this.payload[1];
    }
    get transmitStatus() {
        return this._transmitStatus;
    }
    isOK() {
        return this._transmitStatus === SendDataMessages_1.TransmitStatus.OK;
    }
    toJSON() {
        return super.toJSONInherited({
            callbackId: this.callbackId,
            transmitStatus: this.transmitStatus,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId,
                "transmit status": shared_1.getEnumMemberName(SendDataMessages_1.TransmitStatus, this.transmitStatus),
            },
        };
    }
}
exports.DeleteReturnRouteRequestTransmitReport = DeleteReturnRouteRequestTransmitReport;

//# sourceMappingURL=DeleteReturnRouteMessages.js.map
