/// <reference types="node" />
import { CommandClasses } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
export declare enum RemoveNodeType {
    Any = 1,
    Controller = 2,
    Slave = 3,
    Stop = 5
}
export declare enum RemoveNodeStatus {
    Ready = 1,
    NodeFound = 2,
    RemovingSlave = 3,
    RemovingController = 4,
    Done = 6,
    Failed = 7
}
interface RemoveNodeFromNetworkRequestOptions extends MessageBaseOptions {
    removeNodeType?: RemoveNodeType;
    highPower?: boolean;
    networkWide?: boolean;
}
export declare class RemoveNodeFromNetworkRequest extends Message {
    constructor(driver: Driver, options?: MessageDeserializationOptions | RemoveNodeFromNetworkRequestOptions);
    /** The type of node to add */
    removeNodeType: RemoveNodeType | undefined;
    /** Whether to use high power */
    highPower: boolean;
    /** Whether to include network wide */
    networkWide: boolean;
    private _status;
    get status(): RemoveNodeStatus | undefined;
    private _statusContext;
    get statusContext(): RemoveNodeStatusContext | undefined;
    serialize(): Buffer;
}
interface RemoveNodeStatusContext {
    nodeId: number;
    basic?: number;
    generic?: number;
    specific?: number;
    supportedCCs?: CommandClasses[];
    controlledCCs?: CommandClasses[];
}
export {};
