"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestNodeNeighborUpdateReport = exports.RequestNodeNeighborUpdateRequest = exports.RequestNodeNeighborUpdateRequestBase = exports.NodeNeighborUpdateStatus = void 0;
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
var NodeNeighborUpdateStatus;
(function (NodeNeighborUpdateStatus) {
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateStarted"] = 33] = "UpdateStarted";
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateDone"] = 34] = "UpdateDone";
    NodeNeighborUpdateStatus[NodeNeighborUpdateStatus["UpdateFailed"] = 35] = "UpdateFailed";
})(NodeNeighborUpdateStatus = exports.NodeNeighborUpdateStatus || (exports.NodeNeighborUpdateStatus = {}));
let RequestNodeNeighborUpdateRequestBase = class RequestNodeNeighborUpdateRequestBase extends Message_1.Message {
    constructor(driver, options) {
        if (Message_1.gotDeserializationOptions(options) &&
            (new.target) !== RequestNodeNeighborUpdateReport) {
            return new RequestNodeNeighborUpdateReport(driver, options);
        }
        super(driver, options);
    }
};
RequestNodeNeighborUpdateRequestBase = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.RequestNodeNeighborUpdate),
    Message_1.priority(Constants_1.MessagePriority.Controller)
], RequestNodeNeighborUpdateRequestBase);
exports.RequestNodeNeighborUpdateRequestBase = RequestNodeNeighborUpdateRequestBase;
let RequestNodeNeighborUpdateRequest = class RequestNodeNeighborUpdateRequest extends RequestNodeNeighborUpdateRequestBase {
    constructor(driver, options) {
        super(driver, options);
        this.nodeId = options.nodeId;
    }
    serialize() {
        this.payload = Buffer.from([this.nodeId, this.callbackId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "callback id": this.callbackId },
        };
    }
};
RequestNodeNeighborUpdateRequest = __decorate([
    Message_1.expectedCallback(Constants_1.FunctionType.RequestNodeNeighborUpdate)
], RequestNodeNeighborUpdateRequest);
exports.RequestNodeNeighborUpdateRequest = RequestNodeNeighborUpdateRequest;
class RequestNodeNeighborUpdateReport extends RequestNodeNeighborUpdateRequestBase {
    constructor(driver, options) {
        super(driver, options);
        this.callbackId = this.payload[0];
        this._updateStatus = this.payload[1];
    }
    isOK() {
        return this._updateStatus !== NodeNeighborUpdateStatus.UpdateFailed;
    }
    isFinal() {
        return this._updateStatus === NodeNeighborUpdateStatus.UpdateDone;
    }
    get updateStatus() {
        return this._updateStatus;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId,
                "update status": shared_1.getEnumMemberName(NodeNeighborUpdateStatus, this._updateStatus),
            },
        };
    }
}
exports.RequestNodeNeighborUpdateReport = RequestNodeNeighborUpdateReport;

//# sourceMappingURL=RequestNodeNeighborUpdateMessages.js.map
