/// <reference types="node" />
import { MessageOrCCLogEntry } from "@zwave-js/core";
import { JSONObject } from "@zwave-js/shared";
import type { CommandClass, MulticastCC, SinglecastCC } from "../commandclass/CommandClass";
import type { ICommandClassContainer } from "../commandclass/ICommandClassContainer";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions, MessageOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
export declare enum TransmitOptions {
    NotSet = 0,
    ACK = 1,
    LowPower = 2,
    AutoRoute = 4,
    NoRoute = 16,
    Explore = 32,
    DEFAULT = 37
}
export declare enum TransmitStatus {
    OK = 0,
    NoAck = 1,
    Fail = 2,
    NotIdle = 3,
    NoRoute = 4
}
export declare const MAX_SEND_ATTEMPTS = 5;
export declare class SendDataRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
interface SendDataRequestOptions<CCType extends CommandClass = CommandClass> extends MessageBaseOptions {
    command: CCType;
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
}
export declare class SendDataRequest<CCType extends CommandClass = CommandClass> extends SendDataRequestBase implements ICommandClassContainer {
    constructor(driver: Driver, options: SendDataRequestOptions<CCType>);
    /** The command this message contains */
    command: SinglecastCC<CCType>;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    serialize(): Buffer;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
    /** Computes the maximum payload size that can be transmitted with this message */
    getMaxPayloadLength(): number;
}
interface SendDataRequestTransmitReportOptions extends MessageBaseOptions {
    transmitStatus: TransmitStatus;
    callbackId: number;
}
export declare class SendDataRequestTransmitReport extends SendDataRequestBase implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions | SendDataRequestTransmitReportOptions);
    private _transmitStatus;
    get transmitStatus(): TransmitStatus;
    isOK(): boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    private _wasSent;
    get wasSent(): boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataMulticastRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
interface SendDataMulticastRequestOptions<CCType extends CommandClass> extends MessageBaseOptions {
    command: CCType;
    transmitOptions?: TransmitOptions;
    maxSendAttempts?: number;
}
export declare class SendDataMulticastRequest<CCType extends CommandClass = CommandClass> extends SendDataMulticastRequestBase implements ICommandClassContainer {
    constructor(driver: Driver, options: SendDataMulticastRequestOptions<CCType>);
    /** The command this message contains */
    command: MulticastCC<CCType>;
    /** Options regarding the transmission of the message */
    transmitOptions: TransmitOptions;
    private _maxSendAttempts;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts(): number;
    set maxSendAttempts(value: number);
    serialize(): Buffer;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SendDataMulticastRequestTransmitReportOptions extends MessageBaseOptions {
    transmitStatus: TransmitStatus;
    callbackId: number;
}
export declare class SendDataMulticastRequestTransmitReport extends SendDataMulticastRequestBase implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions | SendDataMulticastRequestTransmitReportOptions);
    private _transmitStatus;
    get transmitStatus(): TransmitStatus;
    isOK(): boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataMulticastResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    private _wasSent;
    get wasSent(): boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class SendDataAbort extends Message {
}
/** Checks whether the message is a report that tells us that a message was sent */
export declare function isSendReport(msg: Message): msg is SendDataResponse | SendDataMulticastResponse;
/** Checks whether the message is a report that contains the transmit status of a message */
export declare function isTransmitReport(msg: Message): msg is SendDataRequestTransmitReport | SendDataMulticastRequestTransmitReport;
export {};
