"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTransmitReport = exports.isSendReport = exports.SendDataAbort = exports.SendDataMulticastResponse = exports.SendDataMulticastRequestTransmitReport = exports.SendDataMulticastRequest = exports.SendDataMulticastRequestBase = exports.SendDataResponse = exports.SendDataRequestTransmitReport = exports.SendDataRequest = exports.SendDataRequestBase = exports.MAX_SEND_ATTEMPTS = exports.TransmitStatus = exports.TransmitOptions = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const math_1 = require("alcalzone-shared/math");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
var TransmitOptions;
(function (TransmitOptions) {
    TransmitOptions[TransmitOptions["NotSet"] = 0] = "NotSet";
    TransmitOptions[TransmitOptions["ACK"] = 1] = "ACK";
    TransmitOptions[TransmitOptions["LowPower"] = 2] = "LowPower";
    TransmitOptions[TransmitOptions["AutoRoute"] = 4] = "AutoRoute";
    TransmitOptions[TransmitOptions["NoRoute"] = 16] = "NoRoute";
    TransmitOptions[TransmitOptions["Explore"] = 32] = "Explore";
    TransmitOptions[TransmitOptions["DEFAULT"] = 37] = "DEFAULT";
})(TransmitOptions = exports.TransmitOptions || (exports.TransmitOptions = {}));
var TransmitStatus;
(function (TransmitStatus) {
    TransmitStatus[TransmitStatus["OK"] = 0] = "OK";
    TransmitStatus[TransmitStatus["NoAck"] = 1] = "NoAck";
    TransmitStatus[TransmitStatus["Fail"] = 2] = "Fail";
    TransmitStatus[TransmitStatus["NotIdle"] = 3] = "NotIdle";
    TransmitStatus[TransmitStatus["NoRoute"] = 4] = "NoRoute";
})(TransmitStatus = exports.TransmitStatus || (exports.TransmitStatus = {}));
exports.MAX_SEND_ATTEMPTS = 5;
let SendDataRequestBase = class SendDataRequestBase extends Message_1.Message {
    constructor(driver, options) {
        if (Message_1.gotDeserializationOptions(options) &&
            (new.target) !== SendDataRequestTransmitReport) {
            return new SendDataRequestTransmitReport(driver, options);
        }
        super(driver, options);
    }
};
SendDataRequestBase = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.SendData),
    Message_1.priority(Constants_1.MessagePriority.Normal)
], SendDataRequestBase);
exports.SendDataRequestBase = SendDataRequestBase;
let SendDataRequest = class SendDataRequest extends SendDataRequestBase {
    constructor(driver, options) {
        var _a, _b;
        super(driver, options);
        this._maxSendAttempts = 1;
        if (!options.command.isSinglecast()) {
            throw new core_1.ZWaveError(`SendDataRequest can only be used for singlecast and broadcast CCs`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        this.command = options.command;
        this.transmitOptions = (_a = options.transmitOptions) !== null && _a !== void 0 ? _a : TransmitOptions.DEFAULT;
        this.maxSendAttempts = (_b = options.maxSendAttempts) !== null && _b !== void 0 ? _b : driver.options.attempts.sendData;
    }
    /** The number of times the driver may try to send this message */
    get maxSendAttempts() {
        return this._maxSendAttempts;
    }
    set maxSendAttempts(value) {
        this._maxSendAttempts = math_1.clamp(value, 1, exports.MAX_SEND_ATTEMPTS);
    }
    serialize() {
        const serializedCC = this.command.serialize();
        this.payload = Buffer.concat([
            Buffer.from([this.command.nodeId, serializedCC.length]),
            serializedCC,
            Buffer.from([this.transmitOptions, this.callbackId]),
        ]);
        return super.serialize();
    }
    toJSON() {
        return super.toJSONInherited({
            transmitOptions: this.transmitOptions,
            callbackId: this.callbackId,
            command: this.command,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "transmit options": shared_1.num2hex(this.transmitOptions),
                "callback id": this.callbackId,
            },
        };
    }
    /** Computes the maximum payload size that can be transmitted with this message */
    getMaxPayloadLength() {
        // From INS13954-7, chapter 4.3.3.1.5
        if (this.transmitOptions & TransmitOptions.Explore)
            return 46;
        if (this.transmitOptions & TransmitOptions.AutoRoute)
            return 48;
        return 54;
    }
};
SendDataRequest = __decorate([
    Message_1.expectedResponse(Constants_1.FunctionType.SendData),
    Message_1.expectedCallback(Constants_1.FunctionType.SendData)
], SendDataRequest);
exports.SendDataRequest = SendDataRequest;
class SendDataRequestTransmitReport extends SendDataRequestBase {
    constructor(driver, options) {
        super(driver, options);
        if (Message_1.gotDeserializationOptions(options)) {
            this.callbackId = this.payload[0];
            this._transmitStatus = this.payload[1];
            // not sure what bytes 2 and 3 mean
            // the CC seems not to be included in this, but rather come in an application command later
        }
        else {
            this.callbackId = options.callbackId;
            this._transmitStatus = options.transmitStatus;
        }
    }
    get transmitStatus() {
        return this._transmitStatus;
    }
    isOK() {
        return this._transmitStatus === TransmitStatus.OK;
    }
    toJSON() {
        return super.toJSONInherited({
            callbackId: this.callbackId,
            transmitStatus: this.transmitStatus,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId,
                "transmit status": shared_1.getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
exports.SendDataRequestTransmitReport = SendDataRequestTransmitReport;
let SendDataResponse = class SendDataResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this._wasSent = this.payload[0] !== 0;
        // if (!this._wasSent) this._errorCode = this.payload[0];
    }
    isOK() {
        return this._wasSent;
    }
    get wasSent() {
        return this._wasSent;
    }
    // private _errorCode: number;
    // public get errorCode(): number {
    // 	return this._errorCode;
    // }
    toJSON() {
        return super.toJSONInherited({
            wasSent: this.wasSent,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "was sent": this.wasSent },
        };
    }
};
SendDataResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.SendData)
], SendDataResponse);
exports.SendDataResponse = SendDataResponse;
let SendDataMulticastRequestBase = class SendDataMulticastRequestBase extends Message_1.Message {
    constructor(driver, options) {
        if (Message_1.gotDeserializationOptions(options) &&
            (new.target) !== SendDataMulticastRequestTransmitReport) {
            return new SendDataMulticastRequestTransmitReport(driver, options);
        }
        super(driver, options);
    }
};
SendDataMulticastRequestBase = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.SendDataMulticast),
    Message_1.priority(Constants_1.MessagePriority.Normal)
], SendDataMulticastRequestBase);
exports.SendDataMulticastRequestBase = SendDataMulticastRequestBase;
let SendDataMulticastRequest = class SendDataMulticastRequest extends SendDataMulticastRequestBase {
    constructor(driver, options) {
        var _a, _b;
        super(driver, options);
        this._maxSendAttempts = 1;
        if (!options.command.isMulticast()) {
            throw new core_1.ZWaveError(`SendDataMulticastRequest can only be used for multicast CCs`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        else if (options.command.nodeId.length === 0) {
            throw new core_1.ZWaveError(`At least one node must be targeted`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        else if (options.command.nodeId.some((n) => n < 1 || n > core_1.MAX_NODES)) {
            throw new core_1.ZWaveError(`All node IDs must be between 1 and ${core_1.MAX_NODES}!`, core_1.ZWaveErrorCodes.Argument_Invalid);
        }
        this.command = options.command;
        this.transmitOptions = (_a = options.transmitOptions) !== null && _a !== void 0 ? _a : TransmitOptions.DEFAULT;
        this.maxSendAttempts = (_b = options.maxSendAttempts) !== null && _b !== void 0 ? _b : driver.options.attempts.sendData;
    }
    /** The number of times the driver may try to send this message */
    get maxSendAttempts() {
        return this._maxSendAttempts;
    }
    set maxSendAttempts(value) {
        this._maxSendAttempts = math_1.clamp(value, 1, exports.MAX_SEND_ATTEMPTS);
    }
    serialize() {
        // The payload CC must not include the target node ids, so strip the header out
        const serializedCC = this.command.serialize();
        this.payload = Buffer.concat([
            // # of target nodes and nodeIds
            Buffer.from([
                this.command.nodeId.length,
                ...this.command.nodeId,
                serializedCC.length,
            ]),
            // payload
            serializedCC,
            Buffer.from([this.transmitOptions, this.callbackId]),
        ]);
        return super.serialize();
    }
    toJSON() {
        return super.toJSONInherited({
            transmitOptions: this.transmitOptions,
            callbackId: this.callbackId,
            command: this.command,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "target nodes": this.command.nodeId.join(", "),
                "transmit options": shared_1.num2hex(this.transmitOptions),
                "callback id": this.callbackId,
            },
        };
    }
};
SendDataMulticastRequest = __decorate([
    Message_1.expectedResponse(Constants_1.FunctionType.SendDataMulticast),
    Message_1.expectedCallback(Constants_1.FunctionType.SendDataMulticast)
], SendDataMulticastRequest);
exports.SendDataMulticastRequest = SendDataMulticastRequest;
class SendDataMulticastRequestTransmitReport extends SendDataMulticastRequestBase {
    constructor(driver, options) {
        super(driver, options);
        if (Message_1.gotDeserializationOptions(options)) {
            this.callbackId = this.payload[0];
            this._transmitStatus = this.payload[1];
            // not sure what bytes 2 and 3 mean
            // the CC seems not to be included in this, but rather come in an application command later
        }
        else {
            this.callbackId = options.callbackId;
            this._transmitStatus = options.transmitStatus;
        }
    }
    get transmitStatus() {
        return this._transmitStatus;
    }
    isOK() {
        return this._transmitStatus === TransmitStatus.OK;
    }
    toJSON() {
        return super.toJSONInherited({
            callbackId: this.callbackId,
            transmitStatus: this.transmitStatus,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId,
                "transmit status": shared_1.getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
exports.SendDataMulticastRequestTransmitReport = SendDataMulticastRequestTransmitReport;
let SendDataMulticastResponse = class SendDataMulticastResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this._wasSent = this.payload[0] !== 0;
        // if (!this._wasSent) this._errorCode = this.payload[0];
    }
    isOK() {
        return this._wasSent;
    }
    get wasSent() {
        return this._wasSent;
    }
    toJSON() {
        return super.toJSONInherited({
            wasSent: this.wasSent,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "was sent": this.wasSent },
        };
    }
};
SendDataMulticastResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.SendDataMulticast)
], SendDataMulticastResponse);
exports.SendDataMulticastResponse = SendDataMulticastResponse;
let SendDataAbort = class SendDataAbort extends Message_1.Message {
};
SendDataAbort = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.SendDataAbort),
    Message_1.priority(Constants_1.MessagePriority.Controller)
], SendDataAbort);
exports.SendDataAbort = SendDataAbort;
/** Checks whether the message is a report that tells us that a message was sent */
function isSendReport(msg) {
    return (msg instanceof SendDataResponse ||
        msg instanceof SendDataMulticastResponse);
}
exports.isSendReport = isSendReport;
/** Checks whether the message is a report that contains the transmit status of a message */
function isTransmitReport(msg) {
    return (msg instanceof SendDataRequestTransmitReport ||
        msg instanceof SendDataMulticastRequestTransmitReport);
}
exports.isTransmitReport = isTransmitReport;

//# sourceMappingURL=SendDataMessages.js.map
