import { ZWaveErrorCodes } from "@zwave-js/core";
import { SortedList } from "alcalzone-shared/sorted-list";
import { Interpreter, StateMachine } from "xstate";
import { ApplicationCommandRequest } from "../controller/ApplicationCommandRequest";
import { BridgeApplicationCommandRequest } from "../controller/BridgeApplicationCommandRequest";
import { MessagePriority } from "../message/Constants";
import type { Message } from "../message/Message";
import { CommandQueueEvent, CommandQueueInterpreter } from "./CommandQueueMachine";
import type { ZWaveOptions } from "./Driver";
import type { SerialAPICommandDoneData, SerialAPICommandMachineParams } from "./SerialAPICommandMachine";
import { ServiceImplementations } from "./StateMachineShared";
import type { Transaction } from "./Transaction";
export interface SendThreadStateSchema {
    states: {
        init: {};
        idle: {};
        sending: {
            states: {
                beforeSend: {};
                handshake: {
                    states: {
                        waitForCommandResult: {};
                        waitForHandshakeResponse: {};
                    };
                };
                execute: {};
                waitForUpdate: {};
                retryWait: {};
                done: {};
            };
        };
    };
}
export declare type SendDataErrorData = (SerialAPICommandDoneData & {
    type: "failure";
}) | {
    type: "failure";
    reason: "node timeout";
    result?: undefined;
};
export interface SendThreadContext {
    commandQueue: CommandQueueInterpreter;
    queue: SortedList<Transaction>;
    currentTransaction?: Transaction;
    handshakeTransaction?: Transaction;
    sendDataAttempts: number;
}
export declare type SendThreadEvent = {
    type: "add";
    transaction: Transaction;
} | {
    type: "trigger";
} | {
    type: "nodeUpdate";
    result: ApplicationCommandRequest | BridgeApplicationCommandRequest;
} | {
    type: "handshakeResponse";
    result: ApplicationCommandRequest | BridgeApplicationCommandRequest;
} | {
    type: "unsolicited";
    message: Message;
} | {
    type: "sortQueue";
} | {
    type: "NIF";
    nodeId: number;
} | {
    type: "reduce";
    reducer: TransactionReducer;
} | {
    type: "ACK";
} | {
    type: "CAN";
} | {
    type: "NAK";
} | {
    type: "message";
    message: Message;
} | (CommandQueueEvent & ({
    type: "command_success";
} | {
    type: "command_failure";
} | {
    type: "command_error";
})) | ({
    type: "active_command_success";
} & Omit<CommandQueueEvent & {
    type: "command_success";
}, "type">) | ({
    type: "active_command_failure";
} & Omit<CommandQueueEvent & {
    type: "command_failure";
}, "type">) | ({
    type: "active_command_error";
} & Omit<CommandQueueEvent & {
    type: "command_error";
}, "type">);
export declare type SendThreadMachine = StateMachine<SendThreadContext, SendThreadStateSchema, SendThreadEvent>;
export declare type SendThreadInterpreter = Interpreter<SendThreadContext, SendThreadStateSchema, SendThreadEvent>;
export declare type TransactionReducerResult = {
    type: "drop";
} | {
    type: "keep";
} | {
    type: "reject";
    message: string;
    code: ZWaveErrorCodes;
} | {
    type: "resolve";
    message?: Message;
} | {
    type: "requeue";
    priority?: MessagePriority;
};
export declare type TransactionReducer = (transaction: Transaction, source: "queue" | "current") => TransactionReducerResult;
export declare type SendThreadMachineParams = {
    timeouts: SerialAPICommandMachineParams["timeouts"] & Pick<ZWaveOptions["timeouts"], "report">;
    attempts: SerialAPICommandMachineParams["attempts"] & Pick<ZWaveOptions["attempts"], "retryAfterTransmitReport">;
};
export declare function createSendThreadMachine(implementations: ServiceImplementations, params: SendThreadMachineParams): SendThreadMachine;
