import { Interpreter, StateMachine } from "xstate";
export interface NodeReadyStateSchema {
    states: {
        notReady: {};
        readyIfNotDead: {};
        ready: {};
    };
}
export interface NodeReadyContext {
    isMaybeDead: boolean;
}
export declare type NodeReadyEvent = {
    type: "NOT_DEAD";
} | {
    type: "MAYBE_DEAD";
} | {
    type: "RESTART_INTERVIEW_FROM_CACHE";
} | {
    type: "INTERVIEW_DONE";
};
export declare type NodeReadyMachine = StateMachine<NodeReadyContext, NodeReadyStateSchema, NodeReadyEvent>;
export declare type NodeReadyInterpreter = Interpreter<NodeReadyContext, NodeReadyStateSchema, NodeReadyEvent>;
export declare function createNodeReadyMachine(initialContext?: Partial<NodeReadyContext>): NodeReadyMachine;
