import { Interpreter, StateMachine } from "xstate";
import type { ZWaveNode } from "./Node";
import { NodeStatus } from "./Types";
export interface NodeStatusStateSchema {
    states: {
        unknown: {};
        dead: {};
        alive: {};
        asleep: {};
        awake: {};
    };
}
export declare function nodeStatusMachineStateToNodeStatus(state: keyof NodeStatusStateSchema["states"]): NodeStatus;
export declare type NodeStatusEvent = {
    type: "DEAD";
} | {
    type: "ALIVE";
} | {
    type: "ASLEEP";
} | {
    type: "AWAKE";
};
export declare type NodeStatusMachine = StateMachine<any, NodeStatusStateSchema, NodeStatusEvent>;
export declare type NodeStatusInterpreter = Interpreter<any, NodeStatusStateSchema, NodeStatusEvent>;
export declare function createNodeStatusMachine(node: ZWaveNode): NodeStatusMachine;
