"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeStatus = exports.InterviewStage = void 0;
// prettier-ignore
var InterviewStage;
(function (InterviewStage) {
    /** The interview process hasn't started for this node */
    InterviewStage[InterviewStage["None"] = 0] = "None";
    /** The node's protocol information has been queried from the controller */
    InterviewStage[InterviewStage["ProtocolInfo"] = 1] = "ProtocolInfo";
    /** The node has been queried for supported and controlled command classes */
    InterviewStage[InterviewStage["NodeInfo"] = 2] = "NodeInfo";
    // ===== the stuff above should never change =====
    /**
     * This marks the beginning of re-interviews on application startup.
     * RestartFromCache and later stages will be serialized as "Complete" in the cache
     */
    InterviewStage[InterviewStage["RestartFromCache"] = 3] = "RestartFromCache";
    // ===== the stuff below changes frequently, so it has to be redone on every start =====
    /**
     * Information for all command classes has been queried.
     * This includes static information that is requested once as well as dynamic
     * information that is requested on every restart.
     */
    InterviewStage[InterviewStage["CommandClasses"] = 4] = "CommandClasses";
    // TODO: Heal network on startup
    /**
     * Device information for the node has been loaded from a config file.
     * If defined, some of the reported information will be overwritten based on the
     * config file contents.
     */
    InterviewStage[InterviewStage["OverwriteConfig"] = 5] = "OverwriteConfig";
    /** The node has been queried for its current neighbor list */
    InterviewStage[InterviewStage["Neighbors"] = 6] = "Neighbors";
    /** The interview process has finished */
    InterviewStage[InterviewStage["Complete"] = 7] = "Complete";
})(InterviewStage = exports.InterviewStage || (exports.InterviewStage = {}));
var NodeStatus;
(function (NodeStatus) {
    NodeStatus[NodeStatus["Unknown"] = 0] = "Unknown";
    NodeStatus[NodeStatus["Asleep"] = 1] = "Asleep";
    NodeStatus[NodeStatus["Awake"] = 2] = "Awake";
    NodeStatus[NodeStatus["Dead"] = 3] = "Dead";
    NodeStatus[NodeStatus["Alive"] = 4] = "Alive";
})(NodeStatus = exports.NodeStatus || (exports.NodeStatus = {}));

//# sourceMappingURL=Types.js.map
