"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeMAC = exports.decryptAES128OFB = exports.encryptAES128OFB = exports.encryptAES128ECB = void 0;
const crypto = __importStar(require("crypto"));
function zeroPad(input, blockSize) {
    const padding = input.length % blockSize === 0
        ? Buffer.from([])
        : Buffer.alloc(blockSize - (input.length % blockSize), 0);
    return {
        output: Buffer.concat([input, padding]),
        paddingLength: padding.length,
    };
}
function encrypt(algorithm, blockSize, trimToInputLength, input, key, iv) {
    const cipher = crypto.createCipheriv(algorithm, key, iv);
    cipher.setAutoPadding(false);
    const { output: plaintext, paddingLength } = zeroPad(input, blockSize);
    const ret = Buffer.concat([cipher.update(plaintext), cipher.final()]);
    if (trimToInputLength && paddingLength > 0) {
        return ret.slice(0, -paddingLength);
    }
    else {
        return ret;
    }
}
function decrypt(algorithm, blockSize, trimToInputLength, input, key, iv) {
    const cipher = crypto.createDecipheriv(algorithm, key, iv);
    cipher.setAutoPadding(false);
    const { output: ciphertext, paddingLength } = zeroPad(input, blockSize);
    const ret = Buffer.concat([cipher.update(ciphertext), cipher.final()]);
    if (trimToInputLength && paddingLength > 0) {
        return ret.slice(0, -paddingLength);
    }
    else {
        return ret;
    }
}
/** Encrypts a payload using AES-128-ECB (as described in SDS10865) */
function encryptAES128ECB(plaintext, key) {
    return encrypt("aes-128-ecb", 16, false, plaintext, key, Buffer.from([]));
}
exports.encryptAES128ECB = encryptAES128ECB;
/** Encrypts a payload using AES-OFB (as described in SDS10865) */
exports.encryptAES128OFB = encrypt.bind(undefined, "aes-128-ofb", 16, true);
/** Decrypts a payload using AES-OFB (as described in SDS10865) */
exports.decryptAES128OFB = decrypt.bind(undefined, "aes-128-ofb", 16, true);
/** Computes a message authentication code (as described in SDS10865) */
function computeMAC(authData, key, iv = Buffer.alloc(16, 0)) {
    const ciphertext = encrypt("aes-128-cbc", 16, false, authData, key, iv);
    // The MAC is the first 8 bytes of the last 16 byte block
    return ciphertext.slice(-16, -8);
}
exports.computeMAC = computeMAC;
//# sourceMappingURL=crypto.js.map