import type { JSONObject } from "@zwave-js/shared";
export declare type DurationUnit = "seconds" | "minutes" | "unknown" | "default";
/** Represents a duration that is used by some command classes */
export declare class Duration {
    unit: DurationUnit;
    constructor(value: number, unit: DurationUnit);
    private _value;
    get value(): number;
    set value(v: number);
    /** Parses a duration as represented in Report commands */
    static parseReport(payload?: number): Duration | undefined;
    /** Parses a duration as represented in Set commands */
    static parseSet(payload?: number): Duration | undefined;
    /** Serializes a duration for a Set command */
    serializeSet(): number;
    /** Serializes a duration for a Report command */
    serializeReport(): number;
    toJSON(): string | JSONObject;
    toMilliseconds(): number | undefined;
    toString(): string;
}
//# sourceMappingURL=Duration.d.ts.map