"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZWaveSocket = void 0;
const net = __importStar(require("net"));
const ZWaveSerialPortBase_1 = require("./ZWaveSerialPortBase");
/** A version of the Z-Wave serial binding that works using a socket (TCP or IPC) */
class ZWaveSocket extends ZWaveSerialPortBase_1.ZWaveSerialPortBase {
    constructor(socketOptions, loggers) {
        super({
            create: () => new net.Socket(),
            open: (serial) => new Promise((resolve) => {
                serial.connect(this.socketOptions, () => resolve());
            }),
            close: (serial) => new Promise((resolve) => {
                serial.once("close", () => resolve()).destroy();
            }),
        }, loggers);
        this.socketOptions = socketOptions;
    }
}
exports.ZWaveSocket = ZWaveSocket;
//# sourceMappingURL=ZWaveSocket.js.map