"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinarySwitchCCGet = exports.BinarySwitchCCReport = exports.BinarySwitchCCSet = exports.BinarySwitchCC = exports.BinarySwitchCCAPI = exports.BinarySwitchCommand = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function getCurrentValueValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Binary Switch"],
        endpoint,
        property: "currentValue",
    };
}
// All the supported commands
var BinarySwitchCommand;
(function (BinarySwitchCommand) {
    BinarySwitchCommand[BinarySwitchCommand["Set"] = 1] = "Set";
    BinarySwitchCommand[BinarySwitchCommand["Get"] = 2] = "Get";
    BinarySwitchCommand[BinarySwitchCommand["Report"] = 3] = "Report";
})(BinarySwitchCommand = exports.BinarySwitchCommand || (exports.BinarySwitchCommand = {}));
let BinarySwitchCCAPI = class BinarySwitchCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c, _d;
            if (property !== "targetValue") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "boolean") {
                API_1.throwWrongValueType(this.ccId, property, "boolean", typeof value);
            }
            await this.set(value);
            // If the command did not fail, assume that it succeeded and update the currentValue accordingly
            // so UIs have immediate feedback
            if (this.isSinglecast()) {
                const valueDB = (_c = this.endpoint.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.valueDB;
                valueDB === null || valueDB === void 0 ? void 0 : valueDB.setValue(getCurrentValueValueId(this.endpoint.index), value);
                // Verify the current value after a delay
                // TODO: #1321
                const duration = undefined;
                this.schedulePoll({ property }, (_d = duration === null || duration === void 0 ? void 0 : duration.toMilliseconds()) !== null && _d !== void 0 ? _d : 1000);
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "currentValue":
                case "targetValue":
                case "duration":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case BinarySwitchCommand.Get:
                return this.isSinglecast();
            case BinarySwitchCommand.Set:
                return true;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(BinarySwitchCommand, BinarySwitchCommand.Get);
        const cc = new BinarySwitchCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return {
                // interpret unknown values as false
                currentValue: response.currentValue || false,
                targetValue: response.targetValue,
                duration: response.duration,
            };
        }
    }
    /**
     * Sets the switch to the given value
     * @param targetValue The target value to set
     * @param duration The duration after which the target value should be reached. Only supported in V2 and above
     */
    async set(targetValue, duration) {
        this.assertSupportsCommand(BinarySwitchCommand, BinarySwitchCommand.Set);
        const cc = new BinarySwitchCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            targetValue,
            duration,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
BinarySwitchCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Binary Switch"])
], BinarySwitchCCAPI);
exports.BinarySwitchCCAPI = BinarySwitchCCAPI;
let BinarySwitchCC = class BinarySwitchCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c, _d;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Binary Switch"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // always query the current state
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying Binary Switch state...",
            direction: "outbound",
        });
        const resp = await api.get();
        if (resp) {
            let logMessage = `received Binary Switch state:
current value:      ${resp.currentValue}`;
            if (resp.targetValue != undefined) {
                logMessage += `
target value:       ${resp.targetValue}
remaining duration: ${(_d = (_c = resp.duration) === null || _c === void 0 ? void 0 : _c.toString()) !== null && _d !== void 0 ? _d : "undefined"}`;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    setMappedBasicValue(value) {
        this.getValueDB().setValue({
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "currentValue",
        }, value > 0);
        return true;
    }
};
BinarySwitchCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Binary Switch"]),
    CommandClass_1.implementedVersion(2)
], BinarySwitchCC);
exports.BinarySwitchCC = BinarySwitchCC;
let BinarySwitchCCSet = class BinarySwitchCCSet extends BinarySwitchCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.targetValue = options.targetValue;
            this.duration = options.duration;
        }
    }
    serialize() {
        const payload = [this.targetValue ? 0xff : 0x00];
        if (this.version >= 2 && this.duration) {
            payload.push(this.duration.serializeSet());
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "target value": this.targetValue,
        };
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
BinarySwitchCCSet = __decorate([
    CommandClass_1.CCCommand(BinarySwitchCommand.Set)
], BinarySwitchCCSet);
exports.BinarySwitchCCSet = BinarySwitchCCSet;
let BinarySwitchCCReport = class BinarySwitchCCReport extends BinarySwitchCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._currentValue = core_1.parseMaybeBoolean(this.payload[0]);
        if (this.version >= 2 && this.payload.length >= 3) {
            // V2
            this._targetValue = core_1.parseBoolean(this.payload[1]);
            this._duration = core_1.Duration.parseReport(this.payload[2]);
        }
        this.persistValues();
    }
    get currentValue() {
        return this._currentValue;
    }
    get targetValue() {
        return this._targetValue;
    }
    get duration() {
        return this._duration;
    }
    toLogEntry() {
        const message = {
            "current value": this.currentValue,
        };
        if (this.targetValue != undefined) {
            message["target value"] = this.targetValue;
        }
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyBoolean,
        label: "Current value",
    })
], BinarySwitchCCReport.prototype, "currentValue", null);
__decorate([
    CommandClass_1.ccValue({ forceCreation: true }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Boolean,
        label: "Target value",
    })
], BinarySwitchCCReport.prototype, "targetValue", null);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Duration,
        label: "Transition duration",
    })
], BinarySwitchCCReport.prototype, "duration", null);
BinarySwitchCCReport = __decorate([
    CommandClass_1.CCCommand(BinarySwitchCommand.Report)
], BinarySwitchCCReport);
exports.BinarySwitchCCReport = BinarySwitchCCReport;
let BinarySwitchCCGet = class BinarySwitchCCGet extends BinarySwitchCC {
};
BinarySwitchCCGet = __decorate([
    CommandClass_1.CCCommand(BinarySwitchCommand.Get),
    CommandClass_1.expectedCCResponse(BinarySwitchCCReport)
], BinarySwitchCCGet);
exports.BinarySwitchCCGet = BinarySwitchCCGet;

//# sourceMappingURL=BinarySwitchCC.js.map
