/// <reference types="node" />
import type { MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { CommandClasses, Maybe } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
/** Returns the ValueID used to store the current value of a Central Scene */
export declare function getSceneValueId(sceneNumber: number): ValueID;
export declare enum CentralSceneCommand {
    SupportedGet = 1,
    SupportedReport = 2,
    Notification = 3,
    ConfigurationSet = 4,
    ConfigurationGet = 5,
    ConfigurationReport = 6
}
/**
 * @publicAPI
 */
export declare enum CentralSceneKeys {
    KeyPressed = 0,
    KeyReleased = 1,
    KeyHeldDown = 2,
    KeyPressed2x = 3,
    KeyPressed3x = 4,
    KeyPressed4x = 5,
    KeyPressed5x = 6
}
export declare class CentralSceneCCAPI extends CCAPI {
    supportsCommand(cmd: CentralSceneCommand): Maybe<boolean>;
    getSupported(): Promise<Pick<CentralSceneCCSupportedReport, "sceneCount" | "supportsSlowRefresh" | "supportedKeyAttributes"> | undefined>;
    getConfiguration(): Promise<Pick<CentralSceneCCConfigurationReport, "slowRefresh"> | undefined>;
    setConfiguration(slowRefresh: boolean): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class CentralSceneCC extends CommandClass {
    ccCommand: CentralSceneCommand;
    determineRequiredCCInterviews(): readonly CommandClasses[];
    skipEndpointInterview(): boolean;
    interview(complete?: boolean): Promise<void>;
}
export declare class CentralSceneCCNotification extends CentralSceneCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _sequenceNumber;
    get sequenceNumber(): number;
    private _keyAttribute;
    get keyAttribute(): CentralSceneKeys;
    private _sceneNumber;
    get sceneNumber(): number;
    private _slowRefresh;
    get slowRefresh(): boolean | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class CentralSceneCCSupportedReport extends CentralSceneCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _sceneCount;
    get sceneCount(): number;
    private _supportsSlowRefresh;
    get supportsSlowRefresh(): boolean;
    private _supportedKeyAttributes;
    get supportedKeyAttributes(): ReadonlyMap<number, readonly CentralSceneKeys[]>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class CentralSceneCCSupportedGet extends CentralSceneCC {
}
export declare class CentralSceneCCConfigurationReport extends CentralSceneCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _slowRefresh;
    get slowRefresh(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class CentralSceneCCConfigurationGet extends CentralSceneCC {
}
interface CentralSceneCCConfigurationSetOptions extends CCCommandOptions {
    slowRefresh: boolean;
}
export declare class CentralSceneCCConfigurationSet extends CentralSceneCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CentralSceneCCConfigurationSetOptions);
    slowRefresh: boolean;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
