/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum LockCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare class LockCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: LockCommand): Maybe<boolean>;
    get(): Promise<boolean | undefined>;
    /**
     * Locks or unlocks the lock
     * @param locked Whether the lock should be locked
     */
    set(locked: boolean): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class LockCC extends CommandClass {
    ccCommand: LockCommand;
    interview(complete?: boolean): Promise<void>;
}
interface LockCCSetOptions extends CCCommandOptions {
    locked: boolean;
}
export declare class LockCCSet extends LockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | LockCCSetOptions);
    locked: boolean;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class LockCCReport extends LockCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly locked: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class LockCCGet extends LockCC {
}
export {};
