"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManufacturerSpecificCCDeviceSpecificGet = exports.ManufacturerSpecificCCDeviceSpecificReport = exports.ManufacturerSpecificCCGet = exports.ManufacturerSpecificCCReport = exports.ManufacturerSpecificCC = exports.ManufacturerSpecificCCAPI = exports.DeviceIdType = exports.ManufacturerSpecificCommand = exports.getProductIdValueMetadata = exports.getProductTypeValueMetadata = exports.getManufacturerIdValueMetadata = exports.getProductIdValueId = exports.getProductTypeValueId = exports.getManufacturerIdValueId = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function getManufacturerIdValueId() {
    return {
        commandClass: core_1.CommandClasses["Manufacturer Specific"],
        property: "manufacturerId",
    };
}
exports.getManufacturerIdValueId = getManufacturerIdValueId;
function getProductTypeValueId() {
    return {
        commandClass: core_1.CommandClasses["Manufacturer Specific"],
        property: "productType",
    };
}
exports.getProductTypeValueId = getProductTypeValueId;
function getProductIdValueId() {
    return {
        commandClass: core_1.CommandClasses["Manufacturer Specific"],
        property: "productId",
    };
}
exports.getProductIdValueId = getProductIdValueId;
function getManufacturerIdValueMetadata() {
    return {
        ...core_1.ValueMetadata.ReadOnlyUInt16,
        label: "Manufacturer ID",
    };
}
exports.getManufacturerIdValueMetadata = getManufacturerIdValueMetadata;
function getProductTypeValueMetadata() {
    return {
        ...core_1.ValueMetadata.ReadOnlyUInt16,
        label: "Product type",
    };
}
exports.getProductTypeValueMetadata = getProductTypeValueMetadata;
function getProductIdValueMetadata() {
    return {
        ...core_1.ValueMetadata.ReadOnlyUInt16,
        label: "Product ID",
    };
}
exports.getProductIdValueMetadata = getProductIdValueMetadata;
var ManufacturerSpecificCommand;
(function (ManufacturerSpecificCommand) {
    ManufacturerSpecificCommand[ManufacturerSpecificCommand["Get"] = 4] = "Get";
    ManufacturerSpecificCommand[ManufacturerSpecificCommand["Report"] = 5] = "Report";
    ManufacturerSpecificCommand[ManufacturerSpecificCommand["DeviceSpecificGet"] = 6] = "DeviceSpecificGet";
    ManufacturerSpecificCommand[ManufacturerSpecificCommand["DeviceSpecificReport"] = 7] = "DeviceSpecificReport";
})(ManufacturerSpecificCommand = exports.ManufacturerSpecificCommand || (exports.ManufacturerSpecificCommand = {}));
/**
 * @publicAPI
 */
var DeviceIdType;
(function (DeviceIdType) {
    DeviceIdType[DeviceIdType["FactoryDefault"] = 0] = "FactoryDefault";
    DeviceIdType[DeviceIdType["SerialNumber"] = 1] = "SerialNumber";
    DeviceIdType[DeviceIdType["PseudoRandom"] = 2] = "PseudoRandom";
})(DeviceIdType = exports.DeviceIdType || (exports.DeviceIdType = {}));
// @noSetValueAPI This CC is read-only
let ManufacturerSpecificCCAPI = class ManufacturerSpecificCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case ManufacturerSpecificCommand.Get:
                return true; // This is mandatory
            case ManufacturerSpecificCommand.DeviceSpecificGet:
                return this.version >= 2;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ManufacturerSpecificCommand, ManufacturerSpecificCommand.Get);
        const cc = new ManufacturerSpecificCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "manufacturerId",
                "productType",
                "productId",
            ]);
        }
    }
    async deviceSpecificGet(deviceIdType) {
        this.assertSupportsCommand(ManufacturerSpecificCommand, ManufacturerSpecificCommand.DeviceSpecificGet);
        const cc = new ManufacturerSpecificCCDeviceSpecificGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            deviceIdType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.deviceId;
    }
};
ManufacturerSpecificCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Manufacturer Specific"])
], ManufacturerSpecificCCAPI);
exports.ManufacturerSpecificCCAPI = ManufacturerSpecificCCAPI;
let ManufacturerSpecificCC = class ManufacturerSpecificCC extends CommandClass_1.CommandClass {
    determineRequiredCCInterviews() {
        // The Manufacturer Specific CC MUST be interviewed first
        return [];
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Manufacturer Specific"].withOptions({ priority: Constants_1.MessagePriority.NodeQuery });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // manufacturer information is static
        if (complete) {
            if (node.isControllerNode()) {
                this.driver.controllerLog.logNode(node.id, "not querying manufacturer information from the controller...");
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "querying manufacturer information...",
                    direction: "outbound",
                });
                const mfResp = await api.get();
                if (mfResp) {
                    const logMessage = `received response for manufacturer information:
  manufacturer: ${this.driver.configManager.lookupManufacturer(mfResp.manufacturerId) ||
                        "unknown"} (${shared_1.num2hex(mfResp.manufacturerId)})
  product type: ${shared_1.num2hex(mfResp.productType)}
  product id:   ${shared_1.num2hex(mfResp.productId)}`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ManufacturerSpecificCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Manufacturer Specific"]),
    CommandClass_1.implementedVersion(2)
], ManufacturerSpecificCC);
exports.ManufacturerSpecificCC = ManufacturerSpecificCC;
let ManufacturerSpecificCCReport = class ManufacturerSpecificCCReport extends ManufacturerSpecificCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 6);
        this._manufacturerId = this.payload.readUInt16BE(0);
        this._productType = this.payload.readUInt16BE(2);
        this._productId = this.payload.readUInt16BE(4);
        this.persistValues();
    }
    get manufacturerId() {
        return this._manufacturerId;
    }
    get productType() {
        return this._productType;
    }
    get productId() {
        return this._productId;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "manufacturer id": shared_1.num2hex(this._manufacturerId),
                "product type": shared_1.num2hex(this._productType),
                "product id": shared_1.num2hex(this._productId),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata(getManufacturerIdValueMetadata())
], ManufacturerSpecificCCReport.prototype, "manufacturerId", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata(getProductTypeValueMetadata())
], ManufacturerSpecificCCReport.prototype, "productType", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata(getProductIdValueMetadata())
], ManufacturerSpecificCCReport.prototype, "productId", null);
ManufacturerSpecificCCReport = __decorate([
    CommandClass_1.CCCommand(ManufacturerSpecificCommand.Report)
], ManufacturerSpecificCCReport);
exports.ManufacturerSpecificCCReport = ManufacturerSpecificCCReport;
let ManufacturerSpecificCCGet = class ManufacturerSpecificCCGet extends ManufacturerSpecificCC {
};
ManufacturerSpecificCCGet = __decorate([
    CommandClass_1.CCCommand(ManufacturerSpecificCommand.Get),
    CommandClass_1.expectedCCResponse(ManufacturerSpecificCCReport)
], ManufacturerSpecificCCGet);
exports.ManufacturerSpecificCCGet = ManufacturerSpecificCCGet;
let ManufacturerSpecificCCDeviceSpecificReport = class ManufacturerSpecificCCDeviceSpecificReport extends ManufacturerSpecificCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.type = this.payload[0] & 0b111;
        const dataFormat = this.payload[1] >>> 5;
        const dataLength = this.payload[1] & 0b11111;
        core_1.validatePayload(dataLength > 0, this.payload.length >= 2 + dataLength);
        const deviceIdData = this.payload.slice(2, 2 + dataLength);
        this.deviceId =
            dataFormat === 0
                ? deviceIdData.toString("utf8")
                : "0x" + deviceIdData.toString("hex");
        this.persistValues();
    }
    persistValues() {
        const valueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "deviceId",
            propertyKey: DeviceIdType[this.type],
        };
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.ReadOnly,
            label: `Device ID (${valueId.propertyKey})`,
        });
        this.getValueDB().setValue(valueId, this.deviceId);
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "device id type": shared_1.getEnumMemberName(DeviceIdType, this.type),
                "device id": this.deviceId,
            },
        };
    }
};
ManufacturerSpecificCCDeviceSpecificReport = __decorate([
    CommandClass_1.CCCommand(ManufacturerSpecificCommand.DeviceSpecificReport)
], ManufacturerSpecificCCDeviceSpecificReport);
exports.ManufacturerSpecificCCDeviceSpecificReport = ManufacturerSpecificCCDeviceSpecificReport;
let ManufacturerSpecificCCDeviceSpecificGet = class ManufacturerSpecificCCDeviceSpecificGet extends ManufacturerSpecificCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.deviceIdType = options.deviceIdType;
        }
    }
    serialize() {
        this.payload = Buffer.from([(this.deviceIdType || 0) & 0b111]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "device id type": shared_1.getEnumMemberName(DeviceIdType, this.deviceIdType),
            },
        };
    }
};
ManufacturerSpecificCCDeviceSpecificGet = __decorate([
    CommandClass_1.CCCommand(ManufacturerSpecificCommand.DeviceSpecificGet),
    CommandClass_1.expectedCCResponse(ManufacturerSpecificCCDeviceSpecificReport)
], ManufacturerSpecificCCDeviceSpecificGet);
exports.ManufacturerSpecificCCDeviceSpecificGet = ManufacturerSpecificCCDeviceSpecificGet;

//# sourceMappingURL=ManufacturerSpecificCC.js.map
