"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeNamingAndLocationCCLocationGet = exports.NodeNamingAndLocationCCLocationReport = exports.NodeNamingAndLocationCCLocationSet = exports.NodeNamingAndLocationCCNameGet = exports.NodeNamingAndLocationCCNameReport = exports.NodeNamingAndLocationCCNameSet = exports.NodeNamingAndLocationCC = exports.NodeNamingAndLocationCCAPI = exports.getNodeLocationValueId = exports.getNodeNameValueId = exports.NodeNamingAndLocationCommand = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
function isASCII(str) {
    return /^[\x00-\x7F]*$/.test(str);
}
// All the supported commands
var NodeNamingAndLocationCommand;
(function (NodeNamingAndLocationCommand) {
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["NameSet"] = 1] = "NameSet";
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["NameGet"] = 2] = "NameGet";
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["NameReport"] = 3] = "NameReport";
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["LocationSet"] = 4] = "LocationSet";
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["LocationGet"] = 5] = "LocationGet";
    NodeNamingAndLocationCommand[NodeNamingAndLocationCommand["LocationReport"] = 6] = "LocationReport";
})(NodeNamingAndLocationCommand = exports.NodeNamingAndLocationCommand || (exports.NodeNamingAndLocationCommand = {}));
function getNodeNameValueId() {
    return {
        commandClass: core_1.CommandClasses["Node Naming and Location"],
        property: "name",
    };
}
exports.getNodeNameValueId = getNodeNameValueId;
function getNodeLocationValueId() {
    return {
        commandClass: core_1.CommandClasses["Node Naming and Location"],
        property: "location",
    };
}
exports.getNodeLocationValueId = getNodeLocationValueId;
let NodeNamingAndLocationCCAPI = class NodeNamingAndLocationCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "name" && property !== "location") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "string") {
                API_1.throwWrongValueType(this.ccId, property, "string", typeof value);
            }
            switch (property) {
                case "name":
                    await this.setName(value);
                    break;
                case "location":
                    await this.setLocation(value);
                    break;
            }
        };
        this[_b] = async ({ property, }) => {
            switch (property) {
                case "name":
                    return this.getName();
                case "location":
                    return this.getLocation();
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case NodeNamingAndLocationCommand.NameGet:
            case NodeNamingAndLocationCommand.LocationGet:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async getName() {
        this.assertSupportsCommand(NodeNamingAndLocationCommand, NodeNamingAndLocationCommand.NameGet);
        const cc = new NodeNamingAndLocationCCNameGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.name;
    }
    async setName(name) {
        this.assertSupportsCommand(NodeNamingAndLocationCommand, NodeNamingAndLocationCommand.NameSet);
        const cc = new NodeNamingAndLocationCCNameSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            name,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getLocation() {
        this.assertSupportsCommand(NodeNamingAndLocationCommand, NodeNamingAndLocationCommand.LocationGet);
        const cc = new NodeNamingAndLocationCCLocationGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.location;
    }
    async setLocation(location) {
        this.assertSupportsCommand(NodeNamingAndLocationCommand, NodeNamingAndLocationCommand.LocationSet);
        const cc = new NodeNamingAndLocationCCLocationSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            location,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
NodeNamingAndLocationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Node Naming and Location"])
], NodeNamingAndLocationCCAPI);
exports.NodeNamingAndLocationCCAPI = NodeNamingAndLocationCCAPI;
let NodeNamingAndLocationCC = class NodeNamingAndLocationCC extends CommandClass_1.CommandClass {
    skipEndpointInterview() {
        // As the name says, this is for the node, not for endpoints
        return true;
    }
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Node Naming and Location"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "retrieving node name...",
            direction: "outbound",
        });
        const name = await api.getName();
        this.driver.controllerLog.logNode(node.id, {
            message: `is named "${name}"`,
            direction: "inbound",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "retrieving node location...",
            direction: "outbound",
        });
        const location = await api.getLocation();
        this.driver.controllerLog.logNode(node.id, {
            message: `received location: ${location}`,
            direction: "inbound",
        });
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
NodeNamingAndLocationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Node Naming and Location"]),
    CommandClass_1.implementedVersion(1)
], NodeNamingAndLocationCC);
exports.NodeNamingAndLocationCC = NodeNamingAndLocationCC;
let NodeNamingAndLocationCCNameSet = class NodeNamingAndLocationCCNameSet extends NodeNamingAndLocationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.name = options.name;
        }
    }
    serialize() {
        const encoding = isASCII(this.name) ? "ascii" : "utf16le";
        this.payload = Buffer.allocUnsafe(1 + this.name.length * (encoding === "ascii" ? 1 : 2));
        this.payload[0] = encoding === "ascii" ? 0x0 : 0x2;
        let nameAsBuffer = Buffer.from(this.name, encoding);
        if (encoding === "utf16le") {
            // Z-Wave expects UTF16 BE
            nameAsBuffer = nameAsBuffer.swap16();
        }
        // Copy at max 16 bytes
        nameAsBuffer.copy(this.payload, 0, 0, Math.min(16, nameAsBuffer.length));
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { name: this.name },
        };
    }
};
NodeNamingAndLocationCCNameSet = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.NameSet)
], NodeNamingAndLocationCCNameSet);
exports.NodeNamingAndLocationCCNameSet = NodeNamingAndLocationCCNameSet;
let NodeNamingAndLocationCCNameReport = class NodeNamingAndLocationCCNameReport extends NodeNamingAndLocationCC {
    constructor(driver, options) {
        super(driver, options);
        const encoding = this.payload[0] === 2 ? "utf16le" : "ascii";
        let nameBuffer = this.payload.slice(1);
        if (encoding === "utf16le") {
            // Z-Wave expects UTF16 BE
            nameBuffer = nameBuffer.swap16();
        }
        this.name = nameBuffer.toString(encoding);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { name: this.name },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], NodeNamingAndLocationCCNameReport.prototype, "name", void 0);
NodeNamingAndLocationCCNameReport = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.NameReport)
], NodeNamingAndLocationCCNameReport);
exports.NodeNamingAndLocationCCNameReport = NodeNamingAndLocationCCNameReport;
let NodeNamingAndLocationCCNameGet = class NodeNamingAndLocationCCNameGet extends NodeNamingAndLocationCC {
};
NodeNamingAndLocationCCNameGet = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.NameGet),
    CommandClass_1.expectedCCResponse(NodeNamingAndLocationCCNameReport)
], NodeNamingAndLocationCCNameGet);
exports.NodeNamingAndLocationCCNameGet = NodeNamingAndLocationCCNameGet;
let NodeNamingAndLocationCCLocationSet = class NodeNamingAndLocationCCLocationSet extends NodeNamingAndLocationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.location = options.location;
        }
    }
    serialize() {
        const encoding = isASCII(this.location) ? "ascii" : "utf16le";
        this.payload = Buffer.allocUnsafe(1 + this.location.length * (encoding === "ascii" ? 1 : 2));
        this.payload[0] = encoding === "ascii" ? 0x0 : 0x2;
        let locationAsBuffer = Buffer.from(this.location, encoding);
        if (encoding === "utf16le") {
            // Z-Wave expects UTF16 BE
            locationAsBuffer = locationAsBuffer.swap16();
        }
        // Copy at max 16 bytes
        locationAsBuffer.copy(this.payload, 0, 0, Math.min(16, locationAsBuffer.length));
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { location: this.location },
        };
    }
};
NodeNamingAndLocationCCLocationSet = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.LocationSet)
], NodeNamingAndLocationCCLocationSet);
exports.NodeNamingAndLocationCCLocationSet = NodeNamingAndLocationCCLocationSet;
let NodeNamingAndLocationCCLocationReport = class NodeNamingAndLocationCCLocationReport extends NodeNamingAndLocationCC {
    constructor(driver, options) {
        super(driver, options);
        const encoding = this.payload[0] === 2 ? "utf16le" : "ascii";
        let locationBuffer = this.payload.slice(1);
        if (encoding === "utf16le") {
            // Z-Wave expects UTF16 BE
            locationBuffer = locationBuffer.swap16();
        }
        this.location = locationBuffer.toString(encoding);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { location: this.location },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], NodeNamingAndLocationCCLocationReport.prototype, "location", void 0);
NodeNamingAndLocationCCLocationReport = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.LocationReport)
], NodeNamingAndLocationCCLocationReport);
exports.NodeNamingAndLocationCCLocationReport = NodeNamingAndLocationCCLocationReport;
let NodeNamingAndLocationCCLocationGet = class NodeNamingAndLocationCCLocationGet extends NodeNamingAndLocationCC {
};
NodeNamingAndLocationCCLocationGet = __decorate([
    CommandClass_1.CCCommand(NodeNamingAndLocationCommand.LocationGet),
    CommandClass_1.expectedCCResponse(NodeNamingAndLocationCCLocationReport)
], NodeNamingAndLocationCCLocationGet);
exports.NodeNamingAndLocationCCLocationGet = NodeNamingAndLocationCCLocationGet;

//# sourceMappingURL=NodeNamingCC.js.map
