/// <reference types="node" />
import type { Scale } from "@zwave-js/config";
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import { Maybe, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
export declare enum ThermostatSetpointCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SupportedGet = 4,
    SupportedReport = 5,
    CapabilitiesGet = 9,
    CapabilitiesReport = 10
}
/**
 * @publicAPI
 */
export declare enum ThermostatSetpointType {
    "N/A" = 0,
    "Heating" = 1,
    "Cooling" = 2,
    "Furnace" = 7,
    "Dry Air" = 8,
    "Moist Air" = 9,
    "Auto Changeover" = 10,
    "Energy Save Heating" = 11,
    "Energy Save Cooling" = 12,
    "Away Heating" = 13,
    "Away Cooling" = 14,
    "Full Power" = 15
}
export interface ThermostatSetpointValue {
    value: number;
    scale: number;
}
export interface ThermostatSetpointCapabilities {
    minValue: number;
    minValueScale: number;
    maxValue: number;
    maxValueScale: number;
}
/**
 * @publicAPI
 */
export declare type ThermostatSetpointMetadata = ValueMetadata & {
    ccSpecific: {
        setpointType: ThermostatSetpointType;
    };
};
export declare class ThermostatSetpointCCAPI extends CCAPI {
    supportsCommand(cmd: ThermostatSetpointCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(setpointType: ThermostatSetpointType): Promise<{
        value: number;
        scale: Scale;
    } | undefined>;
    set(setpointType: ThermostatSetpointType, value: number, scale: number): Promise<void>;
    getCapabilities(setpointType: ThermostatSetpointType): Promise<Pick<ThermostatSetpointCCCapabilitiesReport, "minValue" | "maxValue" | "minValueScale" | "maxValueScale"> | undefined>;
    /**
     * Requests the supported setpoint types from the node. Due to inconsistencies it is NOT recommended
     * to use this method on nodes with CC versions 1 and 2. Instead rely on the information determined
     * during node interview.
     */
    getSupportedSetpointTypes(): Promise<readonly ThermostatSetpointType[] | undefined>;
}
export declare class ThermostatSetpointCC extends CommandClass {
    ccCommand: ThermostatSetpointCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    translatePropertyKey(property: string | number, propertyKey: string | number): string | undefined;
    interview(complete?: boolean): Promise<void>;
}
interface ThermostatSetpointCCSetOptions extends CCCommandOptions {
    setpointType: ThermostatSetpointType;
    value: number;
    scale: number;
}
export declare class ThermostatSetpointCCSet extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatSetpointCCSetOptions);
    setpointType: ThermostatSetpointType;
    value: number;
    scale: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetpointCCReport extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    private _type;
    get type(): ThermostatSetpointType;
    private _scale;
    get scale(): Scale;
    private _value;
    get value(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface ThermostatSetpointCCGetOptions extends CCCommandOptions {
    setpointType: ThermostatSetpointType;
}
export declare class ThermostatSetpointCCGet extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatSetpointCCGetOptions);
    setpointType: ThermostatSetpointType;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetpointCCCapabilitiesReport extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _type;
    get type(): ThermostatSetpointType;
    private _minValue;
    get minValue(): number;
    private _maxValue;
    get maxValue(): number;
    private _minValueScale;
    get minValueScale(): number;
    private _maxValueScale;
    get maxValueScale(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface ThermostatSetpointCCCapabilitiesGetOptions extends CCCommandOptions {
    setpointType: ThermostatSetpointType;
}
export declare class ThermostatSetpointCCCapabilitiesGet extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatSetpointCCCapabilitiesGetOptions);
    setpointType: ThermostatSetpointType;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetpointCCSupportedReport extends ThermostatSetpointCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedSetpointTypes;
    get supportedSetpointTypes(): readonly ThermostatSetpointType[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetpointCCSupportedGet extends ThermostatSetpointCC {
}
export {};
