"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatSetpointCCSupportedGet = exports.ThermostatSetpointCCSupportedReport = exports.ThermostatSetpointCCCapabilitiesGet = exports.ThermostatSetpointCCCapabilitiesReport = exports.ThermostatSetpointCCGet = exports.ThermostatSetpointCCReport = exports.ThermostatSetpointCCSet = exports.ThermostatSetpointCC = exports.ThermostatSetpointCCAPI = exports.ThermostatSetpointType = exports.ThermostatSetpointCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var ThermostatSetpointCommand;
(function (ThermostatSetpointCommand) {
    ThermostatSetpointCommand[ThermostatSetpointCommand["Set"] = 1] = "Set";
    ThermostatSetpointCommand[ThermostatSetpointCommand["Get"] = 2] = "Get";
    ThermostatSetpointCommand[ThermostatSetpointCommand["Report"] = 3] = "Report";
    ThermostatSetpointCommand[ThermostatSetpointCommand["SupportedGet"] = 4] = "SupportedGet";
    ThermostatSetpointCommand[ThermostatSetpointCommand["SupportedReport"] = 5] = "SupportedReport";
    ThermostatSetpointCommand[ThermostatSetpointCommand["CapabilitiesGet"] = 9] = "CapabilitiesGet";
    ThermostatSetpointCommand[ThermostatSetpointCommand["CapabilitiesReport"] = 10] = "CapabilitiesReport";
})(ThermostatSetpointCommand = exports.ThermostatSetpointCommand || (exports.ThermostatSetpointCommand = {}));
// TODO: Can we merge this with ThermostatMode?
/**
 * @publicAPI
 */
var ThermostatSetpointType;
(function (ThermostatSetpointType) {
    ThermostatSetpointType[ThermostatSetpointType["N/A"] = 0] = "N/A";
    ThermostatSetpointType[ThermostatSetpointType["Heating"] = 1] = "Heating";
    ThermostatSetpointType[ThermostatSetpointType["Cooling"] = 2] = "Cooling";
    ThermostatSetpointType[ThermostatSetpointType["Furnace"] = 7] = "Furnace";
    ThermostatSetpointType[ThermostatSetpointType["Dry Air"] = 8] = "Dry Air";
    ThermostatSetpointType[ThermostatSetpointType["Moist Air"] = 9] = "Moist Air";
    ThermostatSetpointType[ThermostatSetpointType["Auto Changeover"] = 10] = "Auto Changeover";
    ThermostatSetpointType[ThermostatSetpointType["Energy Save Heating"] = 11] = "Energy Save Heating";
    ThermostatSetpointType[ThermostatSetpointType["Energy Save Cooling"] = 12] = "Energy Save Cooling";
    ThermostatSetpointType[ThermostatSetpointType["Away Heating"] = 13] = "Away Heating";
    ThermostatSetpointType[ThermostatSetpointType["Away Cooling"] = 14] = "Away Cooling";
    ThermostatSetpointType[ThermostatSetpointType["Full Power"] = 15] = "Full Power";
})(ThermostatSetpointType = exports.ThermostatSetpointType || (exports.ThermostatSetpointType = {}));
// This array is used to map the advertised supported types (interpretation A)
// to the actual enum values
// prettier-ignore
const thermostatSetpointTypeMap = [0x00, 0x01, 0x02, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f];
const thermostatSetpointScaleName = "temperature";
function getScale(configManager, scale) {
    return configManager.lookupNamedScale(thermostatSetpointScaleName, scale);
}
function getSetpointUnit(configManager, scale) {
    var _c;
    return (_c = getScale(configManager, scale).unit) !== null && _c !== void 0 ? _c : "";
}
function getSupportedSetpointTypesValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Setpoint"],
        property: "supportedSetpointTypes",
        endpoint,
    };
}
function getSetpointTypesInterpretationValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Setpoint"],
        property: "setpointTypesInterpretation",
        endpoint,
    };
}
function getSetpointValueID(endpoint, setpointType) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Setpoint"],
        endpoint,
        property: "setpoint",
        propertyKey: setpointType,
    };
}
function getSetpointScaleValueID(endpoint, setpointType) {
    return {
        commandClass: core_1.CommandClasses["Thermostat Setpoint"],
        endpoint,
        property: "setpointScale",
        propertyKey: setpointType,
    };
}
let ThermostatSetpointCCAPI = class ThermostatSetpointCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, propertyKey }, value) => {
            if (property !== "setpoint") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof propertyKey !== "number") {
                throw new core_1.ZWaveError(`${core_1.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            if (typeof value !== "number") {
                API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
            }
            // SDS14223: The Scale field value MUST be identical to the value received in the Thermostat Setpoint Report for the
            // actual Setpoint Type during the node interview. Fall back to the first scale if none is known
            const preferredScale = this.endpoint
                .getNodeUnsafe()
                .getValue(getSetpointScaleValueID(this.endpoint.index, propertyKey));
            await this.set(propertyKey, value, preferredScale !== null && preferredScale !== void 0 ? preferredScale : 0);
            if (this.isSinglecast()) {
                // Verify the current value after a delay
                this.schedulePoll({ property, propertyKey });
            }
        };
        this[_b] = async ({ property, propertyKey, }) => {
            var _c;
            switch (property) {
                case "setpoint":
                    if (typeof propertyKey !== "number") {
                        throw new core_1.ZWaveError(`${core_1.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, core_1.ZWaveErrorCodes.Argument_Invalid);
                    }
                    return (_c = (await this.get(propertyKey))) === null || _c === void 0 ? void 0 : _c.value;
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatSetpointCommand.Get:
            case ThermostatSetpointCommand.SupportedGet:
                return this.isSinglecast();
            case ThermostatSetpointCommand.Set:
                return true; // This is mandatory
            case ThermostatSetpointCommand.CapabilitiesGet:
                return this.version >= 3 && this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(setpointType) {
        this.assertSupportsCommand(ThermostatSetpointCommand, ThermostatSetpointCommand.Get);
        const cc = new ThermostatSetpointCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            setpointType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (!response)
            return;
        return response.type === ThermostatSetpointType["N/A"]
            ? // not supported
                undefined
            : // supported
                {
                    value: response.value,
                    scale: response.scale,
                };
    }
    async set(setpointType, value, scale) {
        this.assertSupportsCommand(ThermostatSetpointCommand, ThermostatSetpointCommand.Set);
        const cc = new ThermostatSetpointCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            setpointType,
            value,
            scale,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities(setpointType) {
        this.assertSupportsCommand(ThermostatSetpointCommand, ThermostatSetpointCommand.CapabilitiesGet);
        const cc = new ThermostatSetpointCCCapabilitiesGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            setpointType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "minValue",
                "maxValue",
                "minValueScale",
                "maxValueScale",
            ]);
        }
    }
    /**
     * Requests the supported setpoint types from the node. Due to inconsistencies it is NOT recommended
     * to use this method on nodes with CC versions 1 and 2. Instead rely on the information determined
     * during node interview.
     */
    async getSupportedSetpointTypes() {
        this.assertSupportsCommand(ThermostatSetpointCommand, ThermostatSetpointCommand.SupportedGet);
        const cc = new ThermostatSetpointCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedSetpointTypes;
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ThermostatSetpointCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Setpoint"])
], ThermostatSetpointCCAPI);
exports.ThermostatSetpointCCAPI = ThermostatSetpointCCAPI;
let ThermostatSetpointCC = class ThermostatSetpointCC extends CommandClass_1.CommandClass {
    constructor(driver, options) {
        super(driver, options);
        this.registerValue(getSetpointTypesInterpretationValueID(0).property, true);
        // The setpoint scale is only used internally
        this.registerValue(getSetpointScaleValueID(0, 0).property, true);
    }
    translatePropertyKey(property, propertyKey) {
        if (property === "setpoint") {
            return shared_1.getEnumMemberName(ThermostatSetpointType, propertyKey);
        }
        else {
            return super.translatePropertyKey(property, propertyKey);
        }
    }
    async interview(complete = true) {
        var _c, _d, _e, _f;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Setpoint"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (this.version <= 2) {
            let setpointTypes;
            let interpretation;
            // Whether our tests changed the assumed bitmask interpretation
            let interpretationChanged = false;
            const supportedSetpointTypesValueId = getSupportedSetpointTypesValueID(this.endpointIndex);
            // If we haven't yet, query the supported setpoint types
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "retrieving supported setpoint types...",
                    direction: "outbound",
                });
                const resp = await api.getSupportedSetpointTypes();
                if (!resp) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Querying supported setpoint types timed out, skipping interview...",
                        level: "warn",
                    });
                    return;
                }
                setpointTypes = [...resp];
                interpretation = undefined; // we don't know yet which interpretation the device uses
            }
            else {
                setpointTypes = (_c = this.getValueDB().getValue(supportedSetpointTypesValueId)) !== null && _c !== void 0 ? _c : [];
                interpretation = this.getValueDB().getValue(getSetpointTypesInterpretationValueID(this.endpointIndex));
            }
            // If necessary, test which interpretation the device follows
            // Assume interpretation B
            // --> If setpoints 3,4,5 or 6 are supported, the assumption is wrong ==> A
            function switchToInterpretationA() {
                setpointTypes = setpointTypes.map((i) => thermostatSetpointTypeMap[i]);
                interpretation = "A";
                interpretationChanged = true;
            }
            if (!interpretation) {
                if ([3, 4, 5, 6].some((type) => setpointTypes.includes(type))) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "uses Thermostat Setpoint bitmap interpretation A",
                        direction: "none",
                    });
                    switchToInterpretationA();
                }
                else {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Thermostat Setpoint bitmap interpretation is unknown, assuming B for now",
                        direction: "none",
                    });
                }
            }
            else if (interpretation === "A") {
                setpointTypes = setpointTypes.map((i) => thermostatSetpointTypeMap[i]);
            }
            // Now scan all endpoints. Each type we received a value for gets marked as supported
            const supportedSetpointTypes = [];
            for (let i = 0; i < setpointTypes.length; i++) {
                const type = setpointTypes[i];
                const setpointName = shared_1.getEnumMemberName(ThermostatSetpointType, type);
                // Every time, query the current value
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying current value of setpoint ${setpointName}...`,
                    direction: "outbound",
                });
                const setpoint = await api.get(type);
                // If the node did not respond, assume the setpoint type is not supported
                let logMessage;
                if (setpoint) {
                    // Setpoint supported, remember the type
                    supportedSetpointTypes.push(type);
                    logMessage = `received current value of setpoint ${setpointName}: ${setpoint.value} ${(_d = setpoint.scale.unit) !== null && _d !== void 0 ? _d : ""}`;
                }
                else if (!interpretation) {
                    // The setpoint type is not supported, switch to interpretation A
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `the setpoint type ${type} is unsupported, switching to interpretation A`,
                        direction: "none",
                    });
                    switchToInterpretationA();
                    // retry the current type and scan the remaining types as A
                    i--;
                    continue;
                }
                else {
                    // We're sure about the interpretation - this should not happen
                    logMessage = `Setpoint ${setpointName} is not supported`;
                }
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            // If we made an assumption and did not switch to interpretation A,
            // the device adheres to interpretation B
            // wotan-disable-next-line no-useless-predicate
            if (!interpretation && !interpretationChanged) {
                // our assumption about interpretation B was correct
                interpretation = "B";
                interpretationChanged = true;
            }
            // After a complete interview, we need to remember which setpoint types are supported
            if (complete) {
                this.getValueDB().setValue(supportedSetpointTypesValueId, supportedSetpointTypes);
            }
            // Also save the bitmap interpretation if we know it now
            if (interpretationChanged) {
                this.getValueDB().setValue(getSetpointTypesInterpretationValueID(this.endpointIndex), interpretation);
            }
        }
        else {
            // Versions >= 3 adhere to bitmap interpretation A, so we can rely on getSupportedSetpointTypes
            // If we haven't yet, query the supported setpoint types
            let setpointTypes = [];
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "retrieving supported setpoint types...",
                    direction: "outbound",
                });
                const resp = await api.getSupportedSetpointTypes();
                if (resp) {
                    setpointTypes = [...resp];
                    const logMessage = "received supported setpoint types:\n" +
                        setpointTypes
                            .map((type) => shared_1.getEnumMemberName(ThermostatSetpointType, type))
                            .map((name) => `· ${name}`)
                            .join("\n");
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
                else {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Querying supported setpoint types timed out, skipping interview...",
                        level: "warn",
                    });
                    return;
                }
            }
            else {
                setpointTypes = (_e = this.getValueDB().getValue({
                    commandClass: this.ccId,
                    property: "supportedSetpointTypes",
                    endpoint: this.endpointIndex,
                })) !== null && _e !== void 0 ? _e : [];
            }
            for (const type of setpointTypes) {
                const setpointName = shared_1.getEnumMemberName(ThermostatSetpointType, type);
                // If we haven't yet, find out the capabilities of this setpoint
                if (complete) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `retrieving capabilities for setpoint ${setpointName}...`,
                        direction: "outbound",
                    });
                    const setpointCaps = await api.getCapabilities(type);
                    if (setpointCaps) {
                        const minValueUnit = getSetpointUnit(this.driver.configManager, setpointCaps.minValueScale);
                        const maxValueUnit = getSetpointUnit(this.driver.configManager, setpointCaps.maxValueScale);
                        const logMessage = `received capabilities for setpoint ${setpointName}:
minimum value: ${setpointCaps.minValue} ${minValueUnit}
maximum value: ${setpointCaps.maxValue} ${maxValueUnit}`;
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: logMessage,
                            direction: "inbound",
                        });
                    }
                }
                // Every time, query the current value
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying current value of setpoint ${setpointName}...`,
                    direction: "outbound",
                });
                const setpoint = await api.get(type);
                if (setpoint) {
                    const logMessage = `received current value of setpoint ${setpointName}: ${setpoint.value} ${(_f = setpoint.scale.unit) !== null && _f !== void 0 ? _f : ""}`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatSetpointCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Setpoint"]),
    CommandClass_1.implementedVersion(3)
], ThermostatSetpointCC);
exports.ThermostatSetpointCC = ThermostatSetpointCC;
let ThermostatSetpointCCSet = class ThermostatSetpointCCSet extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.setpointType = options.setpointType;
            this.value = options.value;
            this.scale = options.scale;
        }
    }
    serialize() {
        var _c, _d, _e;
        // If a config file overwrites how the float should be encoded, use that information
        const override = (_e = (_d = (_c = this.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.deviceConfig) === null || _d === void 0 ? void 0 : _d.compat) === null || _e === void 0 ? void 0 : _e.overrideFloatEncoding;
        this.payload = Buffer.concat([
            Buffer.from([this.setpointType & 0b1111]),
            core_1.encodeFloatWithScale(this.value, this.scale, override),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const scale = getScale(this.driver.configManager, this.scale);
        return {
            ...super.toLogEntry(),
            message: {
                "setpoint type": shared_1.getEnumMemberName(ThermostatSetpointType, this.setpointType),
                value: `${this.value} ${scale.unit}`,
            },
        };
    }
};
ThermostatSetpointCCSet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.Set)
], ThermostatSetpointCCSet);
exports.ThermostatSetpointCCSet = ThermostatSetpointCCSet;
let ThermostatSetpointCCReport = class ThermostatSetpointCCReport extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._type = this.payload[0] & 0b1111;
        if (this._type === 0) {
            // Not supported
            this._value = 0;
            this._scale = getScale(this.driver.configManager, 0);
            return;
        }
        // parseFloatWithScale does its own validation
        const { value, scale } = core_1.parseFloatWithScale(this.payload.slice(1));
        this._value = value;
        this._scale = getScale(this.driver.configManager, scale);
        this.persistValues();
    }
    persistValues() {
        const setpointValueId = getSetpointValueID(this.endpointIndex, this._type);
        if (!this.getValueDB().hasMetadata(setpointValueId)) {
            this.getValueDB().setMetadata(setpointValueId, {
                ...core_1.ValueMetadata.Number,
                unit: this._scale.unit,
                ccSpecific: {
                    setpointType: this._type,
                },
            });
        }
        this.getValueDB().setValue(setpointValueId, this._value);
        // Remember the device-preferred setpoint scale so it can be used in SET commands
        const scaleValueId = getSetpointScaleValueID(this.endpointIndex, this._type);
        this.getValueDB().setValue(scaleValueId, this._scale.key);
        return true;
    }
    get type() {
        return this._type;
    }
    get scale() {
        return this._scale;
    }
    get value() {
        return this._value;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "setpoint type": shared_1.getEnumMemberName(ThermostatSetpointType, this.type),
                value: `${this.value} ${this.scale.unit}`,
            },
        };
    }
};
ThermostatSetpointCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.Report)
], ThermostatSetpointCCReport);
exports.ThermostatSetpointCCReport = ThermostatSetpointCCReport;
function testResponseForThermostatSetpointGet(sent, received) {
    // We expect a Thermostat Setpoint Report that matches the requested setpoint type
    return received.type === sent.setpointType;
}
let ThermostatSetpointCCGet = class ThermostatSetpointCCGet extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.setpointType = options.setpointType;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.setpointType & 0b1111]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "setpoint type": shared_1.getEnumMemberName(ThermostatSetpointType, this.setpointType),
            },
        };
    }
};
ThermostatSetpointCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatSetpointCCReport, testResponseForThermostatSetpointGet)
], ThermostatSetpointCCGet);
exports.ThermostatSetpointCCGet = ThermostatSetpointCCGet;
let ThermostatSetpointCCCapabilitiesReport = class ThermostatSetpointCCCapabilitiesReport extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._type = this.payload[0];
        let bytesRead;
        // parseFloatWithScale does its own validation
        ({
            value: this._minValue,
            scale: this._minValueScale,
            bytesRead,
        } = core_1.parseFloatWithScale(this.payload.slice(1)));
        ({
            value: this._maxValue,
            scale: this._maxValueScale,
        } = core_1.parseFloatWithScale(this.payload.slice(1 + bytesRead)));
        // Predefine the metadata
        const valueId = getSetpointValueID(this.endpointIndex, this._type);
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.Number,
            min: this._minValue,
            max: this._maxValue,
            unit: getSetpointUnit(this.driver.configManager, this._minValueScale) ||
                getSetpointUnit(this.driver.configManager, this._maxValueScale),
            ccSpecific: {
                setpointType: this._type,
            },
        });
        this.persistValues();
    }
    get type() {
        return this._type;
    }
    get minValue() {
        return this._minValue;
    }
    get maxValue() {
        return this._maxValue;
    }
    get minValueScale() {
        return this._minValueScale;
    }
    get maxValueScale() {
        return this._maxValueScale;
    }
    toLogEntry() {
        const minValueScale = getScale(this.driver.configManager, this.minValueScale);
        const maxValueScale = getScale(this.driver.configManager, this.maxValueScale);
        return {
            ...super.toLogEntry(),
            message: {
                "setpoint type": shared_1.getEnumMemberName(ThermostatSetpointType, this._type),
                "min value": `${this.minValue} ${minValueScale.unit}`,
                "max value": `${this.maxValue} ${maxValueScale.unit}`,
            },
        };
    }
};
ThermostatSetpointCCCapabilitiesReport = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.CapabilitiesReport)
], ThermostatSetpointCCCapabilitiesReport);
exports.ThermostatSetpointCCCapabilitiesReport = ThermostatSetpointCCCapabilitiesReport;
let ThermostatSetpointCCCapabilitiesGet = class ThermostatSetpointCCCapabilitiesGet extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.setpointType = options.setpointType;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.setpointType & 0b1111]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "setpoint type": shared_1.getEnumMemberName(ThermostatSetpointType, this.setpointType),
            },
        };
    }
};
ThermostatSetpointCCCapabilitiesGet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.CapabilitiesGet),
    CommandClass_1.expectedCCResponse(ThermostatSetpointCCCapabilitiesReport)
], ThermostatSetpointCCCapabilitiesGet);
exports.ThermostatSetpointCCCapabilitiesGet = ThermostatSetpointCCCapabilitiesGet;
let ThermostatSetpointCCSupportedReport = class ThermostatSetpointCCSupportedReport extends ThermostatSetpointCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        const bitMask = this.payload;
        const supported = core_1.parseBitMask(bitMask, ThermostatSetpointType["N/A"]);
        if (this.version >= 3) {
            // Interpretation A
            this._supportedSetpointTypes = supported.map((i) => thermostatSetpointTypeMap[i]);
        }
        else {
            // It is unknown which interpretation the device complies to.
            // This must be tested during the interview
            this._supportedSetpointTypes = supported;
        }
        this.persistValues();
        // TODO:
        // Some devices skip the gaps in the ThermostatSetpointType (Interpretation A), some don't (Interpretation B)
        // Devices with V3+ must comply with Interpretation A
        // It is RECOMMENDED that a controlling node determines supported Setpoint Types
        // by sending one Thermostat Setpoint Get Command at a time while incrementing
        // the requested Setpoint Type. If the same Setpoint Type is advertised in the
        // resulting Thermostat Setpoint Report Command, the controlling node MAY conclude
        // that the actual Setpoint Type is supported. If the Setpoint Type 0x00 (type N/A)
        // is advertised in the resulting Thermostat Setpoint Report Command, the controlling
        // node MUST conclude that the actual Setpoint Type is not supported.
    }
    get supportedSetpointTypes() {
        return this._supportedSetpointTypes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported setpoint types": this.supportedSetpointTypes
                    .map((t) => `\n· ${shared_1.getEnumMemberName(ThermostatSetpointType, t)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ThermostatSetpointCCSupportedReport.prototype, "supportedSetpointTypes", null);
ThermostatSetpointCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.SupportedReport)
], ThermostatSetpointCCSupportedReport);
exports.ThermostatSetpointCCSupportedReport = ThermostatSetpointCCSupportedReport;
let ThermostatSetpointCCSupportedGet = 
/**
 * Issues a SupportedGet command to the node. Due to inconsistencies in interpretation,
 * this command should not be used for nodes with CC versions 1 or 2
 */
class ThermostatSetpointCCSupportedGet extends ThermostatSetpointCC {
};
ThermostatSetpointCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetpointCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(ThermostatSetpointCCSupportedReport)
    /**
     * Issues a SupportedGet command to the node. Due to inconsistencies in interpretation,
     * this command should not be used for nodes with CC versions 1 or 2
     */
], ThermostatSetpointCCSupportedGet);
exports.ThermostatSetpointCCSupportedGet = ThermostatSetpointCCSupportedGet;

//# sourceMappingURL=ThermostatSetpointCC.js.map
