"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeParametersCCSet = exports.TimeParametersCCGet = exports.TimeParametersCCReport = exports.TimeParametersCC = exports.TimeParametersCCAPI = exports.TimeParametersCommand = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var TimeParametersCommand;
(function (TimeParametersCommand) {
    TimeParametersCommand[TimeParametersCommand["Set"] = 1] = "Set";
    TimeParametersCommand[TimeParametersCommand["Get"] = 2] = "Get";
    TimeParametersCommand[TimeParametersCommand["Report"] = 3] = "Report";
})(TimeParametersCommand = exports.TimeParametersCommand || (exports.TimeParametersCommand = {}));
/**
 * Determines if the node expects local time instead of UTC.
 */
function shouldUseLocalTime(endpoint) {
    // GH#311 Some nodes have no way to determine the time zone offset,
    // so they need to interpret the set time as local time instead of UTC.
    //
    // This is the case when they both
    // 1. DON'T control TimeCC V1, so they cannot request the local time
    // 2. DON'T support TimeCC V2, so the controller cannot specify the timezone offset
    // Incidentally, this is also true when they don't support TimeCC at all
    const ccVersion = endpoint.getCCVersion(core_1.CommandClasses.Time);
    if (ccVersion >= 1 && endpoint.controlsCC(core_1.CommandClasses.Time))
        return false;
    if (ccVersion >= 2 && endpoint.supportsCC(core_1.CommandClasses.Time))
        return false;
    return true;
}
function segmentsToDate(segments, local) {
    if (local) {
        return new Date(segments.year, segments.month - 1, segments.day, segments.hour, segments.minute, segments.second);
    }
    else {
        return new Date(Date.UTC(segments.year, segments.month - 1, segments.day, segments.hour, segments.minute, segments.second));
    }
}
function dateToSegments(date, local) {
    return {
        year: date[`get${local ? "" : "UTC"}FullYear`](),
        month: date[`get${local ? "" : "UTC"}Month`]() + 1,
        day: date[`get${local ? "" : "UTC"}Date`](),
        hour: date[`get${local ? "" : "UTC"}Hours`](),
        minute: date[`get${local ? "" : "UTC"}Minutes`](),
        second: date[`get${local ? "" : "UTC"}Seconds`](),
    };
}
let TimeParametersCCAPI = class TimeParametersCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "dateAndTime") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (!(value instanceof Date)) {
                API_1.throwWrongValueType(this.ccId, property, "date", typeof value);
            }
            await this.set(value);
        };
        this[_b] = async ({ property, }) => {
            switch (property) {
                case "dateAndTime":
                    return this.get();
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case TimeParametersCommand.Get:
                return this.isSinglecast();
            case TimeParametersCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async get() {
        this.assertSupportsCommand(TimeParametersCommand, TimeParametersCommand.Get);
        const cc = new TimeParametersCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.dateAndTime;
    }
    async set(dateAndTime) {
        this.assertSupportsCommand(TimeParametersCommand, TimeParametersCommand.Set);
        const cc = new TimeParametersCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            dateAndTime,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
TimeParametersCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Time Parameters"])
], TimeParametersCCAPI);
exports.TimeParametersCCAPI = TimeParametersCCAPI;
let TimeParametersCC = class TimeParametersCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Time Parameters"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Always keep the node's time in sync
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "setting current time...",
            direction: "outbound",
        });
        await api.set(new Date());
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
TimeParametersCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Time Parameters"]),
    CommandClass_1.implementedVersion(1)
], TimeParametersCC);
exports.TimeParametersCC = TimeParametersCC;
let TimeParametersCCReport = class TimeParametersCCReport extends TimeParametersCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 7);
        const dateSegments = {
            year: this.payload.readUInt16BE(0),
            month: this.payload[2],
            day: this.payload[3],
            hour: this.payload[4],
            minute: this.payload[5],
            second: this.payload[6],
        };
        this.dateAndTime = segmentsToDate(dateSegments, shouldUseLocalTime(this.getNode().getEndpoint(this.endpointIndex)));
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "date and time": core_1.formatDate(this.dateAndTime, "YYYY-MM-DD HH:mm:ss"),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue()
], TimeParametersCCReport.prototype, "dateAndTime", void 0);
TimeParametersCCReport = __decorate([
    CommandClass_1.CCCommand(TimeParametersCommand.Report)
], TimeParametersCCReport);
exports.TimeParametersCCReport = TimeParametersCCReport;
let TimeParametersCCGet = class TimeParametersCCGet extends TimeParametersCC {
};
TimeParametersCCGet = __decorate([
    CommandClass_1.CCCommand(TimeParametersCommand.Get),
    CommandClass_1.expectedCCResponse(TimeParametersCCReport)
], TimeParametersCCGet);
exports.TimeParametersCCGet = TimeParametersCCGet;
let TimeParametersCCSet = class TimeParametersCCSet extends TimeParametersCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 7);
            const dateSegments = {
                year: this.payload.readUInt16BE(0),
                month: this.payload[2],
                day: this.payload[3],
                hour: this.payload[4],
                minute: this.payload[5],
                second: this.payload[6],
            };
            core_1.validatePayload(dateSegments.month >= 1 && dateSegments.month <= 12, dateSegments.day >= 1 && dateSegments.day <= 31, dateSegments.hour >= 0 && dateSegments.hour <= 23, dateSegments.minute >= 0 && dateSegments.minute <= 59, dateSegments.second >= 0 && dateSegments.second <= 59);
            this.dateAndTime = segmentsToDate(dateSegments, shouldUseLocalTime(this.getNode().getEndpoint(this.endpointIndex)));
        }
        else {
            this.dateAndTime = options.dateAndTime;
        }
    }
    serialize() {
        const dateSegments = dateToSegments(this.dateAndTime, shouldUseLocalTime(this.getNode().getEndpoint(this.endpointIndex)));
        this.payload = Buffer.from([
            // 2 bytes placeholder for year
            0,
            0,
            dateSegments.month,
            dateSegments.day,
            dateSegments.hour,
            dateSegments.minute,
            dateSegments.second,
        ]);
        this.payload.writeUInt16BE(dateSegments.year, 0);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "date and time": core_1.formatDate(this.dateAndTime, "YYYY-MM-DD HH:mm:ss"),
            },
        };
    }
};
TimeParametersCCSet = __decorate([
    CommandClass_1.CCCommand(TimeParametersCommand.Set)
], TimeParametersCCSet);
exports.TimeParametersCCSet = TimeParametersCCSet;

//# sourceMappingURL=TimeParametersCC.js.map
