/// <reference types="node" />
import { MessageOrCCLogEntry } from "@zwave-js/core";
import { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions, MessageOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
import type { INodeQuery } from "../node/INodeQuery";
import { TransmitStatus } from "./SendDataMessages";
export declare class DeleteReturnRouteRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
export interface DeleteReturnRouteRequestOptions extends MessageBaseOptions {
    nodeId: number;
}
export declare class DeleteReturnRouteRequest extends DeleteReturnRouteRequestBase implements INodeQuery {
    constructor(driver: Driver, options: MessageDeserializationOptions | DeleteReturnRouteRequestOptions);
    nodeId: number;
    serialize(): Buffer;
}
export declare class DeleteReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    readonly hasStarted: boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class DeleteReturnRouteRequestTransmitReport extends DeleteReturnRouteRequestBase implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _transmitStatus;
    get transmitStatus(): TransmitStatus;
    isOK(): boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
