/// <reference types="node" />
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions, MessageOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
export declare enum RemoveFailedNodeStartFlags {
    OK = 0,
    /** The removing process was aborted because the controller  is not the primary one */
    NotPrimaryController = 2,
    /** The removing process was aborted because no call back function is used */
    NoCallbackFunction = 4,
    /** The removing process aborted because the node was node found */
    NodeNotFound = 8,
    /** The removing process is busy */
    RemoveProcessBusy = 16,
    /** The removing process could not be started*/
    RemoveFailed = 32
}
export declare enum RemoveFailedNodeStatus {
    /** The node is working properly (removed from the failed nodes list ) */
    NodeOK = 0,
    /** The failed node was removed from the failed nodes list */
    NodeRemoved = 1,
    /** The failed node was not removed from the failing nodes list */
    NodeNotRemoved = 2
}
export declare class RemoveFailedNodeRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
interface RemoveFailedNodeRequestOptions extends MessageBaseOptions {
    failedNodeId: number;
}
export declare class RemoveFailedNodeRequest extends RemoveFailedNodeRequestBase {
    constructor(driver: Driver, options: RemoveFailedNodeRequestOptions);
    /** The node that should be removed */
    failedNodeId: number;
    serialize(): Buffer;
}
export declare class RemoveFailedNodeRequestStatusReport extends RemoveFailedNodeRequestBase implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _removeStatus;
    get removeStatus(): RemoveFailedNodeStatus;
    isOK(): boolean;
}
export declare class RemoveFailedNodeResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _removeStatus;
    get removeStatus(): RemoveFailedNodeStartFlags;
    isOK(): boolean;
}
export {};
