"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encodeSwitchpoint = exports.decodeSwitchpoint = void 0;
const core_1 = require("@zwave-js/core");
const SetbackState_1 = require("./SetbackState");
function decodeSwitchpoint(data) {
    return {
        hour: data[0] & 31,
        minute: data[1] & 63,
        state: SetbackState_1.decodeSetbackState(data[2]),
    };
}
exports.decodeSwitchpoint = decodeSwitchpoint;
function encodeSwitchpoint(point) {
    if (point.state == undefined)
        throw new core_1.ZWaveError("The given Switchpoint is not valid!", core_1.ZWaveErrorCodes.CC_Invalid);
    return Buffer.from([
        point.hour & 31,
        point.minute & 63,
        SetbackState_1.encodeSetbackState(point.state),
    ]);
}
exports.encodeSwitchpoint = encodeSwitchpoint;

//# sourceMappingURL=Switchpoint.js.map
