"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZWaveError = exports.ZWaveErrorCodes = void 0;
/**
 * Used to identify errors from this library without relying on the error message
 */
var ZWaveErrorCodes;
(function (ZWaveErrorCodes) {
    ZWaveErrorCodes[ZWaveErrorCodes["PacketFormat_Truncated"] = 0] = "PacketFormat_Truncated";
    ZWaveErrorCodes[ZWaveErrorCodes["PacketFormat_Invalid"] = 1] = "PacketFormat_Invalid";
    ZWaveErrorCodes[ZWaveErrorCodes["PacketFormat_Checksum"] = 2] = "PacketFormat_Checksum";
    // This differs from the above three. It means that the packet has a valid format and checksum,
    // but the data does not match the expectations. This error does not reset the Z-Wave stack
    ZWaveErrorCodes[ZWaveErrorCodes["PacketFormat_InvalidPayload"] = 3] = "PacketFormat_InvalidPayload";
    ZWaveErrorCodes[ZWaveErrorCodes["PacketFormat_DecryptionFailed"] = 4] = "PacketFormat_DecryptionFailed";
    /** The driver failed to start */
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_Failed"] = 5] = "Driver_Failed";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_Reset"] = 6] = "Driver_Reset";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_Destroyed"] = 7] = "Driver_Destroyed";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_NotReady"] = 8] = "Driver_NotReady";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_InvalidDataReceived"] = 9] = "Driver_InvalidDataReceived";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_NotSupported"] = 10] = "Driver_NotSupported";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_NoPriority"] = 11] = "Driver_NoPriority";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_InvalidCache"] = 12] = "Driver_InvalidCache";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_InvalidOptions"] = 13] = "Driver_InvalidOptions";
    /** The driver tried to do something that requires security */
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_NoSecurity"] = 14] = "Driver_NoSecurity";
    ZWaveErrorCodes[ZWaveErrorCodes["Driver_NoErrorHandler"] = 15] = "Driver_NoErrorHandler";
    /** The controller has timed out while waiting for a report from the node */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_Timeout"] = 16] = "Controller_Timeout";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_NodeTimeout"] = 17] = "Controller_NodeTimeout";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_MessageDropped"] = 18] = "Controller_MessageDropped";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_ResponseNOK"] = 19] = "Controller_ResponseNOK";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_CallbackNOK"] = 20] = "Controller_CallbackNOK";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_InclusionFailed"] = 21] = "Controller_InclusionFailed";
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_ExclusionFailed"] = 22] = "Controller_ExclusionFailed";
    /** The node with the given node ID was not found */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_NodeNotFound"] = 23] = "Controller_NodeNotFound";
    /** The endpoint with the given index was not found on the node */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_EndpointNotFound"] = 24] = "Controller_EndpointNotFound";
    /** The node was removed from the network */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_NodeRemoved"] = 25] = "Controller_NodeRemoved";
    /** Communication with the node will be insecure (no security configured) */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_NodeInsecureCommunication"] = 26] = "Controller_NodeInsecureCommunication";
    /** The message has expired (the given timeout has elapsed) */
    ZWaveErrorCodes[ZWaveErrorCodes["Controller_MessageExpired"] = 27] = "Controller_MessageExpired";
    ZWaveErrorCodes[ZWaveErrorCodes["CC_Invalid"] = 28] = "CC_Invalid";
    ZWaveErrorCodes[ZWaveErrorCodes["CC_NoNodeID"] = 29] = "CC_NoNodeID";
    ZWaveErrorCodes[ZWaveErrorCodes["CC_NotSupported"] = 30] = "CC_NotSupported";
    ZWaveErrorCodes[ZWaveErrorCodes["CC_NotImplemented"] = 31] = "CC_NotImplemented";
    ZWaveErrorCodes[ZWaveErrorCodes["CC_NoAPI"] = 32] = "CC_NoAPI";
    ZWaveErrorCodes[ZWaveErrorCodes["Deserialization_NotImplemented"] = 33] = "Deserialization_NotImplemented";
    ZWaveErrorCodes[ZWaveErrorCodes["Arithmetic"] = 34] = "Arithmetic";
    ZWaveErrorCodes[ZWaveErrorCodes["Argument_Invalid"] = 35] = "Argument_Invalid";
    ZWaveErrorCodes[ZWaveErrorCodes["Config_Invalid"] = 36] = "Config_Invalid";
    ZWaveErrorCodes[ZWaveErrorCodes["Config_NotFound"] = 37] = "Config_NotFound";
    // Here follow message specific errors
    /** The removal process could not be started or completed due to one or several reasons */
    ZWaveErrorCodes[ZWaveErrorCodes["RemoveFailedNode_Failed"] = 38] = "RemoveFailedNode_Failed";
    /** The removal process was aborted because the node has responded */
    ZWaveErrorCodes[ZWaveErrorCodes["RemoveFailedNode_NodeOK"] = 39] = "RemoveFailedNode_NodeOK";
    /** The replace process could not be started or completed due to one or several reasons */
    ZWaveErrorCodes[ZWaveErrorCodes["ReplaceFailedNode_Failed"] = 40] = "ReplaceFailedNode_Failed";
    /** The replace process was aborted because the node has responded */
    ZWaveErrorCodes[ZWaveErrorCodes["ReplaceFailedNode_NodeOK"] = 41] = "ReplaceFailedNode_NodeOK";
    // Here follow CC specific errors
    /**
     * Used to report the first existing parameter number
     * available in a node's configuration
     */
    ZWaveErrorCodes[ZWaveErrorCodes["ConfigurationCC_FirstParameterNumber"] = 1000] = "ConfigurationCC_FirstParameterNumber";
    /**
     * Used to report that a V3+ node should not have its parameters scanned with get/set commands
     */
    ZWaveErrorCodes[ZWaveErrorCodes["ConfigurationCC_NoLegacyScanOnNewDevices"] = 1001] = "ConfigurationCC_NoLegacyScanOnNewDevices";
    /**
     * Used to report that a node using V3 or less MUST not use the resetToDefault flag
     */
    ZWaveErrorCodes[ZWaveErrorCodes["ConfigurationCC_NoResetToDefaultOnLegacyDevices"] = 1002] = "ConfigurationCC_NoResetToDefaultOnLegacyDevices";
    /**
     * Used to report that the command was not executed by the target node
     */
    ZWaveErrorCodes[ZWaveErrorCodes["SupervisionCC_CommandFailed"] = 1100] = "SupervisionCC_CommandFailed";
    /**
     * Used to report that a ManufacturerProprietaryCC could not be instanciated
     * because of a missing manufacturer ID.
     */
    ZWaveErrorCodes[ZWaveErrorCodes["ManufacturerProprietaryCC_NoManufacturerId"] = 1200] = "ManufacturerProprietaryCC_NoManufacturerId";
    /**
     * Used to report that an invalid group ID was used to address a (Multi Channel) Association
     */
    ZWaveErrorCodes[ZWaveErrorCodes["AssociationCC_InvalidGroup"] = 1300] = "AssociationCC_InvalidGroup";
    /** Cannot add an association because it is not allowed */
    ZWaveErrorCodes[ZWaveErrorCodes["AssociationCC_NotAllowed"] = 1301] = "AssociationCC_NotAllowed";
    /** Used to report that no nonce exists */
    ZWaveErrorCodes[ZWaveErrorCodes["SecurityCC_NoNonce"] = 1400] = "SecurityCC_NoNonce";
    /** The firmware update process is already active */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_Busy"] = 1500] = "FirmwareUpdateCC_Busy";
    /** The selected firmware target is not upgradable */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_NotUpgradable"] = 1501] = "FirmwareUpdateCC_NotUpgradable";
    /** The selected firmware target does not exist */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_TargetNotFound"] = 1502] = "FirmwareUpdateCC_TargetNotFound";
    /** The node reported that it could not start the update */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_FailedToStart"] = 1503] = "FirmwareUpdateCC_FailedToStart";
    /** The node did not confirm the aborted update */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_FailedToAbort"] = 1504] = "FirmwareUpdateCC_FailedToAbort";
    /** The node did not confirm the completed update or the process stalled for too long */
    ZWaveErrorCodes[ZWaveErrorCodes["FirmwareUpdateCC_Timeout"] = 1505] = "FirmwareUpdateCC_Timeout";
    /** An invalid firmware file was provided that cannot be handled by this library */
    ZWaveErrorCodes[ZWaveErrorCodes["Invalid_Firmware_File"] = 1506] = "Invalid_Firmware_File";
    /** An firmware file with an unsupported format was provided */
    ZWaveErrorCodes[ZWaveErrorCodes["Unsupported_Firmware_Format"] = 1507] = "Unsupported_Firmware_Format";
})(ZWaveErrorCodes = exports.ZWaveErrorCodes || (exports.ZWaveErrorCodes = {}));
/**
 * Errors thrown in this library are of this type. The `code` property identifies what went wrong.
 */
class ZWaveError extends Error {
    constructor(message, code, 
    /** Additional info required to handle this error (e.g. the Z-Wave message indicating the failure) */
    context, 
    /** If this error corresponds to a failed transaction, this contains the stack where it was created */
    transactionSource) {
        super(message);
        this.message = message;
        this.code = code;
        this.context = context;
        this.transactionSource = transactionSource;
        // We need to set the prototype explicitly
        Object.setPrototypeOf(this, ZWaveError.prototype);
        Object.getPrototypeOf(this).name = "ZWaveError";
    }
}
exports.ZWaveError = ZWaveError;
//# sourceMappingURL=ZWaveError.js.map