"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.skipBytes = exports.getEnumMemberName = exports.flatMap = exports.pick = exports.keysOf = void 0;
const strings_1 = require("./strings");
/** Object.keys, but with `(keyof T)[]` as the return type */
function keysOf(obj) {
    return Object.keys(obj);
}
exports.keysOf = keysOf;
/** Returns a subset of `obj` that contains only the given keys */
function pick(obj, keys) {
    const ret = {};
    for (const key of keys) {
        if (key in obj)
            ret[key] = obj[key];
    }
    return ret;
}
exports.pick = pick;
/** Calls the map function of the given array and flattens the result by one level */
function flatMap(array, callbackfn) {
    const mapped = array.map(callbackfn);
    return mapped.reduce((acc, cur) => [...acc, ...cur], []);
}
exports.flatMap = flatMap;
function getEnumMemberName(enumeration, value) {
    return enumeration[value] || `unknown (${strings_1.num2hex(value)})`;
}
exports.getEnumMemberName = getEnumMemberName;
/** Skips the first n bytes of a buffer and returns the rest */
function skipBytes(buf, n) {
    return Buffer.from(buf.slice(n));
}
exports.skipBytes = skipBytes;
//# sourceMappingURL=misc.js.map