"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPrintableASCII = exports.buffer2hex = exports.stringify = exports.num2hex = exports.cpp2js = void 0;
/** Translates a null-terminated (C++) string to JS */
function cpp2js(str) {
    const nullIndex = str.indexOf("\0");
    if (nullIndex === -1)
        return str;
    return str.substr(0, nullIndex);
}
exports.cpp2js = cpp2js;
function num2hex(val, uppercase = false) {
    if (val == null)
        return "undefined";
    let ret = val.toString(16);
    if (uppercase)
        ret = ret.toUpperCase();
    if (ret.length % 2 !== 0)
        ret = "0" + ret;
    return "0x" + ret;
}
exports.num2hex = num2hex;
function stringify(arg, space = 4) {
    return JSON.stringify(arg, null, space);
}
exports.stringify = stringify;
function buffer2hex(buffer, uppercase = false) {
    if (buffer.length === 0)
        return "(empty)";
    let ret = `0x${buffer.toString("hex")}`;
    if (uppercase)
        ret = ret.toUpperCase();
    return ret;
}
exports.buffer2hex = buffer2hex;
function isPrintableASCII(text) {
    return /^[\u0020-\u007e]*$/.test(text);
}
exports.isPrintableASCII = isPrintableASCII;
//# sourceMappingURL=strings.js.map