"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequence = exports.toggle = void 0;
var utils_1 = require("./utils");
function toggle(onState, offState, eventType) {
    var _a, _b, _c;
    return _a = {},
        _a[onState] = {
            on: (_b = {}, _b[eventType] = offState, _b)
        },
        _a[offState] = {
            on: (_c = {}, _c[eventType] = onState, _c)
        },
        _a;
}
exports.toggle = toggle;
var defaultSequencePatternOptions = {
    nextEvent: 'NEXT',
    prevEvent: 'PREV'
};
function sequence(items, options) {
    var resolvedOptions = __assign(__assign({}, defaultSequencePatternOptions), options);
    var states = {};
    var nextEventObject = resolvedOptions.nextEvent === undefined
        ? undefined
        : utils_1.toEventObject(resolvedOptions.nextEvent);
    var prevEventObject = resolvedOptions.prevEvent === undefined
        ? undefined
        : utils_1.toEventObject(resolvedOptions.prevEvent);
    items.forEach(function (item, i) {
        var state = {
            on: {}
        };
        if (i + 1 === items.length) {
            state.type = 'final';
        }
        if (nextEventObject && i + 1 < items.length) {
            state.on[nextEventObject.type] = items[i + 1];
        }
        if (prevEventObject && i > 0) {
            state.on[prevEventObject.type] = items[i - 1];
        }
        states[item] = state;
    });
    return {
        initial: items[0],
        states: states
    };
}
exports.sequence = sequence;
