"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.toObserver = exports.toInvokeSource = exports.evaluateGuard = exports.reportUnhandledExceptionOnInvocation = exports.normalizeTarget = exports.toTransitionConfigArray = exports.toSCXMLEvent = exports.toEventObject = exports.uniqueId = exports.isActor = exports.isMachine = exports.symbolObservable = exports.isObservable = exports.toGuard = exports.isString = exports.isFunction = exports.isArray = exports.warn = exports.updateContext = exports.updateHistoryValue = exports.updateHistoryStates = exports.partition = exports.isPromiseLike = exports.isBuiltInEvent = exports.mapContext = exports.toArray = exports.toArrayStrict = exports.flatten = exports.pathsToStateValue = exports.toStatePaths = exports.nestedPath = exports.path = exports.mapFilterValues = exports.mapValues = exports.pathToStateValue = exports.toStateValue = exports.isStateLike = exports.toStatePath = exports.getActionType = exports.getEventType = exports.matchesState = exports.keys = void 0;
var constants_1 = require("./constants");
var environment_1 = require("./environment");
function keys(value) {
    return Object.keys(value);
}
exports.keys = keys;
function matchesState(parentStateId, childStateId, delimiter) {
    if (delimiter === void 0) { delimiter = constants_1.STATE_DELIMITER; }
    var parentStateValue = toStateValue(parentStateId, delimiter);
    var childStateValue = toStateValue(childStateId, delimiter);
    if (isString(childStateValue)) {
        if (isString(parentStateValue)) {
            return childStateValue === parentStateValue;
        }
        // Parent more specific than child
        return false;
    }
    if (isString(parentStateValue)) {
        return parentStateValue in childStateValue;
    }
    return keys(parentStateValue).every(function (key) {
        if (!(key in childStateValue)) {
            return false;
        }
        return matchesState(parentStateValue[key], childStateValue[key]);
    });
}
exports.matchesState = matchesState;
function getEventType(event) {
    try {
        return isString(event) || typeof event === 'number'
            ? "" + event
            : event.type;
    }
    catch (e) {
        throw new Error('Events must be strings or objects with a string event.type property.');
    }
}
exports.getEventType = getEventType;
function getActionType(action) {
    try {
        return isString(action) || typeof action === 'number'
            ? "" + action
            : isFunction(action)
                ? action.name
                : action.type;
    }
    catch (e) {
        throw new Error('Actions must be strings or objects with a string action.type property.');
    }
}
exports.getActionType = getActionType;
function toStatePath(stateId, delimiter) {
    try {
        if (isArray(stateId)) {
            return stateId;
        }
        return stateId.toString().split(delimiter);
    }
    catch (e) {
        throw new Error("'" + stateId + "' is not a valid state path.");
    }
}
exports.toStatePath = toStatePath;
function isStateLike(state) {
    return (typeof state === 'object' &&
        'value' in state &&
        'context' in state &&
        'event' in state &&
        '_event' in state);
}
exports.isStateLike = isStateLike;
function toStateValue(stateValue, delimiter) {
    if (isStateLike(stateValue)) {
        return stateValue.value;
    }
    if (isArray(stateValue)) {
        return pathToStateValue(stateValue);
    }
    if (typeof stateValue !== 'string') {
        return stateValue;
    }
    var statePath = toStatePath(stateValue, delimiter);
    return pathToStateValue(statePath);
}
exports.toStateValue = toStateValue;
function pathToStateValue(statePath) {
    if (statePath.length === 1) {
        return statePath[0];
    }
    var value = {};
    var marker = value;
    for (var i = 0; i < statePath.length - 1; i++) {
        if (i === statePath.length - 2) {
            marker[statePath[i]] = statePath[i + 1];
        }
        else {
            marker[statePath[i]] = {};
            marker = marker[statePath[i]];
        }
    }
    return value;
}
exports.pathToStateValue = pathToStateValue;
function mapValues(collection, iteratee) {
    var result = {};
    var collectionKeys = keys(collection);
    for (var i = 0; i < collectionKeys.length; i++) {
        var key = collectionKeys[i];
        result[key] = iteratee(collection[key], key, collection, i);
    }
    return result;
}
exports.mapValues = mapValues;
function mapFilterValues(collection, iteratee, predicate) {
    var e_1, _a;
    var result = {};
    try {
        for (var _b = __values(keys(collection)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            var item = collection[key];
            if (!predicate(item)) {
                continue;
            }
            result[key] = iteratee(item, key, collection);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return result;
}
exports.mapFilterValues = mapFilterValues;
/**
 * Retrieves a value at the given path.
 * @param props The deep path to the prop of the desired value
 */
var path = function (props) { return function (object) {
    var e_2, _a;
    var result = object;
    try {
        for (var props_1 = __values(props), props_1_1 = props_1.next(); !props_1_1.done; props_1_1 = props_1.next()) {
            var prop = props_1_1.value;
            result = result[prop];
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (props_1_1 && !props_1_1.done && (_a = props_1.return)) _a.call(props_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return result;
}; };
exports.path = path;
/**
 * Retrieves a value at the given path via the nested accessor prop.
 * @param props The deep path to the prop of the desired value
 */
function nestedPath(props, accessorProp) {
    return function (object) {
        var e_3, _a;
        var result = object;
        try {
            for (var props_2 = __values(props), props_2_1 = props_2.next(); !props_2_1.done; props_2_1 = props_2.next()) {
                var prop = props_2_1.value;
                result = result[accessorProp][prop];
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (props_2_1 && !props_2_1.done && (_a = props_2.return)) _a.call(props_2);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return result;
    };
}
exports.nestedPath = nestedPath;
function toStatePaths(stateValue) {
    if (!stateValue) {
        return [[]];
    }
    if (isString(stateValue)) {
        return [[stateValue]];
    }
    var result = flatten(keys(stateValue).map(function (key) {
        var subStateValue = stateValue[key];
        if (typeof subStateValue !== 'string' &&
            (!subStateValue || !Object.keys(subStateValue).length)) {
            return [[key]];
        }
        return toStatePaths(stateValue[key]).map(function (subPath) {
            return [key].concat(subPath);
        });
    }));
    return result;
}
exports.toStatePaths = toStatePaths;
function pathsToStateValue(paths) {
    var e_4, _a;
    var result = {};
    if (paths && paths.length === 1 && paths[0].length === 1) {
        return paths[0][0];
    }
    try {
        for (var paths_1 = __values(paths), paths_1_1 = paths_1.next(); !paths_1_1.done; paths_1_1 = paths_1.next()) {
            var currentPath = paths_1_1.value;
            var marker = result;
            // tslint:disable-next-line:prefer-for-of
            for (var i = 0; i < currentPath.length; i++) {
                var subPath = currentPath[i];
                if (i === currentPath.length - 2) {
                    marker[subPath] = currentPath[i + 1];
                    break;
                }
                marker[subPath] = marker[subPath] || {};
                marker = marker[subPath];
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (paths_1_1 && !paths_1_1.done && (_a = paths_1.return)) _a.call(paths_1);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return result;
}
exports.pathsToStateValue = pathsToStateValue;
function flatten(array) {
    var _a;
    return (_a = []).concat.apply(_a, __spread(array));
}
exports.flatten = flatten;
function toArrayStrict(value) {
    if (isArray(value)) {
        return value;
    }
    return [value];
}
exports.toArrayStrict = toArrayStrict;
function toArray(value) {
    if (value === undefined) {
        return [];
    }
    return toArrayStrict(value);
}
exports.toArray = toArray;
function mapContext(mapper, context, _event) {
    var e_5, _a;
    if (isFunction(mapper)) {
        return mapper(context, _event.data);
    }
    var result = {};
    try {
        for (var _b = __values(Object.keys(mapper)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            var subMapper = mapper[key];
            if (isFunction(subMapper)) {
                result[key] = subMapper(context, _event.data);
            }
            else {
                result[key] = subMapper;
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_5) throw e_5.error; }
    }
    return result;
}
exports.mapContext = mapContext;
function isBuiltInEvent(eventType) {
    return /^(done|error)\./.test(eventType);
}
exports.isBuiltInEvent = isBuiltInEvent;
function isPromiseLike(value) {
    if (value instanceof Promise) {
        return true;
    }
    // Check if shape matches the Promise/A+ specification for a "thenable".
    if (value !== null &&
        (isFunction(value) || typeof value === 'object') &&
        isFunction(value.then)) {
        return true;
    }
    return false;
}
exports.isPromiseLike = isPromiseLike;
function partition(items, predicate) {
    var e_6, _a;
    var _b = __read([[], []], 2), truthy = _b[0], falsy = _b[1];
    try {
        for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
            var item = items_1_1.value;
            if (predicate(item)) {
                truthy.push(item);
            }
            else {
                falsy.push(item);
            }
        }
    }
    catch (e_6_1) { e_6 = { error: e_6_1 }; }
    finally {
        try {
            if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
        }
        finally { if (e_6) throw e_6.error; }
    }
    return [truthy, falsy];
}
exports.partition = partition;
function updateHistoryStates(hist, stateValue) {
    return mapValues(hist.states, function (subHist, key) {
        if (!subHist) {
            return undefined;
        }
        var subStateValue = (isString(stateValue) ? undefined : stateValue[key]) ||
            (subHist ? subHist.current : undefined);
        if (!subStateValue) {
            return undefined;
        }
        return {
            current: subStateValue,
            states: updateHistoryStates(subHist, subStateValue)
        };
    });
}
exports.updateHistoryStates = updateHistoryStates;
function updateHistoryValue(hist, stateValue) {
    return {
        current: stateValue,
        states: updateHistoryStates(hist, stateValue)
    };
}
exports.updateHistoryValue = updateHistoryValue;
function updateContext(context, _event, assignActions, state) {
    if (!environment_1.IS_PRODUCTION) {
        warn(!!context, 'Attempting to update undefined context');
    }
    var updatedContext = context
        ? assignActions.reduce(function (acc, assignAction) {
            var e_7, _a;
            var assignment = assignAction.assignment;
            var meta = {
                state: state,
                action: assignAction,
                _event: _event
            };
            var partialUpdate = {};
            if (isFunction(assignment)) {
                partialUpdate = assignment(acc, _event.data, meta);
            }
            else {
                try {
                    for (var _b = __values(keys(assignment)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var key = _c.value;
                        var propAssignment = assignment[key];
                        partialUpdate[key] = isFunction(propAssignment)
                            ? propAssignment(acc, _event.data, meta)
                            : propAssignment;
                    }
                }
                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_7) throw e_7.error; }
                }
            }
            return Object.assign({}, acc, partialUpdate);
        }, context)
        : context;
    return updatedContext;
}
exports.updateContext = updateContext;
// tslint:disable-next-line:no-empty
var warn = function () { };
exports.warn = warn;
if (!environment_1.IS_PRODUCTION) {
    exports.warn = warn = function (condition, message) {
        var error = condition instanceof Error ? condition : undefined;
        if (!error && condition) {
            return;
        }
        if (console !== undefined) {
            var args = ["Warning: " + message];
            if (error) {
                args.push(error);
            }
            // tslint:disable-next-line:no-console
            console.warn.apply(console, args);
        }
    };
}
function isArray(value) {
    return Array.isArray(value);
}
exports.isArray = isArray;
// tslint:disable-next-line:ban-types
function isFunction(value) {
    return typeof value === 'function';
}
exports.isFunction = isFunction;
function isString(value) {
    return typeof value === 'string';
}
exports.isString = isString;
// export function memoizedGetter<T, TP extends { prototype: object }>(
//   o: TP,
//   property: string,
//   getter: () => T
// ): void {
//   Object.defineProperty(o.prototype, property, {
//     get: getter,
//     enumerable: false,
//     configurable: false
//   });
// }
function toGuard(condition, guardMap) {
    if (!condition) {
        return undefined;
    }
    if (isString(condition)) {
        return {
            type: constants_1.DEFAULT_GUARD_TYPE,
            name: condition,
            predicate: guardMap ? guardMap[condition] : undefined
        };
    }
    if (isFunction(condition)) {
        return {
            type: constants_1.DEFAULT_GUARD_TYPE,
            name: condition.name,
            predicate: condition
        };
    }
    return condition;
}
exports.toGuard = toGuard;
function isObservable(value) {
    try {
        return 'subscribe' in value && isFunction(value.subscribe);
    }
    catch (e) {
        return false;
    }
}
exports.isObservable = isObservable;
exports.symbolObservable = (function () {
    return (typeof Symbol === 'function' && Symbol.observable) || '@@observable';
})();
function isMachine(value) {
    try {
        return '__xstatenode' in value;
    }
    catch (e) {
        return false;
    }
}
exports.isMachine = isMachine;
function isActor(value) {
    return !!value && typeof value.send === 'function';
}
exports.isActor = isActor;
exports.uniqueId = (function () {
    var currentId = 0;
    return function () {
        currentId++;
        return currentId.toString(16);
    };
})();
function toEventObject(event, payload
// id?: TEvent['type']
) {
    if (isString(event) || typeof event === 'number') {
        return __assign({ type: event }, payload);
    }
    return event;
}
exports.toEventObject = toEventObject;
function toSCXMLEvent(event, scxmlEvent) {
    if (!isString(event) && '$$type' in event && event.$$type === 'scxml') {
        return event;
    }
    var eventObject = toEventObject(event);
    return __assign({ name: eventObject.type, data: eventObject, $$type: 'scxml', type: 'external' }, scxmlEvent);
}
exports.toSCXMLEvent = toSCXMLEvent;
function toTransitionConfigArray(event, configLike) {
    var transitions = toArrayStrict(configLike).map(function (transitionLike) {
        if (typeof transitionLike === 'undefined' ||
            typeof transitionLike === 'string' ||
            isMachine(transitionLike)) {
            return { target: transitionLike, event: event };
        }
        return __assign(__assign({}, transitionLike), { event: event });
    });
    return transitions;
}
exports.toTransitionConfigArray = toTransitionConfigArray;
function normalizeTarget(target) {
    if (target === undefined || target === constants_1.TARGETLESS_KEY) {
        return undefined;
    }
    return toArray(target);
}
exports.normalizeTarget = normalizeTarget;
function reportUnhandledExceptionOnInvocation(originalError, currentError, id) {
    if (!environment_1.IS_PRODUCTION) {
        var originalStackTrace = originalError.stack
            ? " Stacktrace was '" + originalError.stack + "'"
            : '';
        if (originalError === currentError) {
            // tslint:disable-next-line:no-console
            console.error("Missing onError handler for invocation '" + id + "', error was '" + originalError + "'." + originalStackTrace);
        }
        else {
            var stackTrace = currentError.stack
                ? " Stacktrace was '" + currentError.stack + "'"
                : '';
            // tslint:disable-next-line:no-console
            console.error("Missing onError handler and/or unhandled exception/promise rejection for invocation '" + id + "'. " +
                ("Original error: '" + originalError + "'. " + originalStackTrace + " Current error is '" + currentError + "'." + stackTrace));
        }
    }
}
exports.reportUnhandledExceptionOnInvocation = reportUnhandledExceptionOnInvocation;
function evaluateGuard(machine, guard, context, _event, state) {
    var guards = machine.options.guards;
    var guardMeta = {
        state: state,
        cond: guard,
        _event: _event
    };
    // TODO: do not hardcode!
    if (guard.type === constants_1.DEFAULT_GUARD_TYPE) {
        return guard.predicate(context, _event.data, guardMeta);
    }
    var condFn = guards[guard.type];
    if (!condFn) {
        throw new Error("Guard '" + guard.type + "' is not implemented on machine '" + machine.id + "'.");
    }
    return condFn(context, _event.data, guardMeta);
}
exports.evaluateGuard = evaluateGuard;
function toInvokeSource(src) {
    if (typeof src === 'string') {
        return { type: src };
    }
    return src;
}
exports.toInvokeSource = toInvokeSource;
function toObserver(nextHandler, errorHandler, completionHandler) {
    if (typeof nextHandler === 'object') {
        return nextHandler;
    }
    var noop = function () { return void 0; };
    return {
        next: nextHandler,
        error: errorHandler || noop,
        complete: completionHandler || noop
    };
}
exports.toObserver = toObserver;
