"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClockCCGet = exports.ClockCCReport = exports.ClockCCSet = exports.ClockCC = exports.ClockCCAPI = exports.Weekday = exports.ClockCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const strings_1 = require("alcalzone-shared/strings");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var ClockCommand;
(function (ClockCommand) {
    ClockCommand[ClockCommand["Set"] = 4] = "Set";
    ClockCommand[ClockCommand["Get"] = 5] = "Get";
    ClockCommand[ClockCommand["Report"] = 6] = "Report";
})(ClockCommand = exports.ClockCommand || (exports.ClockCommand = {}));
/**
 * @publicAPI
 */
var Weekday;
(function (Weekday) {
    Weekday[Weekday["Unknown"] = 0] = "Unknown";
    Weekday[Weekday["Monday"] = 1] = "Monday";
    Weekday[Weekday["Tuesday"] = 2] = "Tuesday";
    Weekday[Weekday["Wednesday"] = 3] = "Wednesday";
    Weekday[Weekday["Thursday"] = 4] = "Thursday";
    Weekday[Weekday["Friday"] = 5] = "Friday";
    Weekday[Weekday["Saturday"] = 6] = "Saturday";
    Weekday[Weekday["Sunday"] = 7] = "Sunday";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
// @noSetValueAPI - This CC has no simple value to set
let ClockCCAPI = class ClockCCAPI extends API_1.CCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case ClockCommand.Get:
                return this.isSinglecast();
            case ClockCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ClockCommand, ClockCommand.Get);
        const cc = new ClockCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["weekday", "hour", "minute"]);
        }
    }
    async set(hour, minute, weekday) {
        this.assertSupportsCommand(ClockCommand, ClockCommand.Set);
        const cc = new ClockCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            hour,
            minute,
            weekday: weekday !== null && weekday !== void 0 ? weekday : Weekday.Unknown,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
ClockCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Clock)
], ClockCCAPI);
exports.ClockCCAPI = ClockCCAPI;
let ClockCC = class ClockCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Clock.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        this.driver.controllerLog.logNode(node.id, {
            message: "requesting current clock setting...",
            direction: "outbound",
        });
        const response = await api.get();
        if (response) {
            const logMessage = `received current clock setting: ${response.weekday !== Weekday.Unknown
                ? Weekday[response.weekday] + ", "
                : ""}${response.hour < 10 ? "0" : ""}${response.hour}:${response.minute < 10 ? "0" : ""}${response.minute}`;
            this.driver.controllerLog.logNode(node.id, {
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ClockCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Clock),
    CommandClass_1.implementedVersion(1)
], ClockCC);
exports.ClockCC = ClockCC;
let ClockCCSet = class ClockCCSet extends ClockCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.weekday = options.weekday;
            this.hour = options.hour;
            this.minute = options.minute;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            ((this.weekday & 0b111) << 5) | (this.hour & 0b11111),
            this.minute,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "clock setting": `${shared_1.getEnumMemberName(Weekday, this.weekday)}, ${strings_1.padStart(this.hour.toString(), 2, "0")}:${strings_1.padStart(this.minute.toString(), 2, "0")}`,
            },
        };
    }
};
ClockCCSet = __decorate([
    CommandClass_1.CCCommand(ClockCommand.Set)
], ClockCCSet);
exports.ClockCCSet = ClockCCSet;
let ClockCCReport = class ClockCCReport extends ClockCC {
    // @noCCValues Setting the clock is done automatically and needs no values to be stored
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this.weekday = this.payload[0] >>> 5;
        this.hour = this.payload[0] & 0b11111;
        this.minute = this.payload[1];
        core_1.validatePayload(this.weekday <= Weekday.Sunday, this.hour <= 23, this.minute <= 59);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "clock setting": `${shared_1.getEnumMemberName(Weekday, this.weekday)}, ${strings_1.padStart(this.hour.toString(), 2, "0")}:${strings_1.padStart(this.minute.toString(), 2, "0")}`,
            },
        };
    }
};
ClockCCReport = __decorate([
    CommandClass_1.CCCommand(ClockCommand.Report)
], ClockCCReport);
exports.ClockCCReport = ClockCCReport;
let ClockCCGet = class ClockCCGet extends ClockCC {
};
ClockCCGet = __decorate([
    CommandClass_1.CCCommand(ClockCommand.Get),
    CommandClass_1.expectedCCResponse(ClockCCReport)
], ClockCCGet);
exports.ClockCCGet = ClockCCGet;

//# sourceMappingURL=ClockCC.js.map
