import type { Driver } from "../driver/Driver";
import { CommandClass, CommandClassOptions } from "./CommandClass";
/** Defines the static side of an encapsulating command class */
export interface EncapsulatingCommandClassStatic {
    new (driver: Driver, options: CommandClassOptions): EncapsulatingCommandClass;
    encapsulate(driver: Driver, cc: CommandClass): EncapsulatingCommandClass;
}
export declare type EncapsulatedCommandClass = CommandClass & {
    encapsulatingCC: EncapsulatingCommandClass;
};
export declare type EncapsulatingCommandClass = CommandClass & {
    constructor: EncapsulatingCommandClassStatic;
    encapsulated: EncapsulatedCommandClass;
};
/**
 * Tests if a given CC statically implements the EncapsulatingCommandClassStatic interface
 * @param cc The command class instance to test
 */
export declare function isEncapsulatingCommandClass(cc: any): cc is CommandClass & EncapsulatingCommandClass;
/** Defines the static side of an encapsulating command class */
export interface MultiEncapsulatingCommandClassStatic {
    new (driver: Driver, options: CommandClassOptions): MultiEncapsulatingCommandClass;
    requiresEncapsulation(cc: CommandClass): boolean;
    encapsulate(driver: Driver, CCs: CommandClass[]): MultiEncapsulatingCommandClass;
}
export interface MultiEncapsulatingCommandClass {
    constructor: MultiEncapsulatingCommandClassStatic;
    encapsulated: EncapsulatedCommandClass[];
}
/**
 * Tests if a given CC statically implements the EncapsulatingCommandClassStatic interface
 * @param cc The command class instance to test
 */
export declare function isMultiEncapsulatingCommandClass(cc: any): cc is CommandClass & MultiEncapsulatingCommandClass;
