/// <reference types="node" />
import type { MeterScale } from "@zwave-js/config";
import type { MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import { Maybe, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum MeterCommand {
    Get = 1,
    Report = 2,
    SupportedGet = 3,
    SupportedReport = 4,
    Reset = 5
}
/**
 * @publicAPI
 */
export declare enum RateType {
    Unspecified = 0,
    Consumed = 1,
    Produced = 2
}
/**
 * @publicAPI
 */
export declare type MeterMetadata = ValueMetadata & {
    ccSpecific: {
        meterType: number;
        rateType?: RateType;
        scale?: number;
    };
};
export declare function getTypeValueId(endpoint: number): ValueID;
export declare function getSupportsResetValueId(endpoint: number): ValueID;
export declare function getSupportedScalesValueId(endpoint: number): ValueID;
export declare function getSupportedRateTypesValueId(endpoint: number): ValueID;
export declare function getResetValueId(endpoint: number, type?: number): ValueID;
export declare class MeterCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: MeterCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(options?: MeterCCGetOptions): Promise<Pick<MeterCCReport, "type" | "value" | "scale" | "previousValue" | "rateType" | "deltaTime"> | undefined>;
    getAll(): Promise<Pick<MeterCCReport, "type" | "value" | "scale" | "previousValue" | "rateType" | "deltaTime">[]>;
    getSupported(): Promise<Pick<MeterCCSupportedReport, "type" | "supportsReset" | "supportedScales" | "supportedRateTypes"> | undefined>;
    reset(options: MeterCCResetOptions): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
}
export declare class MeterCC extends CommandClass {
    ccCommand: MeterCommand;
    interview(complete?: boolean): Promise<void>;
    translatePropertyKey(property: string | number, propertyKey: string | number): string | undefined;
}
export declare class MeterCCReport extends MeterCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    private _type;
    get type(): number;
    private _scale;
    get scale(): MeterScale;
    private _value;
    get value(): number;
    private _previousValue;
    get previousValue(): number | undefined;
    private _rateType;
    get rateType(): RateType;
    private _deltaTime;
    get deltaTime(): Maybe<number>;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MeterCCGetOptions {
    scale?: number;
    rateType?: RateType;
}
export declare class MeterCCGet extends MeterCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (MeterCCGetOptions & CCCommandOptions));
    rateType: RateType | undefined;
    scale: number | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MeterCCSupportedReport extends MeterCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _type;
    get type(): number;
    private _supportsReset;
    get supportsReset(): boolean;
    private _supportedScales;
    get supportedScales(): readonly number[];
    private _supportedRateTypes;
    get supportedRateTypes(): readonly RateType[];
    persistValues(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MeterCCSupportedGet extends MeterCC {
}
declare type MeterCCResetOptions = {
    type?: undefined;
    targetValue?: undefined;
} | {
    type: number;
    targetValue: number;
};
export declare class MeterCCReset extends MeterCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (MeterCCResetOptions & CCCommandOptions));
    type: number | undefined;
    targetValue: number | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
