"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiCommandCCCommandEncapsulation = exports.MultiCommandCC = exports.MultiCommandCCAPI = exports.MultiCommandCommand = void 0;
const core_1 = require("@zwave-js/core");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var MultiCommandCommand;
(function (MultiCommandCommand) {
    MultiCommandCommand[MultiCommandCommand["CommandEncapsulation"] = 1] = "CommandEncapsulation";
})(MultiCommandCommand = exports.MultiCommandCommand || (exports.MultiCommandCommand = {}));
// TODO: Handle this command when received
// @noSetValueAPI This CC has no set-type commands
// @noInterview This CC only has a single encapsulation command
let MultiCommandCCAPI = class MultiCommandCCAPI extends API_1.CCAPI {
    supportsCommand(_cmd) {
        // switch (cmd) {
        // 	case MultiCommandCommand.CommandEncapsulation:
        return true; // This is mandatory
        // }
        // return super.supportsCommand(cmd);
    }
    async send(commands) {
        this.assertSupportsCommand(MultiCommandCommand, MultiCommandCommand.CommandEncapsulation);
        // FIXME: This should not be on the API but rather on the driver level
        const cc = new MultiCommandCCCommandEncapsulation(this.driver, {
            nodeId: this.endpoint.nodeId,
            encapsulated: commands,
        });
        cc.endpointIndex = this.endpoint.index;
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
MultiCommandCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Multi Command"])
], MultiCommandCCAPI);
exports.MultiCommandCCAPI = MultiCommandCCAPI;
let MultiCommandCC = class MultiCommandCC extends CommandClass_1.CommandClass {
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc) {
        return (cc.endpointIndex !== 0 &&
            !(cc instanceof MultiCommandCCCommandEncapsulation));
    }
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver, CCs) {
        return new MultiCommandCCCommandEncapsulation(driver, {
            nodeId: CCs[0].nodeId,
            encapsulated: CCs,
            // MultiCommand CC is wrapped inside Supervision CC, so the supervision status must be preserved
            supervised: CCs.some((cc) => cc.supervised),
        });
    }
};
MultiCommandCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Multi Command"]),
    CommandClass_1.implementedVersion(1)
], MultiCommandCC);
exports.MultiCommandCC = MultiCommandCC;
let MultiCommandCCCommandEncapsulation = 
// TODO: This probably expects multiple commands in return
class MultiCommandCCCommandEncapsulation extends MultiCommandCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            const numCommands = this.payload[0];
            this.encapsulated = [];
            let offset = 1;
            for (let i = 0; i < numCommands; i++) {
                core_1.validatePayload(this.payload.length >= offset + 1);
                const cmdLength = this.payload[offset];
                core_1.validatePayload(this.payload.length >= offset + 1 + cmdLength);
                this.encapsulated.push(CommandClass_1.CommandClass.from(this.driver, {
                    data: this.payload.slice(offset + 1, offset + 1 + cmdLength),
                    fromEncapsulation: true,
                    encapCC: this,
                }));
                offset += 1 + cmdLength;
            }
        }
        else {
            this.encapsulated = options.encapsulated;
            for (const cc of options.encapsulated) {
                cc.encapsulatingCC = this;
            }
        }
    }
    serialize() {
        const buffers = [];
        buffers.push(Buffer.from([this.encapsulated.length]));
        for (const cmd of this.encapsulated) {
            const cmdBuffer = cmd.serialize();
            buffers.push(Buffer.from([cmdBuffer.length]));
            buffers.push(cmdBuffer);
        }
        this.payload = Buffer.concat(buffers);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            // Hide the default payload line
            message: undefined,
        };
    }
};
MultiCommandCCCommandEncapsulation = __decorate([
    CommandClass_1.CCCommand(MultiCommandCommand.CommandEncapsulation)
    // TODO: This probably expects multiple commands in return
], MultiCommandCCCommandEncapsulation);
exports.MultiCommandCCCommandEncapsulation = MultiCommandCCCommandEncapsulation;

//# sourceMappingURL=MultiCommandCC.js.map
