"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultilevelSensorCCGetSupportedScale = exports.MultilevelSensorCCSupportedScaleReport = exports.MultilevelSensorCCGetSupportedSensor = exports.MultilevelSensorCCSupportedSensorReport = exports.MultilevelSensorCCGet = exports.MultilevelSensorCCReport = exports.MultilevelSensorCC = exports.MultilevelSensorCCAPI = exports.MultilevelSensorCommand = void 0;
const config_1 = require("@zwave-js/config");
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var MultilevelSensorCommand;
(function (MultilevelSensorCommand) {
    MultilevelSensorCommand[MultilevelSensorCommand["GetSupportedSensor"] = 1] = "GetSupportedSensor";
    MultilevelSensorCommand[MultilevelSensorCommand["SupportedSensorReport"] = 2] = "SupportedSensorReport";
    MultilevelSensorCommand[MultilevelSensorCommand["GetSupportedScale"] = 3] = "GetSupportedScale";
    MultilevelSensorCommand[MultilevelSensorCommand["Get"] = 4] = "Get";
    MultilevelSensorCommand[MultilevelSensorCommand["Report"] = 5] = "Report";
    MultilevelSensorCommand[MultilevelSensorCommand["SupportedScaleReport"] = 6] = "SupportedScaleReport";
})(MultilevelSensorCommand = exports.MultilevelSensorCommand || (exports.MultilevelSensorCommand = {}));
// @noSetValueAPI This CC is read-only
let MultilevelSensorCCAPI = class MultilevelSensorCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            var _b, _c;
            // Look up the necessary information
            const valueId = {
                commandClass: core_1.CommandClasses["Multilevel Sensor"],
                endpoint: this.endpoint.index,
                property,
            };
            const ccSpecific = (_c = (_b = this.endpoint
                .getNodeUnsafe()) === null || _b === void 0 ? void 0 : _b.valueDB.getMetadata(valueId)) === null || _c === void 0 ? void 0 : _c.ccSpecific;
            if (!ccSpecific) {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            const { sensorType, scale } = ccSpecific;
            return this.get(sensorType, scale);
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case MultilevelSensorCommand.Get:
            case MultilevelSensorCommand.Report:
                return true; // This is mandatory
            case MultilevelSensorCommand.GetSupportedSensor:
            case MultilevelSensorCommand.GetSupportedScale:
                return this.version >= 5;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get(sensorType, scale) {
        this.assertSupportsCommand(MultilevelSensorCommand, MultilevelSensorCommand.Get);
        const cc = new MultilevelSensorCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sensorType,
            scale,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (!response)
            return;
        if (sensorType === undefined) {
            // Overload #1: return the full response
            return {
                type: response.type,
                value: response.value,
                scale: response.scale,
            };
        }
        else {
            // Overload #2: return only the value
            return response.value;
        }
    }
    async getSupportedSensorTypes() {
        this.assertSupportsCommand(MultilevelSensorCommand, MultilevelSensorCommand.GetSupportedSensor);
        const cc = new MultilevelSensorCCGetSupportedSensor(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedSensorTypes;
    }
    async getSupportedScales(sensorType) {
        this.assertSupportsCommand(MultilevelSensorCommand, MultilevelSensorCommand.GetSupportedScale);
        const cc = new MultilevelSensorCCGetSupportedScale(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sensorType,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.sensorSupportedScales;
    }
    async sendReport(sensorType, scale, value) {
        this.assertSupportsCommand(MultilevelSensorCommand, MultilevelSensorCommand.Report);
        const cc = new MultilevelSensorCCReport(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            type: sensorType,
            scale,
            value,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.POLL_VALUE;
MultilevelSensorCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Multilevel Sensor"])
], MultilevelSensorCCAPI);
exports.MultilevelSensorCCAPI = MultilevelSensorCCAPI;
let MultilevelSensorCC = class MultilevelSensorCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Multilevel Sensor"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (this.version <= 4) {
            // Sensors up to V4 only support a single value
            // This needs to be requested every time
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying current sensor reading...",
                direction: "outbound",
            });
            const mlsResponse = await api.get();
            if (mlsResponse) {
                const sensorScale = this.driver.configManager.lookupSensorScale(mlsResponse.type, mlsResponse.scale.key);
                const logMessage = `received current sensor reading:
sensor type: ${this.driver.configManager.getSensorTypeName(mlsResponse.type)}
value:       ${mlsResponse.value} ${sensorScale.unit || ""}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        else {
            // V5+
            // If we haven't yet, query the supported sensor types
            let sensorTypes;
            if (complete) {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "retrieving supported sensor types...",
                    direction: "outbound",
                });
                sensorTypes = await api.getSupportedSensorTypes();
                if (sensorTypes) {
                    const logMessage = "received supported sensor types:\n" +
                        sensorTypes
                            .map((t) => this.driver.configManager.getSensorTypeName(t))
                            .map((name) => `· ${name}`)
                            .join("\n");
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
                else {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: "Querying supported sensor types timed out, skipping interview...",
                        level: "warn",
                    });
                    return;
                }
            }
            else {
                sensorTypes =
                    this.getValueDB().getValue({
                        commandClass: this.ccId,
                        property: "supportedSensorTypes",
                        endpoint: this.endpointIndex,
                    }) || [];
            }
            for (const type of sensorTypes) {
                // If we haven't yet, query the supported scales for each sensor
                let sensorScales;
                if (complete) {
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: `querying supported scales for ${this.driver.configManager.getSensorTypeName(type)} sensor`,
                        direction: "outbound",
                    });
                    sensorScales = await api.getSupportedScales(type);
                    if (sensorScales) {
                        const logMessage = "received supported scales:\n" +
                            sensorScales
                                .map((s) => this.driver.configManager.lookupSensorScale(type, s).label)
                                .map((name) => `· ${name}`)
                                .join("\n");
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: logMessage,
                            direction: "inbound",
                        });
                    }
                    else {
                        this.driver.controllerLog.logNode(node.id, {
                            endpoint: this.endpointIndex,
                            message: "Querying supported scales timed out, skipping interview...",
                            level: "warn",
                        });
                        return;
                    }
                }
                else {
                    sensorScales =
                        this.getValueDB().getValue({
                            commandClass: this.ccId,
                            endpoint: this.endpointIndex,
                            property: "supportedScales",
                            propertyKey: type,
                        }) || [];
                }
                // Always query the current sensor reading
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: `querying ${this.driver.configManager.getSensorTypeName(type)} sensor reading...`,
                    direction: "outbound",
                });
                // TODO: Add some way to select the scale. For now use the first available one
                const value = await api.get(type, sensorScales[0]);
                if (value != undefined) {
                    const scale = this.driver.configManager.lookupSensorScale(type, sensorScales[0]);
                    const logMessage = `received current ${this.driver.configManager.getSensorTypeName(type)} sensor reading: ${value} ${scale.unit || ""}`;
                    this.driver.controllerLog.logNode(node.id, {
                        endpoint: this.endpointIndex,
                        message: logMessage,
                        direction: "inbound",
                    });
                }
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
    translatePropertyKey(property, propertyKey) {
        // TODO: check this
        if (property === "values" && typeof propertyKey === "number") {
            const type = this.driver.configManager.lookupSensorType(propertyKey);
            if (type)
                return type.label;
        }
        return super.translatePropertyKey(property, propertyKey);
    }
};
MultilevelSensorCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Multilevel Sensor"]),
    CommandClass_1.implementedVersion(11)
], MultilevelSensorCC);
exports.MultilevelSensorCC = MultilevelSensorCC;
let MultilevelSensorCCReport = class MultilevelSensorCCReport extends MultilevelSensorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            this.type = this.payload[0];
            // parseFloatWithScale does its own validation
            const { value, scale } = core_1.parseFloatWithScale(this.payload.slice(1));
            this.value = value;
            this.scale = this.driver.configManager.lookupSensorScale(this.type, scale);
            this.persistValues();
        }
        else {
            this.type = options.type;
            this.value = options.value;
            this.scale =
                options.scale instanceof config_1.Scale
                    ? options.scale
                    : this.driver.configManager.lookupSensorScale(this.type, options.scale);
        }
    }
    persistValues() {
        const typeName = this.driver.configManager.getSensorTypeName(this.type);
        const valueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: typeName,
        };
        this.getValueDB().setMetadata(valueId, {
            ...core_1.ValueMetadata.ReadOnlyNumber,
            unit: this.scale.unit,
            label: typeName,
            ccSpecific: {
                sensorType: this.type,
                scale: this.scale.key,
            },
        });
        this.getValueDB().setValue(valueId, this.value);
        return true;
    }
    serialize() {
        this.payload = Buffer.concat([
            Buffer.from([this.type]),
            core_1.encodeFloatWithScale(this.value, this.scale.key),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                type: this.driver.configManager.getSensorTypeName(this.type),
                scale: this.scale.label,
                value: this.value,
            },
        };
    }
};
MultilevelSensorCCReport = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.Report)
], MultilevelSensorCCReport);
exports.MultilevelSensorCCReport = MultilevelSensorCCReport;
const testResponseForMultilevelSensorGet = (sent, received) => {
    // We expect a Multilevel Sensor Report that matches the requested sensor type (if a type was requested)
    return sent.sensorType == undefined || received.type === sent.sensorType;
};
let MultilevelSensorCCGet = class MultilevelSensorCCGet extends MultilevelSensorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if ("sensorType" in options) {
                this.sensorType = options.sensorType;
                this.scale = options.scale;
            }
        }
    }
    serialize() {
        if (this.version >= 5 &&
            this.sensorType != undefined &&
            this.scale != undefined) {
            this.payload = Buffer.from([
                this.sensorType,
                (this.scale & 0b11) << 3,
            ]);
        }
        return super.serialize();
    }
    toLogEntry() {
        let message = {};
        if (this.version >= 5 &&
            this.sensorType != undefined &&
            this.scale != undefined) {
            message = {
                "sensor type": this.driver.configManager.getSensorTypeName(this.sensorType),
                scale: this.driver.configManager.lookupSensorScale(this.sensorType, this.scale).label,
            };
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
MultilevelSensorCCGet = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.Get),
    CommandClass_1.expectedCCResponse(MultilevelSensorCCReport, testResponseForMultilevelSensorGet)
], MultilevelSensorCCGet);
exports.MultilevelSensorCCGet = MultilevelSensorCCGet;
let MultilevelSensorCCSupportedSensorReport = class MultilevelSensorCCSupportedSensorReport extends MultilevelSensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._supportedSensorTypes = core_1.parseBitMask(this.payload);
        this.persistValues();
    }
    // TODO: Use this during interview to precreate values
    get supportedSensorTypes() {
        return this._supportedSensorTypes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported sensor types": this.supportedSensorTypes
                    .map((t) => `\n· ${this.driver.configManager.getSensorTypeName(t)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], MultilevelSensorCCSupportedSensorReport.prototype, "supportedSensorTypes", null);
MultilevelSensorCCSupportedSensorReport = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.SupportedSensorReport)
], MultilevelSensorCCSupportedSensorReport);
exports.MultilevelSensorCCSupportedSensorReport = MultilevelSensorCCSupportedSensorReport;
let MultilevelSensorCCGetSupportedSensor = class MultilevelSensorCCGetSupportedSensor extends MultilevelSensorCC {
};
MultilevelSensorCCGetSupportedSensor = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.GetSupportedSensor),
    CommandClass_1.expectedCCResponse(MultilevelSensorCCSupportedSensorReport)
], MultilevelSensorCCGetSupportedSensor);
exports.MultilevelSensorCCGetSupportedSensor = MultilevelSensorCCGetSupportedSensor;
let MultilevelSensorCCSupportedScaleReport = class MultilevelSensorCCSupportedScaleReport extends MultilevelSensorCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        const sensorType = this.payload[0];
        const supportedScales = core_1.parseBitMask(Buffer.from([this.payload[1] & 0b1111]), 0);
        this.supportedScales = [sensorType, supportedScales];
        this.persistValues();
    }
    get sensorType() {
        return this.supportedScales[0];
    }
    get sensorSupportedScales() {
        return this.supportedScales[1];
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "sensor type": this.driver.configManager.getSensorTypeName(this.sensorType),
                "supported scales": this.sensorSupportedScales
                    .map((s) => `\n· ${this.driver.configManager.lookupSensorScale(this.sensorType, s).label}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccKeyValuePair({ internal: true })
], MultilevelSensorCCSupportedScaleReport.prototype, "supportedScales", void 0);
MultilevelSensorCCSupportedScaleReport = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.SupportedScaleReport)
], MultilevelSensorCCSupportedScaleReport);
exports.MultilevelSensorCCSupportedScaleReport = MultilevelSensorCCSupportedScaleReport;
let MultilevelSensorCCGetSupportedScale = class MultilevelSensorCCGetSupportedScale extends MultilevelSensorCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.sensorType = options.sensorType;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.sensorType]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "sensor type": this.driver.configManager.getSensorTypeName(this.sensorType),
            },
        };
    }
};
MultilevelSensorCCGetSupportedScale = __decorate([
    CommandClass_1.CCCommand(MultilevelSensorCommand.GetSupportedScale),
    CommandClass_1.expectedCCResponse(MultilevelSensorCCSupportedScaleReport)
], MultilevelSensorCCGetSupportedScale);
exports.MultilevelSensorCCGetSupportedScale = MultilevelSensorCCGetSupportedScale;

//# sourceMappingURL=MultilevelSensorCC.js.map
