"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SceneActivationCCSet = exports.SceneActivationCC = exports.SceneActivationCCAPI = exports.SceneActivationCommand = exports.getDimmingDurationValueID = exports.getSceneIdValueID = void 0;
const core_1 = require("@zwave-js/core");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// @noInterview This CC is write-only
function getSceneIdValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Scene Activation"],
        endpoint,
        property: "sceneId",
    };
}
exports.getSceneIdValueID = getSceneIdValueID;
function getDimmingDurationValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses["Scene Activation"],
        endpoint,
        property: "dimmingDuration",
    };
}
exports.getDimmingDurationValueID = getDimmingDurationValueID;
// All the supported commands
var SceneActivationCommand;
(function (SceneActivationCommand) {
    SceneActivationCommand[SceneActivationCommand["Set"] = 1] = "Set";
})(SceneActivationCommand = exports.SceneActivationCommand || (exports.SceneActivationCommand = {}));
let SceneActivationCCAPI = class SceneActivationCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "sceneId") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "number") {
                API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
            }
            await this.set(value);
        };
    }
    supportsCommand(_cmd) {
        // There is only one command
        return true;
        // switch (cmd) {
        // 	case SceneActivationCommand.Set:
        // 		return true; // This is mandatory
        // }
        // return super.supportsCommand(cmd);
    }
    async set(sceneId, dimmingDuration) {
        this.assertSupportsCommand(SceneActivationCommand, SceneActivationCommand.Set);
        const cc = new SceneActivationCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            sceneId,
            dimmingDuration,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE;
SceneActivationCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Scene Activation"])
], SceneActivationCCAPI);
exports.SceneActivationCCAPI = SceneActivationCCAPI;
let SceneActivationCC = class SceneActivationCC extends CommandClass_1.CommandClass {
};
SceneActivationCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Scene Activation"]),
    CommandClass_1.implementedVersion(1)
], SceneActivationCC);
exports.SceneActivationCC = SceneActivationCC;
let SceneActivationCCSet = class SceneActivationCCSet extends SceneActivationCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 2);
            this.sceneId = this.payload[0];
            this.dimmingDuration = core_1.Duration.parseSet(this.payload[1]);
            core_1.validatePayload(this.sceneId >= 1, this.sceneId <= 255);
            this.persistValues();
        }
        else {
            this.sceneId = options.sceneId;
            this.dimmingDuration = options.dimmingDuration;
        }
    }
    serialize() {
        var _b, _c;
        this.payload = Buffer.from([
            this.sceneId,
            (_c = (_b = this.dimmingDuration) === null || _b === void 0 ? void 0 : _b.serializeSet()) !== null && _c !== void 0 ? _c : 0xff,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = { "scene id": this.sceneId };
        if (this.dimmingDuration != undefined) {
            message["dimming duration"] = this.dimmingDuration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ stateful: false }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        min: 1,
        label: "Scene ID",
    })
], SceneActivationCCSet.prototype, "sceneId", void 0);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Any,
        label: "Dimming duration",
    })
], SceneActivationCCSet.prototype, "dimmingDuration", void 0);
SceneActivationCCSet = __decorate([
    CommandClass_1.CCCommand(SceneActivationCommand.Set)
], SceneActivationCCSet);
exports.SceneActivationCCSet = SceneActivationCCSet;

//# sourceMappingURL=SceneActivationCC.js.map
