/// <reference types="node" />
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import { Maybe } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ThermostatModeCommand {
    Set = 1,
    Get = 2,
    Report = 3,
    SupportedGet = 4,
    SupportedReport = 5
}
/**
 * @publicAPI
 */
export declare enum ThermostatMode {
    "Off" = 0,
    "Heat" = 1,
    "Cool" = 2,
    "Auto" = 3,
    "Auxiliary" = 4,
    "Resume (on)" = 5,
    "Fan" = 6,
    "Furnace" = 7,
    "Dry" = 8,
    "Moist" = 9,
    "Auto changeover" = 10,
    "Energy heat" = 11,
    "Energy cool" = 12,
    "Away" = 13,
    "Full power" = 15,
    "Manufacturer specific" = 31
}
export declare class ThermostatModeCCAPI extends CCAPI {
    supportsCommand(cmd: ThermostatModeCommand): Maybe<boolean>;
    protected [SET_VALUE]: SetValueImplementation;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<ThermostatModeCCReport, "mode" | "manufacturerData"> | undefined>;
    set(mode: Exclude<ThermostatMode, typeof ThermostatMode["Manufacturer specific"]>): Promise<void>;
    set(mode: typeof ThermostatMode["Manufacturer specific"], manufacturerData: Buffer): Promise<void>;
    getSupportedModes(): Promise<readonly ThermostatMode[] | undefined>;
}
export declare class ThermostatModeCC extends CommandClass {
    ccCommand: ThermostatModeCommand;
    interview(complete?: boolean): Promise<void>;
}
declare type ThermostatModeCCSetOptions = CCCommandOptions & ({
    mode: Exclude<ThermostatMode, typeof ThermostatMode["Manufacturer specific"]>;
} | {
    mode: typeof ThermostatMode["Manufacturer specific"];
    manufacturerData: Buffer;
});
export declare class ThermostatModeCCSet extends ThermostatModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatModeCCSetOptions);
    mode: ThermostatMode;
    manufacturerData?: Buffer;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatModeCCReport extends ThermostatModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    private _mode;
    get mode(): ThermostatMode;
    private _manufacturerData;
    get manufacturerData(): Buffer | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatModeCCGet extends ThermostatModeCC {
}
export declare class ThermostatModeCCSupportedReport extends ThermostatModeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedModes;
    get supportedModes(): readonly ThermostatMode[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatModeCCSupportedGet extends ThermostatModeCC {
}
export {};
