"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatModeCCSupportedGet = exports.ThermostatModeCCSupportedReport = exports.ThermostatModeCCGet = exports.ThermostatModeCCReport = exports.ThermostatModeCCSet = exports.ThermostatModeCC = exports.ThermostatModeCCAPI = exports.ThermostatMode = exports.ThermostatModeCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var ThermostatModeCommand;
(function (ThermostatModeCommand) {
    ThermostatModeCommand[ThermostatModeCommand["Set"] = 1] = "Set";
    ThermostatModeCommand[ThermostatModeCommand["Get"] = 2] = "Get";
    ThermostatModeCommand[ThermostatModeCommand["Report"] = 3] = "Report";
    ThermostatModeCommand[ThermostatModeCommand["SupportedGet"] = 4] = "SupportedGet";
    ThermostatModeCommand[ThermostatModeCommand["SupportedReport"] = 5] = "SupportedReport";
})(ThermostatModeCommand = exports.ThermostatModeCommand || (exports.ThermostatModeCommand = {}));
/**
 * @publicAPI
 */
var ThermostatMode;
(function (ThermostatMode) {
    ThermostatMode[ThermostatMode["Off"] = 0] = "Off";
    ThermostatMode[ThermostatMode["Heat"] = 1] = "Heat";
    ThermostatMode[ThermostatMode["Cool"] = 2] = "Cool";
    ThermostatMode[ThermostatMode["Auto"] = 3] = "Auto";
    ThermostatMode[ThermostatMode["Auxiliary"] = 4] = "Auxiliary";
    ThermostatMode[ThermostatMode["Resume (on)"] = 5] = "Resume (on)";
    ThermostatMode[ThermostatMode["Fan"] = 6] = "Fan";
    ThermostatMode[ThermostatMode["Furnace"] = 7] = "Furnace";
    ThermostatMode[ThermostatMode["Dry"] = 8] = "Dry";
    ThermostatMode[ThermostatMode["Moist"] = 9] = "Moist";
    ThermostatMode[ThermostatMode["Auto changeover"] = 10] = "Auto changeover";
    ThermostatMode[ThermostatMode["Energy heat"] = 11] = "Energy heat";
    ThermostatMode[ThermostatMode["Energy cool"] = 12] = "Energy cool";
    ThermostatMode[ThermostatMode["Away"] = 13] = "Away";
    ThermostatMode[ThermostatMode["Full power"] = 15] = "Full power";
    ThermostatMode[ThermostatMode["Manufacturer specific"] = 31] = "Manufacturer specific";
})(ThermostatMode = exports.ThermostatMode || (exports.ThermostatMode = {}));
let ThermostatModeCCAPI = class ThermostatModeCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            if (property !== "mode") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "number") {
                API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
            }
            await this.set(value);
            if (this.isSinglecast()) {
                // Verify the current value after a delay
                this.schedulePoll({ property });
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "mode":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatModeCommand.Get:
            case ThermostatModeCommand.SupportedGet:
                return this.isSinglecast();
            case ThermostatModeCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ThermostatModeCommand, ThermostatModeCommand.Get);
        const cc = new ThermostatModeCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["mode", "manufacturerData"]);
        }
    }
    async set(mode, manufacturerData) {
        this.assertSupportsCommand(ThermostatModeCommand, ThermostatModeCommand.Set);
        const cc = new ThermostatModeCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            mode,
            manufacturerData: manufacturerData,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getSupportedModes() {
        this.assertSupportsCommand(ThermostatModeCommand, ThermostatModeCommand.SupportedGet);
        const cc = new ThermostatModeCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.supportedModes;
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ThermostatModeCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Mode"])
], ThermostatModeCCAPI);
exports.ThermostatModeCCAPI = ThermostatModeCCAPI;
let ThermostatModeCC = class ThermostatModeCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Mode"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (complete) {
            // First query the possible modes to set the metadata
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying supported thermostat modes...",
                direction: "outbound",
            });
            const supportedModes = await api.getSupportedModes();
            if (supportedModes) {
                const logMessage = `received supported thermostat modes:${supportedModes
                    .map((mode) => `\n· ${shared_1.getEnumMemberName(ThermostatMode, mode)}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: "Querying supported thermostat modes timed out, skipping interview...",
                    level: "warn",
                });
                return;
            }
        }
        // Always query the actual status
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying current thermostat mode...",
            direction: "outbound",
        });
        const currentStatus = await api.get();
        if (currentStatus) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "received current thermostat mode: " +
                    shared_1.getEnumMemberName(ThermostatMode, currentStatus.mode),
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatModeCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Mode"]),
    CommandClass_1.implementedVersion(3)
], ThermostatModeCC);
exports.ThermostatModeCC = ThermostatModeCC;
let ThermostatModeCCSet = class ThermostatModeCCSet extends ThermostatModeCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.mode = options.mode;
            if ("manufacturerData" in options)
                this.manufacturerData = options.manufacturerData;
        }
    }
    serialize() {
        const manufacturerData = this.version >= 3 &&
            this.mode === ThermostatMode["Manufacturer specific"] &&
            this.manufacturerData
            ? this.manufacturerData
            : Buffer.from([]);
        const manufacturerDataLength = manufacturerData.length;
        this.payload = Buffer.concat([
            Buffer.from([
                ((manufacturerDataLength & 0b111) << 5) + (this.mode & 0b11111),
            ]),
            manufacturerData,
        ]);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            mode: shared_1.getEnumMemberName(ThermostatMode, this.mode),
        };
        if (this.manufacturerData != undefined) {
            message["manufacturer data"] = shared_1.buffer2hex(this.manufacturerData);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
ThermostatModeCCSet = __decorate([
    CommandClass_1.CCCommand(ThermostatModeCommand.Set)
], ThermostatModeCCSet);
exports.ThermostatModeCCSet = ThermostatModeCCSet;
let ThermostatModeCCReport = class ThermostatModeCCReport extends ThermostatModeCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._mode = this.payload[0] & 0b11111;
        if (this.version >= 3) {
            const manufacturerDataLength = this.payload[0] >>> 5;
            core_1.validatePayload(this.payload.length >= 1 + manufacturerDataLength);
            if (manufacturerDataLength) {
                this._manufacturerData = this.payload.slice(1, 1 + manufacturerDataLength);
            }
        }
        this.persistValues();
    }
    get mode() {
        return this._mode;
    }
    get manufacturerData() {
        return this._manufacturerData;
    }
    toLogEntry() {
        const message = {
            mode: shared_1.getEnumMemberName(ThermostatMode, this.mode),
        };
        if (this.manufacturerData != undefined) {
            message["manufacturer data"] = shared_1.buffer2hex(this.manufacturerData);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.UInt8,
        min: 0,
        max: 31,
        label: "Thermostat mode",
    })
], ThermostatModeCCReport.prototype, "mode", null);
__decorate([
    CommandClass_1.ccValue()
], ThermostatModeCCReport.prototype, "manufacturerData", null);
ThermostatModeCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatModeCommand.Report)
], ThermostatModeCCReport);
exports.ThermostatModeCCReport = ThermostatModeCCReport;
let ThermostatModeCCGet = class ThermostatModeCCGet extends ThermostatModeCC {
};
ThermostatModeCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatModeCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatModeCCReport)
], ThermostatModeCCGet);
exports.ThermostatModeCCGet = ThermostatModeCCGet;
let ThermostatModeCCSupportedReport = class ThermostatModeCCSupportedReport extends ThermostatModeCC {
    constructor(driver, options) {
        super(driver, options);
        this._supportedModes = core_1.parseBitMask(this.payload, ThermostatMode.Off);
        // Use this information to create the metadata for the mode property
        const valueId = {
            commandClass: this.ccId,
            endpoint: this.endpointIndex,
            property: "mode",
        };
        // Only update the dynamic part
        this.getValueDB().setMetadata(valueId, {
            states: core_1.enumValuesToMetadataStates(ThermostatMode, this._supportedModes),
        });
        this.persistValues();
    }
    get supportedModes() {
        return this._supportedModes;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supported modes": this.supportedModes
                    .map((mode) => `\n· ${shared_1.getEnumMemberName(ThermostatMode, mode)}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ThermostatModeCCSupportedReport.prototype, "supportedModes", null);
ThermostatModeCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(ThermostatModeCommand.SupportedReport)
], ThermostatModeCCSupportedReport);
exports.ThermostatModeCCSupportedReport = ThermostatModeCCSupportedReport;
let ThermostatModeCCSupportedGet = class ThermostatModeCCSupportedGet extends ThermostatModeCC {
};
ThermostatModeCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(ThermostatModeCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(ThermostatModeCCSupportedReport)
], ThermostatModeCCSupportedGet);
exports.ThermostatModeCCSupportedGet = ThermostatModeCCSupportedGet;

//# sourceMappingURL=ThermostatModeCC.js.map
