"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatOperatingStateCCGet = exports.ThermostatOperatingStateCCReport = exports.ThermostatOperatingStateCC = exports.ThermostatOperatingStateCCAPI = exports.ThermostatOperatingState = exports.ThermostatOperatingStateCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var ThermostatOperatingStateCommand;
(function (ThermostatOperatingStateCommand) {
    ThermostatOperatingStateCommand[ThermostatOperatingStateCommand["Get"] = 2] = "Get";
    ThermostatOperatingStateCommand[ThermostatOperatingStateCommand["Report"] = 3] = "Report";
    // TODO: Implement V2 commands
    // LoggingSupportedGet = 0x01,
    // LoggingSupportedReport = 0x04,
    // LoggingGet = 0x05,
    // LoggingReport = 0x06,
})(ThermostatOperatingStateCommand = exports.ThermostatOperatingStateCommand || (exports.ThermostatOperatingStateCommand = {}));
/**
 * @publicAPI
 */
var ThermostatOperatingState;
(function (ThermostatOperatingState) {
    ThermostatOperatingState[ThermostatOperatingState["Idle"] = 0] = "Idle";
    ThermostatOperatingState[ThermostatOperatingState["Heating"] = 1] = "Heating";
    ThermostatOperatingState[ThermostatOperatingState["Cooling"] = 2] = "Cooling";
    ThermostatOperatingState[ThermostatOperatingState["Fan Only"] = 3] = "Fan Only";
    ThermostatOperatingState[ThermostatOperatingState["Pending Heat"] = 4] = "Pending Heat";
    ThermostatOperatingState[ThermostatOperatingState["Pending Cool"] = 5] = "Pending Cool";
    ThermostatOperatingState[ThermostatOperatingState["Vent/Economizer"] = 6] = "Vent/Economizer";
    ThermostatOperatingState[ThermostatOperatingState["Aux Heating"] = 7] = "Aux Heating";
    ThermostatOperatingState[ThermostatOperatingState["2nd Stage Heating"] = 8] = "2nd Stage Heating";
    ThermostatOperatingState[ThermostatOperatingState["2nd Stage Cooling"] = 9] = "2nd Stage Cooling";
    ThermostatOperatingState[ThermostatOperatingState["2nd Stage Aux Heat"] = 10] = "2nd Stage Aux Heat";
    ThermostatOperatingState[ThermostatOperatingState["3rd Stage Aux Heat"] = 11] = "3rd Stage Aux Heat";
})(ThermostatOperatingState = exports.ThermostatOperatingState || (exports.ThermostatOperatingState = {}));
// @noSetValueAPI This CC is read-only
let ThermostatOperatingStateCCAPI = class ThermostatOperatingStateCCAPI extends API_1.PhysicalCCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            switch (property) {
                case "state":
                    return this.get();
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatOperatingStateCommand.Get:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    async get() {
        this.assertSupportsCommand(ThermostatOperatingStateCommand, ThermostatOperatingStateCommand.Get);
        const cc = new ThermostatOperatingStateCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.state;
    }
};
_a = API_1.POLL_VALUE;
ThermostatOperatingStateCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Operating State"])
], ThermostatOperatingStateCCAPI);
exports.ThermostatOperatingStateCCAPI = ThermostatOperatingStateCCAPI;
let ThermostatOperatingStateCC = class ThermostatOperatingStateCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Operating State"].withOptions({ priority: Constants_1.MessagePriority.NodeQuery });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Always query the current state
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying thermostat operating state...",
            direction: "outbound",
        });
        const state = await api.get();
        if (state) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `received current thermostat operating state: ${shared_1.getEnumMemberName(ThermostatOperatingState, state)}`,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatOperatingStateCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Operating State"]),
    CommandClass_1.implementedVersion(2)
], ThermostatOperatingStateCC);
exports.ThermostatOperatingStateCC = ThermostatOperatingStateCC;
let ThermostatOperatingStateCCReport = class ThermostatOperatingStateCCReport extends ThermostatOperatingStateCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this._state = this.payload[0];
        this.persistValues();
    }
    get state() {
        return this._state;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                state: shared_1.getEnumMemberName(ThermostatOperatingState, this.state),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        label: "Operating state",
        states: core_1.enumValuesToMetadataStates(ThermostatOperatingState),
    })
], ThermostatOperatingStateCCReport.prototype, "state", null);
ThermostatOperatingStateCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatOperatingStateCommand.Report)
], ThermostatOperatingStateCCReport);
exports.ThermostatOperatingStateCCReport = ThermostatOperatingStateCCReport;
let ThermostatOperatingStateCCGet = class ThermostatOperatingStateCCGet extends ThermostatOperatingStateCC {
};
ThermostatOperatingStateCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatOperatingStateCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatOperatingStateCCReport)
], ThermostatOperatingStateCCGet);
exports.ThermostatOperatingStateCCGet = ThermostatOperatingStateCCGet;

//# sourceMappingURL=ThermostatOperatingStateCC.js.map
