/// <reference types="node" />
import type { Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { SetbackState } from "../values/SetbackState";
import { CCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ThermostatSetbackCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
/**
 * @publicAPI
 */
export declare enum SetbackType {
    None = 0,
    Temporary = 1,
    Permanent = 2
}
export declare class ThermostatSetbackCCAPI extends CCAPI {
    supportsCommand(cmd: ThermostatSetbackCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<ThermostatSetbackCCReport, "setbackType" | "setbackState"> | undefined>;
    set(setbackType: SetbackType, setbackState: SetbackState): Promise<void>;
}
export declare class ThermostatSetbackCC extends CommandClass {
    ccCommand: ThermostatSetbackCommand;
    interview(complete?: boolean): Promise<void>;
}
interface ThermostatSetbackCCSetOptions extends CCCommandOptions {
    setbackType: SetbackType;
    setbackState: SetbackState;
}
export declare class ThermostatSetbackCCSet extends ThermostatSetbackCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ThermostatSetbackCCSetOptions);
    setbackType: SetbackType;
    /** The offset from the setpoint in 0.1 Kelvin or a special mode */
    setbackState: SetbackState;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetbackCCReport extends ThermostatSetbackCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _setbackType;
    get setbackType(): SetbackType;
    private _setbackState;
    /** The offset from the setpoint in 0.1 Kelvin or a special mode */
    get setbackState(): SetbackState;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ThermostatSetbackCCGet extends ThermostatSetbackCC {
}
export {};
