"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatSetbackCCGet = exports.ThermostatSetbackCCReport = exports.ThermostatSetbackCCSet = exports.ThermostatSetbackCC = exports.ThermostatSetbackCCAPI = exports.SetbackType = exports.ThermostatSetbackCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const SetbackState_1 = require("../values/SetbackState");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var ThermostatSetbackCommand;
(function (ThermostatSetbackCommand) {
    ThermostatSetbackCommand[ThermostatSetbackCommand["Set"] = 1] = "Set";
    ThermostatSetbackCommand[ThermostatSetbackCommand["Get"] = 2] = "Get";
    ThermostatSetbackCommand[ThermostatSetbackCommand["Report"] = 3] = "Report";
})(ThermostatSetbackCommand = exports.ThermostatSetbackCommand || (exports.ThermostatSetbackCommand = {}));
/**
 * @publicAPI
 */
var SetbackType;
(function (SetbackType) {
    SetbackType[SetbackType["None"] = 0] = "None";
    SetbackType[SetbackType["Temporary"] = 1] = "Temporary";
    SetbackType[SetbackType["Permanent"] = 2] = "Permanent";
})(SetbackType = exports.SetbackType || (exports.SetbackType = {}));
// @noSetValueAPI
// The setback state consist of two values that must be set together
let ThermostatSetbackCCAPI = class ThermostatSetbackCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            var _b;
            switch (property) {
                case "setbackType":
                case "setbackState":
                    return (_b = (await this.get())) === null || _b === void 0 ? void 0 : _b[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatSetbackCommand.Get:
                return this.isSinglecast();
            case ThermostatSetbackCommand.Set:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ThermostatSetbackCommand, ThermostatSetbackCommand.Get);
        const cc = new ThermostatSetbackCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["setbackType", "setbackState"]);
        }
    }
    async set(setbackType, setbackState) {
        this.assertSupportsCommand(ThermostatSetbackCommand, ThermostatSetbackCommand.Get);
        const cc = new ThermostatSetbackCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            setbackType,
            setbackState,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.POLL_VALUE;
ThermostatSetbackCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Setback"])
], ThermostatSetbackCCAPI);
exports.ThermostatSetbackCCAPI = ThermostatSetbackCCAPI;
let ThermostatSetbackCC = class ThermostatSetbackCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Setback"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Always query the thermostat state
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying the current thermostat state...",
            direction: "outbound",
        });
        const setbackResp = await api.get();
        if (setbackResp) {
            const logMessage = `received current state:
setback type:  ${shared_1.getEnumMemberName(SetbackType, setbackResp.setbackType)}
setback state: ${setbackResp.setbackState}`;
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatSetbackCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Setback"]),
    CommandClass_1.implementedVersion(1)
], ThermostatSetbackCC);
exports.ThermostatSetbackCC = ThermostatSetbackCC;
let ThermostatSetbackCCSet = class ThermostatSetbackCCSet extends ThermostatSetbackCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.setbackType = options.setbackType;
            this.setbackState = options.setbackState;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.setbackType & 0b11,
            SetbackState_1.encodeSetbackState(this.setbackState),
        ]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "setback type": shared_1.getEnumMemberName(SetbackType, this.setbackType),
                "setback state": this.setbackState,
            },
        };
    }
};
ThermostatSetbackCCSet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetbackCommand.Set)
], ThermostatSetbackCCSet);
exports.ThermostatSetbackCCSet = ThermostatSetbackCCSet;
let ThermostatSetbackCCReport = class ThermostatSetbackCCReport extends ThermostatSetbackCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 2);
        this._setbackType = this.payload[0] & 0b11;
        // If we receive an unknown setback state, return the raw value
        this._setbackState =
            SetbackState_1.decodeSetbackState(this.payload[1]) || this.payload[1];
        this.persistValues();
    }
    get setbackType() {
        return this._setbackType;
    }
    /** The offset from the setpoint in 0.1 Kelvin or a special mode */
    get setbackState() {
        return this._setbackState;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "setback type": shared_1.getEnumMemberName(SetbackType, this.setbackType),
                "setback state": this.setbackState,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        // TODO: This should be a value list
        ...core_1.ValueMetadata.Any,
        label: "Setback type",
    })
], ThermostatSetbackCCReport.prototype, "setbackType", null);
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Int8,
        min: -12.8,
        max: 12,
        label: "Setback state",
    })
], ThermostatSetbackCCReport.prototype, "setbackState", null);
ThermostatSetbackCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatSetbackCommand.Report)
], ThermostatSetbackCCReport);
exports.ThermostatSetbackCCReport = ThermostatSetbackCCReport;
let ThermostatSetbackCCGet = class ThermostatSetbackCCGet extends ThermostatSetbackCC {
};
ThermostatSetbackCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatSetbackCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatSetbackCCReport)
], ThermostatSetbackCCGet);
exports.ThermostatSetbackCCGet = ThermostatSetbackCCGet;

//# sourceMappingURL=ThermostatSetbackCC.js.map
