import type { Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum ZWavePlusCommand {
    Get = 1,
    Report = 2
}
/**
 * @publicAPI
 */
export declare enum ZWavePlusRoleType {
    CentralStaticController = 0,
    SubStaticController = 1,
    PortableController = 2,
    PortableReportingController = 3,
    PortableSlave = 4,
    AlwaysOnSlave = 5,
    SleepingReportingSlave = 6,
    SleepingListeningSlave = 7
}
/**
 * @publicAPI
 */
export declare enum ZWavePlusNodeType {
    Node = 0,
    IPGateway = 2
}
export declare function getZWavePlusVersionValueId(): ValueID;
export declare function getNodeTypeValueId(): ValueID;
export declare function getRoleTypeValueId(): ValueID;
export declare function getInstallerIconValueId(endpoint?: number): ValueID;
export declare function getUserIconValueId(endpoint?: number): ValueID;
export declare class ZWavePlusCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: ZWavePlusCommand): Maybe<boolean>;
    get(): Promise<Pick<ZWavePlusCCReport, "zwavePlusVersion" | "nodeType" | "roleType" | "installerIcon" | "userIcon"> | undefined>;
}
export declare class ZWavePlusCC extends CommandClass {
    ccCommand: ZWavePlusCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class ZWavePlusCCReport extends ZWavePlusCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _zwavePlusVersion;
    get zwavePlusVersion(): number;
    private _nodeType;
    get nodeType(): ZWavePlusNodeType;
    private _roleType;
    get roleType(): ZWavePlusRoleType;
    private _installerIcon;
    get installerIcon(): number;
    private _userIcon;
    get userIcon(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ZWavePlusCCGet extends ZWavePlusCC {
}
