"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZWavePlusCCGet = exports.ZWavePlusCCReport = exports.ZWavePlusCC = exports.ZWavePlusCCAPI = exports.getUserIconValueId = exports.getInstallerIconValueId = exports.getRoleTypeValueId = exports.getNodeTypeValueId = exports.getZWavePlusVersionValueId = exports.ZWavePlusNodeType = exports.ZWavePlusRoleType = exports.ZWavePlusCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var ZWavePlusCommand;
(function (ZWavePlusCommand) {
    ZWavePlusCommand[ZWavePlusCommand["Get"] = 1] = "Get";
    ZWavePlusCommand[ZWavePlusCommand["Report"] = 2] = "Report";
})(ZWavePlusCommand = exports.ZWavePlusCommand || (exports.ZWavePlusCommand = {}));
/**
 * @publicAPI
 */
var ZWavePlusRoleType;
(function (ZWavePlusRoleType) {
    ZWavePlusRoleType[ZWavePlusRoleType["CentralStaticController"] = 0] = "CentralStaticController";
    ZWavePlusRoleType[ZWavePlusRoleType["SubStaticController"] = 1] = "SubStaticController";
    ZWavePlusRoleType[ZWavePlusRoleType["PortableController"] = 2] = "PortableController";
    ZWavePlusRoleType[ZWavePlusRoleType["PortableReportingController"] = 3] = "PortableReportingController";
    ZWavePlusRoleType[ZWavePlusRoleType["PortableSlave"] = 4] = "PortableSlave";
    ZWavePlusRoleType[ZWavePlusRoleType["AlwaysOnSlave"] = 5] = "AlwaysOnSlave";
    ZWavePlusRoleType[ZWavePlusRoleType["SleepingReportingSlave"] = 6] = "SleepingReportingSlave";
    ZWavePlusRoleType[ZWavePlusRoleType["SleepingListeningSlave"] = 7] = "SleepingListeningSlave";
})(ZWavePlusRoleType = exports.ZWavePlusRoleType || (exports.ZWavePlusRoleType = {}));
/**
 * @publicAPI
 */
var ZWavePlusNodeType;
(function (ZWavePlusNodeType) {
    ZWavePlusNodeType[ZWavePlusNodeType["Node"] = 0] = "Node";
    ZWavePlusNodeType[ZWavePlusNodeType["IPGateway"] = 2] = "IPGateway";
})(ZWavePlusNodeType = exports.ZWavePlusNodeType || (exports.ZWavePlusNodeType = {}));
// SDS13782 The advertised Z-Wave Plus Version, Role Type and Node Type information values
// MUST be identical for the Root Device and all Multi Channel End Points
// --> We only access endpoint 0
function getZWavePlusVersionValueId() {
    return {
        commandClass: core_1.CommandClasses["Z-Wave Plus Info"],
        property: "zwavePlusVersion",
    };
}
exports.getZWavePlusVersionValueId = getZWavePlusVersionValueId;
function getNodeTypeValueId() {
    return {
        commandClass: core_1.CommandClasses["Z-Wave Plus Info"],
        property: "nodeType",
    };
}
exports.getNodeTypeValueId = getNodeTypeValueId;
function getRoleTypeValueId() {
    return {
        commandClass: core_1.CommandClasses["Z-Wave Plus Info"],
        property: "roleType",
    };
}
exports.getRoleTypeValueId = getRoleTypeValueId;
function getInstallerIconValueId(endpoint = 0) {
    return {
        commandClass: core_1.CommandClasses["Z-Wave Plus Info"],
        endpoint,
        property: "installerIcon",
    };
}
exports.getInstallerIconValueId = getInstallerIconValueId;
function getUserIconValueId(endpoint = 0) {
    return {
        commandClass: core_1.CommandClasses["Z-Wave Plus Info"],
        endpoint,
        property: "userIcon",
    };
}
exports.getUserIconValueId = getUserIconValueId;
// @noSetValueAPI This CC is read-only
let ZWavePlusCCAPI = class ZWavePlusCCAPI extends API_1.PhysicalCCAPI {
    supportsCommand(cmd) {
        switch (cmd) {
            case ZWavePlusCommand.Get:
                return true; // This is mandatory
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ZWavePlusCommand, ZWavePlusCommand.Get);
        const cc = new ZWavePlusCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "zwavePlusVersion",
                "nodeType",
                "roleType",
                "installerIcon",
                "userIcon",
            ]);
        }
    }
};
ZWavePlusCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Z-Wave Plus Info"])
], ZWavePlusCCAPI);
exports.ZWavePlusCCAPI = ZWavePlusCCAPI;
let ZWavePlusCC = class ZWavePlusCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Z-Wave Plus Info"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        if (complete) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "querying Z-Wave+ information...",
                direction: "outbound",
            });
            const zwavePlusResponse = await api.get();
            if (zwavePlusResponse) {
                const logMessage = `received response for Z-Wave+ information:
Z-Wave+ version: ${zwavePlusResponse.zwavePlusVersion}
role type:       ${ZWavePlusRoleType[zwavePlusResponse.roleType]}
node type:       ${ZWavePlusNodeType[zwavePlusResponse.nodeType]}
installer icon:  ${shared_1.num2hex(zwavePlusResponse.installerIcon)}
user icon:       ${shared_1.num2hex(zwavePlusResponse.userIcon)}`;
                this.driver.controllerLog.logNode(node.id, {
                    endpoint: this.endpointIndex,
                    message: logMessage,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ZWavePlusCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Z-Wave Plus Info"]),
    CommandClass_1.implementedVersion(2)
], ZWavePlusCC);
exports.ZWavePlusCC = ZWavePlusCC;
let ZWavePlusCCReport = class ZWavePlusCCReport extends ZWavePlusCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 7);
        this._zwavePlusVersion = this.payload[0];
        this._roleType = this.payload[1];
        this._nodeType = this.payload[2];
        this._installerIcon = this.payload.readUInt16BE(3);
        this._userIcon = this.payload.readUInt16BE(5);
        this.persistValues();
    }
    get zwavePlusVersion() {
        return this._zwavePlusVersion;
    }
    get nodeType() {
        return this._nodeType;
    }
    get roleType() {
        return this._roleType;
    }
    get installerIcon() {
        return this._installerIcon;
    }
    get userIcon() {
        return this._userIcon;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                version: this._zwavePlusVersion,
                "node type": shared_1.getEnumMemberName(ZWavePlusNodeType, this._nodeType),
                "role type": shared_1.getEnumMemberName(ZWavePlusRoleType, this._roleType),
                "icon (mgmt.)": shared_1.num2hex(this._installerIcon),
                "icon (user)": shared_1.num2hex(this._userIcon),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ZWavePlusCCReport.prototype, "zwavePlusVersion", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ZWavePlusCCReport.prototype, "nodeType", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ZWavePlusCCReport.prototype, "roleType", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ZWavePlusCCReport.prototype, "installerIcon", null);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ZWavePlusCCReport.prototype, "userIcon", null);
ZWavePlusCCReport = __decorate([
    CommandClass_1.CCCommand(ZWavePlusCommand.Report)
], ZWavePlusCCReport);
exports.ZWavePlusCCReport = ZWavePlusCCReport;
let ZWavePlusCCGet = class ZWavePlusCCGet extends ZWavePlusCC {
};
ZWavePlusCCGet = __decorate([
    CommandClass_1.CCCommand(ZWavePlusCommand.Get),
    CommandClass_1.expectedCCResponse(ZWavePlusCCReport)
], ZWavePlusCCGet);
exports.ZWavePlusCCGet = ZWavePlusCCGet;

//# sourceMappingURL=ZWavePlusCC.js.map
