/// <reference types="node" />
import { MessageOrCCLogEntry } from "@zwave-js/core";
import { CommandClass, SinglecastCC } from "../commandclass/CommandClass";
import type { ICommandClassContainer } from "../commandclass/ICommandClassContainer";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
export declare enum ApplicationCommandStatusFlags {
    RoutedBusy = 1,
    LowPower = 2,
    TypeSingle = 0,
    TypeBroad = 4,
    TypeMulti = 8,
    TypeMask = 12,
    Explore = 16,
    ForeignFrame = 64,
    ForeignHomeId = 128
}
interface ApplicationCommandRequestOptions extends MessageBaseOptions {
    command: CommandClass;
    frameType?: ApplicationCommandRequest["frameType"];
    routedBusy?: boolean;
}
export declare class ApplicationCommandRequest extends Message implements ICommandClassContainer {
    constructor(driver: Driver, options: MessageDeserializationOptions | ApplicationCommandRequestOptions);
    readonly routedBusy: boolean;
    readonly frameType: "singlecast" | "broadcast" | "multicast";
    readonly isExploreFrame: boolean;
    readonly isForeignFrame: boolean;
    readonly fromForeignHomeId: boolean;
    command: SinglecastCC;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
