/// <reference types="node" />
import { MessageOrCCLogEntry } from "@zwave-js/core";
import { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions, MessageOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
import type { INodeQuery } from "../node/INodeQuery";
import { TransmitStatus } from "./SendDataMessages";
export declare class AssignReturnRouteRequestBase extends Message {
    constructor(driver: Driver, options: MessageOptions);
}
export interface AssignReturnRouteRequestOptions extends MessageBaseOptions {
    nodeId: number;
    destinationNodeId: number;
}
export declare class AssignReturnRouteRequest extends AssignReturnRouteRequestBase implements INodeQuery {
    constructor(driver: Driver, options: MessageDeserializationOptions | AssignReturnRouteRequestOptions);
    nodeId: number;
    destinationNodeId: number;
    serialize(): Buffer;
}
export declare class AssignReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    readonly hasStarted: boolean;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class AssignReturnRouteRequestTransmitReport extends AssignReturnRouteRequestBase implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    private _transmitStatus;
    get transmitStatus(): TransmitStatus;
    toJSON(): JSONObject;
    toLogEntry(): MessageOrCCLogEntry;
}
