"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BridgeApplicationCommandRequest = exports.RSSIValue = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const CommandClass_1 = require("../commandclass/CommandClass");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const ApplicationCommandRequest_1 = require("./ApplicationCommandRequest");
var RSSIValue;
(function (RSSIValue) {
    RSSIValue[RSSIValue["NotAvailable"] = 127] = "NotAvailable";
    RSSIValue[RSSIValue["ReceiverSaturated"] = 126] = "ReceiverSaturated";
    RSSIValue[RSSIValue["NoSignalDetected"] = 125] = "NoSignalDetected";
})(RSSIValue = exports.RSSIValue || (exports.RSSIValue = {}));
const RSSI_RESERVED_START = 11;
let BridgeApplicationCommandRequest = class BridgeApplicationCommandRequest extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        // if (gotDeserializationOptions(options)) {
        // first byte is a status flag
        const status = this.payload[0];
        this.routedBusy = !!(status & ApplicationCommandRequest_1.ApplicationCommandStatusFlags.RoutedBusy);
        switch (status & ApplicationCommandRequest_1.ApplicationCommandStatusFlags.TypeMask) {
            case ApplicationCommandRequest_1.ApplicationCommandStatusFlags.TypeMulti:
                this.frameType = "multicast";
                break;
            case ApplicationCommandRequest_1.ApplicationCommandStatusFlags.TypeBroad:
                this.frameType = "broadcast";
                break;
            default:
                this.frameType = "singlecast";
        }
        this.isExploreFrame =
            this.frameType === "broadcast" &&
                !!(status & ApplicationCommandRequest_1.ApplicationCommandStatusFlags.Explore);
        this.isForeignFrame = !!(status & ApplicationCommandRequest_1.ApplicationCommandStatusFlags.ForeignFrame);
        this.fromForeignHomeId = !!(status & ApplicationCommandRequest_1.ApplicationCommandStatusFlags.ForeignHomeId);
        const sourceNodeId = this.payload[2];
        // Parse the CC
        const commandLength = this.payload[3];
        let offset = 4;
        this.command = CommandClass_1.CommandClass.from(this.driver, {
            data: this.payload.slice(offset, offset + commandLength),
            nodeId: sourceNodeId,
        });
        offset += commandLength;
        // Read the correct target node id
        const multicastNodesLength = this.payload[offset];
        offset++;
        if (this.frameType === "multicast") {
            this.targetNodeId = [
                ...this.payload.slice(offset, offset + multicastNodesLength),
            ];
        }
        else if (this.frameType === "singlecast") {
            this.targetNodeId = this.payload[1];
        }
        else {
            this.targetNodeId = core_1.NODE_ID_BROADCAST;
        }
        offset += multicastNodesLength;
        this.rssi = this.payload[offset];
        // Filter out reserved values
        if (this.rssi >= RSSI_RESERVED_START &&
            this.rssi < RSSIValue.NoSignalDetected) {
            this.rssi = RSSIValue.NotAvailable;
        }
    }
    toLogEntry() {
        const message = {};
        if (this.frameType !== "singlecast") {
            message.type = this.frameType;
        }
        if (this.targetNodeId !== this.driver.controller.ownNodeId) {
            message["target node"] =
                typeof this.targetNodeId === "number"
                    ? this.targetNodeId
                    : this.targetNodeId.join(", ");
        }
        switch (true) {
            case this.rssi === RSSIValue.ReceiverSaturated:
            case this.rssi === RSSIValue.NoSignalDetected:
                message.rssi = shared_1.getEnumMemberName(RSSIValue, this.rssi);
                break;
            case this.rssi < RSSI_RESERVED_START:
                message.rssi = `${this.rssi} dBms`;
                break;
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
BridgeApplicationCommandRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.BridgeApplicationCommand)
    // This does not expect a response. The controller sends us this when a node sends a command
    ,
    Message_1.priority(Constants_1.MessagePriority.Normal)
], BridgeApplicationCommandRequest);
exports.BridgeApplicationCommandRequest = BridgeApplicationCommandRequest;

//# sourceMappingURL=BridgeApplicationCommandRequest.js.map
