"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveNodeFromNetworkRequest = exports.RemoveNodeStatus = exports.RemoveNodeType = void 0;
const core_1 = require("@zwave-js/core");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
var RemoveNodeType;
(function (RemoveNodeType) {
    RemoveNodeType[RemoveNodeType["Any"] = 1] = "Any";
    RemoveNodeType[RemoveNodeType["Controller"] = 2] = "Controller";
    RemoveNodeType[RemoveNodeType["Slave"] = 3] = "Slave";
    RemoveNodeType[RemoveNodeType["Stop"] = 5] = "Stop";
})(RemoveNodeType = exports.RemoveNodeType || (exports.RemoveNodeType = {}));
var RemoveNodeStatus;
(function (RemoveNodeStatus) {
    RemoveNodeStatus[RemoveNodeStatus["Ready"] = 1] = "Ready";
    RemoveNodeStatus[RemoveNodeStatus["NodeFound"] = 2] = "NodeFound";
    RemoveNodeStatus[RemoveNodeStatus["RemovingSlave"] = 3] = "RemovingSlave";
    RemoveNodeStatus[RemoveNodeStatus["RemovingController"] = 4] = "RemovingController";
    RemoveNodeStatus[RemoveNodeStatus["Done"] = 6] = "Done";
    RemoveNodeStatus[RemoveNodeStatus["Failed"] = 7] = "Failed";
})(RemoveNodeStatus = exports.RemoveNodeStatus || (exports.RemoveNodeStatus = {}));
var RemoveNodeFlags;
(function (RemoveNodeFlags) {
    RemoveNodeFlags[RemoveNodeFlags["HighPower"] = 128] = "HighPower";
    RemoveNodeFlags[RemoveNodeFlags["NetworkWide"] = 64] = "NetworkWide";
})(RemoveNodeFlags || (RemoveNodeFlags = {}));
// TODO: Can we differentiate between sent and received here?
// payload length maybe?
let RemoveNodeFromNetworkRequest = class RemoveNodeFromNetworkRequest extends Message_1.Message {
    constructor(driver, options = {}) {
        super(driver, options);
        /** Whether to use high power */
        this.highPower = false;
        /** Whether to include network wide */
        this.networkWide = false;
        if (Message_1.gotDeserializationOptions(options)) {
            // not sure what the value in payload[0] means
            this._status = this.payload[1];
            switch (this._status) {
                case RemoveNodeStatus.Ready:
                case RemoveNodeStatus.NodeFound:
                case RemoveNodeStatus.Failed:
                case RemoveNodeStatus.Done:
                    // no context for the status to parse
                    // TODO:
                    // An application MUST time out waiting for the REMOVE_NODE_STATUS_REMOVING_SLAVE status
                    // if it does not receive the indication within a 14 sec after receiving the
                    // REMOVE_NODE_STATUS_NODE_FOUND status.
                    break;
                case RemoveNodeStatus.RemovingController:
                case RemoveNodeStatus.RemovingSlave:
                    // the payload contains a node information frame
                    this._statusContext = core_1.parseNodeUpdatePayload(this.payload.slice(2));
                    break;
            }
        }
        else {
            this.removeNodeType = options.removeNodeType;
            this.highPower = !!options.highPower;
            this.networkWide = !!options.networkWide;
        }
    }
    get status() {
        return this._status;
    }
    get statusContext() {
        return this._statusContext;
    }
    serialize() {
        let data = this.removeNodeType || RemoveNodeType.Any;
        if (this.highPower)
            data |= RemoveNodeFlags.HighPower;
        if (this.networkWide)
            data |= RemoveNodeFlags.NetworkWide;
        this.payload = Buffer.from([data, this.callbackId]);
        return super.serialize();
    }
};
RemoveNodeFromNetworkRequest = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.RemoveNodeFromNetwork)
    // no expected response, the controller will respond with another RemoveNodeFromNetworkRequest
    ,
    Message_1.priority(Constants_1.MessagePriority.Controller)
], RemoveNodeFromNetworkRequest);
exports.RemoveNodeFromNetworkRequest = RemoveNodeFromNetworkRequest;

//# sourceMappingURL=RemoveNodeFromNetworkRequest.js.map
