/// <reference types="node" />
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
interface SetSerialApiTimeoutsRequestOptions extends MessageBaseOptions {
    ackTimeout: number;
    byteTimeout: number;
}
export declare class SetSerialApiTimeoutsRequest extends Message {
    constructor(driver: Driver, options: SetSerialApiTimeoutsRequestOptions);
    ackTimeout: number;
    byteTimeout: number;
    serialize(): Buffer;
    toJSON(): JSONObject;
}
export declare class SetSerialApiTimeoutsResponse extends Message {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    private _oldAckTimeout;
    get oldAckTimeout(): number;
    private _oldByteTimeout;
    get oldByteTimeout(): number;
    toJSON(): JSONObject;
}
export {};
