"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionType = exports.MessageType = exports.isMessagePriority = exports.MessagePriority = void 0;
/** The priority of messages, sorted from high (0) to low (>0) */
var MessagePriority;
(function (MessagePriority) {
    // Handshake messages have the highest priority because they are part of other transactions
    // which have already started when the handshakes are needed (e.g. Security Nonce exchange)
    //
    // We distinguish between responses to handshake requests from nodes that must be handled first.
    // Some nodes don't respond to our requests if they are waiting for a nonce.
    MessagePriority[MessagePriority["Handshake"] = 0] = "Handshake";
    // Our handshake requests must be prioritized over all other messages
    MessagePriority[MessagePriority["PreTransmitHandshake"] = 1] = "PreTransmitHandshake";
    // Controller commands usually finish quickly and should be preferred over node queries
    MessagePriority[MessagePriority["Controller"] = 2] = "Controller";
    // Pings (NoOP) are used for device probing at startup and for network diagnostics
    MessagePriority[MessagePriority["Ping"] = 3] = "Ping";
    // Multistep controller commands typically require user interaction but still
    // should happen at a higher priority than any node data exchange
    MessagePriority[MessagePriority["MultistepController"] = 4] = "MultistepController";
    // Whenever sleeping devices wake up, their queued messages must be handled quickly
    // because they want to go to sleep soon. So prioritize them over non-sleeping devices
    MessagePriority[MessagePriority["WakeUp"] = 5] = "WakeUp";
    // Normal operation and node data exchange
    MessagePriority[MessagePriority["Normal"] = 6] = "Normal";
    // Node querying is expensive and happens whenever a new node is discovered.
    // In order to keep the system responsive, give them a lower priority
    MessagePriority[MessagePriority["NodeQuery"] = 7] = "NodeQuery";
    // Some devices need their state to be polled at regular intervals. Only do that when
    // nothing else needs to be done
    MessagePriority[MessagePriority["Poll"] = 8] = "Poll";
})(MessagePriority = exports.MessagePriority || (exports.MessagePriority = {}));
function isMessagePriority(val) {
    return typeof val === "number" && val in MessagePriority;
}
exports.isMessagePriority = isMessagePriority;
/** Indicates the type of a data message */
var MessageType;
(function (MessageType) {
    MessageType[MessageType["Request"] = 0] = "Request";
    MessageType[MessageType["Response"] = 1] = "Response";
})(MessageType = exports.MessageType || (exports.MessageType = {}));
/**
 * Complete list of function IDs for data messages.
 * IDs starting with FUNC_ID are straight from OZW and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are taken from openhab-zwave and not implemented here yet.
 * IDs starting with UNKNOWN_FUNC are also taken from https://github.com/yepher/RaZBerry/blob/master/README.md and not implemented yet
 * IDs ending with UNKNOWN_<hex-code> are reported by the stick but we don't know what they mean.
 */
var FunctionType;
(function (FunctionType) {
    FunctionType[FunctionType["GetSerialApiInitData"] = 2] = "GetSerialApiInitData";
    FunctionType[FunctionType["FUNC_ID_SERIAL_API_APPL_NODE_INFORMATION"] = 3] = "FUNC_ID_SERIAL_API_APPL_NODE_INFORMATION";
    FunctionType[FunctionType["ApplicationCommand"] = 4] = "ApplicationCommand";
    FunctionType[FunctionType["GetControllerCapabilities"] = 5] = "GetControllerCapabilities";
    FunctionType[FunctionType["SetSerialApiTimeouts"] = 6] = "SetSerialApiTimeouts";
    FunctionType[FunctionType["GetSerialApiCapabilities"] = 7] = "GetSerialApiCapabilities";
    FunctionType[FunctionType["FUNC_ID_SERIAL_API_SOFT_RESET"] = 8] = "FUNC_ID_SERIAL_API_SOFT_RESET";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x09"] = 9] = "UNKNOWN_FUNC_UNKNOWN_0x09";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x0a"] = 10] = "UNKNOWN_FUNC_UNKNOWN_0x0a";
    FunctionType[FunctionType["UNKNOWN_FUNC_SerialAPISetup"] = 11] = "UNKNOWN_FUNC_SerialAPISetup";
    FunctionType[FunctionType["UNKNOWN_FUNC_RF_RECEIVE_MODE"] = 16] = "UNKNOWN_FUNC_RF_RECEIVE_MODE";
    FunctionType[FunctionType["UNKNOWN_FUNC_SET_SLEEP_MODE"] = 17] = "UNKNOWN_FUNC_SET_SLEEP_MODE";
    FunctionType[FunctionType["FUNC_ID_ZW_SEND_NODE_INFORMATION"] = 18] = "FUNC_ID_ZW_SEND_NODE_INFORMATION";
    FunctionType[FunctionType["SendData"] = 19] = "SendData";
    FunctionType[FunctionType["SendDataMulticast"] = 20] = "SendDataMulticast";
    FunctionType[FunctionType["GetControllerVersion"] = 21] = "GetControllerVersion";
    FunctionType[FunctionType["SendDataAbort"] = 22] = "SendDataAbort";
    FunctionType[FunctionType["FUNC_ID_ZW_R_F_POWER_LEVEL_SET"] = 23] = "FUNC_ID_ZW_R_F_POWER_LEVEL_SET";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_DATA_META"] = 24] = "UNKNOWN_FUNC_SEND_DATA_META";
    FunctionType[FunctionType["FUNC_ID_ZW_GET_RANDOM"] = 28] = "FUNC_ID_ZW_GET_RANDOM";
    FunctionType[FunctionType["GetControllerId"] = 32] = "GetControllerId";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_GET_BYTE"] = 33] = "UNKNOWN_FUNC_MEMORY_GET_BYTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_PUT_BYTE"] = 34] = "UNKNOWN_FUNC_MEMORY_PUT_BYTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_GET_BUFFER"] = 35] = "UNKNOWN_FUNC_MEMORY_GET_BUFFER";
    FunctionType[FunctionType["UNKNOWN_FUNC_MEMORY_PUT_BUFFER"] = 36] = "UNKNOWN_FUNC_MEMORY_PUT_BUFFER";
    FunctionType[FunctionType["UNKNOWN_FUNC_FlashAutoProgSet"] = 39] = "UNKNOWN_FUNC_FlashAutoProgSet";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x28"] = 40] = "UNKNOWN_FUNC_UNKNOWN_0x28";
    FunctionType[FunctionType["UNKNOWN_FUNC_NVMGetId"] = 41] = "UNKNOWN_FUNC_NVMGetId";
    FunctionType[FunctionType["UNKNOWN_FUNC_NVMExtReadLongBuffer"] = 42] = "UNKNOWN_FUNC_NVMExtReadLongBuffer";
    FunctionType[FunctionType["UNKNOWN_FUNC_NVMExtWriteLongBuffer"] = 43] = "UNKNOWN_FUNC_NVMExtWriteLongBuffer";
    FunctionType[FunctionType["UNKNOWN_FUNC_NVMExtReadLongByte"] = 44] = "UNKNOWN_FUNC_NVMExtReadLongByte";
    FunctionType[FunctionType["UNKNOWN_FUNC_NVMExtWriteLongByte"] = 45] = "UNKNOWN_FUNC_NVMExtWriteLongByte";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_SET"] = 48] = "UNKNOWN_FUNC_CLOCK_SET";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_GET"] = 49] = "UNKNOWN_FUNC_CLOCK_GET";
    FunctionType[FunctionType["UNKNOWN_FUNC_CLOCK_COMPARE"] = 50] = "UNKNOWN_FUNC_CLOCK_COMPARE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_CREATE"] = 51] = "UNKNOWN_FUNC_RTC_TIMER_CREATE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_READ"] = 52] = "UNKNOWN_FUNC_RTC_TIMER_READ";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_DELETE"] = 53] = "UNKNOWN_FUNC_RTC_TIMER_DELETE";
    FunctionType[FunctionType["UNKNOWN_FUNC_RTC_TIMER_CALL"] = 54] = "UNKNOWN_FUNC_RTC_TIMER_CALL";
    FunctionType[FunctionType["UNKNOWN_FUNC_ClearNetworkStats"] = 57] = "UNKNOWN_FUNC_ClearNetworkStats";
    FunctionType[FunctionType["UNKNOWN_FUNC_GetNetworkStats"] = 58] = "UNKNOWN_FUNC_GetNetworkStats";
    FunctionType[FunctionType["UNKNOWN_FUNC_GetBackgroundRSSI"] = 59] = "UNKNOWN_FUNC_GetBackgroundRSSI";
    FunctionType[FunctionType["UNKNOWN_FUNC_RemoveNodeIdFromNetwork"] = 63] = "UNKNOWN_FUNC_RemoveNodeIdFromNetwork";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_LEARN_NODE_STATE"] = 64] = "FUNC_ID_ZW_SET_LEARN_NODE_STATE";
    FunctionType[FunctionType["GetNodeProtocolInfo"] = 65] = "GetNodeProtocolInfo";
    FunctionType[FunctionType["HardReset"] = 66] = "HardReset";
    FunctionType[FunctionType["FUNC_ID_ZW_NEW_CONTROLLER"] = 67] = "FUNC_ID_ZW_NEW_CONTROLLER";
    FunctionType[FunctionType["FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE"] = 68] = "FUNC_ID_ZW_REPLICATION_COMMAND_COMPLETE";
    FunctionType[FunctionType["FUNC_ID_ZW_REPLICATION_SEND_DATA"] = 69] = "FUNC_ID_ZW_REPLICATION_SEND_DATA";
    FunctionType[FunctionType["AssignReturnRoute"] = 70] = "AssignReturnRoute";
    FunctionType[FunctionType["DeleteReturnRoute"] = 71] = "DeleteReturnRoute";
    FunctionType[FunctionType["RequestNodeNeighborUpdate"] = 72] = "RequestNodeNeighborUpdate";
    FunctionType[FunctionType["ApplicationUpdateRequest"] = 73] = "ApplicationUpdateRequest";
    FunctionType[FunctionType["AddNodeToNetwork"] = 74] = "AddNodeToNetwork";
    FunctionType[FunctionType["RemoveNodeFromNetwork"] = 75] = "RemoveNodeFromNetwork";
    FunctionType[FunctionType["FUNC_ID_ZW_CREATE_NEW_PRIMARY"] = 76] = "FUNC_ID_ZW_CREATE_NEW_PRIMARY";
    FunctionType[FunctionType["FUNC_ID_ZW_CONTROLLER_CHANGE"] = 77] = "FUNC_ID_ZW_CONTROLLER_CHANGE";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_LEARN_MODE"] = 80] = "FUNC_ID_ZW_SET_LEARN_MODE";
    FunctionType[FunctionType["FUNC_ID_ZW_ASSIGN_SUC_RETURN_ROUTE"] = 81] = "FUNC_ID_ZW_ASSIGN_SUC_RETURN_ROUTE";
    FunctionType[FunctionType["FUNC_ID_ZW_ENABLE_SUC"] = 82] = "FUNC_ID_ZW_ENABLE_SUC";
    FunctionType[FunctionType["FUNC_ID_ZW_REQUEST_NETWORK_UPDATE"] = 83] = "FUNC_ID_ZW_REQUEST_NETWORK_UPDATE";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_SUC_NODE_ID"] = 84] = "FUNC_ID_ZW_SET_SUC_NODE_ID";
    FunctionType[FunctionType["FUNC_ID_ZW_DELETE_SUC_RETURN_ROUTE"] = 85] = "FUNC_ID_ZW_DELETE_SUC_RETURN_ROUTE";
    FunctionType[FunctionType["GetSUCNodeId"] = 86] = "GetSUCNodeId";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_SUC_ID"] = 87] = "UNKNOWN_FUNC_SEND_SUC_ID";
    FunctionType[FunctionType["UNKNOWN_FUNC_AssignPrioritySUCReturnRoute"] = 88] = "UNKNOWN_FUNC_AssignPrioritySUCReturnRoute";
    FunctionType[FunctionType["UNKNOWN_FUNC_REDISCOVERY_NEEDED"] = 89] = "UNKNOWN_FUNC_REDISCOVERY_NEEDED";
    FunctionType[FunctionType["FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS"] = 90] = "FUNC_ID_ZW_REQUEST_NODE_NEIGHBOR_UPDATE_OPTIONS";
    FunctionType[FunctionType["FUNC_ID_ZW_EXPLORE_REQUEST_INCLUSION"] = 94] = "FUNC_ID_ZW_EXPLORE_REQUEST_INCLUSION";
    FunctionType[FunctionType["RequestNodeInfo"] = 96] = "RequestNodeInfo";
    FunctionType[FunctionType["RemoveFailedNode"] = 97] = "RemoveFailedNode";
    FunctionType[FunctionType["IsFailedNode"] = 98] = "IsFailedNode";
    FunctionType[FunctionType["ReplaceFailedNode"] = 99] = "ReplaceFailedNode";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x66"] = 102] = "UNKNOWN_FUNC_UNKNOWN_0x66";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x67"] = 103] = "UNKNOWN_FUNC_UNKNOWN_0x67";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_START"] = 112] = "UNKNOWN_FUNC_TIMER_START";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_RESTART"] = 113] = "UNKNOWN_FUNC_TIMER_RESTART";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_CANCEL"] = 114] = "UNKNOWN_FUNC_TIMER_CANCEL";
    FunctionType[FunctionType["UNKNOWN_FUNC_TIMER_CALL"] = 115] = "UNKNOWN_FUNC_TIMER_CALL";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x78"] = 120] = "UNKNOWN_FUNC_UNKNOWN_0x78";
    FunctionType[FunctionType["GetRoutingInfo"] = 128] = "GetRoutingInfo";
    FunctionType[FunctionType["UNKNOWN_FUNC_GetTXCounter"] = 129] = "UNKNOWN_FUNC_GetTXCounter";
    FunctionType[FunctionType["UNKNOWN_FUNC_ResetTXCounter"] = 130] = "UNKNOWN_FUNC_ResetTXCounter";
    FunctionType[FunctionType["UNKNOWN_FUNC_StoreNodeInfo"] = 131] = "UNKNOWN_FUNC_StoreNodeInfo";
    FunctionType[FunctionType["UNKNOWN_FUNC_StoreHomeId"] = 132] = "UNKNOWN_FUNC_StoreHomeId";
    FunctionType[FunctionType["UNKNOWN_FUNC_LOCK_ROUTE_RESPONSE"] = 144] = "UNKNOWN_FUNC_LOCK_ROUTE_RESPONSE";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO"] = 145] = "UNKNOWN_FUNC_SEND_DATA_ROUTE_DEMO";
    FunctionType[FunctionType["UNKNOWN_FUNC_GET_PRIORITY_ROUTE"] = 146] = "UNKNOWN_FUNC_GET_PRIORITY_ROUTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_SET_PRIORITY_ROUTE"] = 147] = "UNKNOWN_FUNC_SET_PRIORITY_ROUTE";
    FunctionType[FunctionType["UNKNOWN_FUNC_SERIAL_API_TEST"] = 149] = "UNKNOWN_FUNC_SERIAL_API_TEST";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0x98"] = 152] = "UNKNOWN_FUNC_UNKNOWN_0x98";
    FunctionType[FunctionType["FUNC_ID_SERIAL_API_SLAVE_NODE_INFO"] = 160] = "FUNC_ID_SERIAL_API_SLAVE_NODE_INFO";
    FunctionType[FunctionType["FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER"] = 161] = "FUNC_ID_APPLICATION_SLAVE_COMMAND_HANDLER";
    FunctionType[FunctionType["FUNC_ID_ZW_SEND_SLAVE_NODE_INFO"] = 162] = "FUNC_ID_ZW_SEND_SLAVE_NODE_INFO";
    FunctionType[FunctionType["FUNC_ID_ZW_SEND_SLAVE_DATA"] = 163] = "FUNC_ID_ZW_SEND_SLAVE_DATA";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_SLAVE_LEARN_MODE"] = 164] = "FUNC_ID_ZW_SET_SLAVE_LEARN_MODE";
    FunctionType[FunctionType["FUNC_ID_ZW_GET_VIRTUAL_NODES"] = 165] = "FUNC_ID_ZW_GET_VIRTUAL_NODES";
    FunctionType[FunctionType["FUNC_ID_ZW_IS_VIRTUAL_NODE"] = 166] = "FUNC_ID_ZW_IS_VIRTUAL_NODE";
    FunctionType[FunctionType["BridgeApplicationCommand"] = 168] = "BridgeApplicationCommand";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xB4"] = 180] = "UNKNOWN_FUNC_UNKNOWN_0xB4";
    FunctionType[FunctionType["UNKNOWN_FUNC_WATCH_DOG_ENABLE"] = 182] = "UNKNOWN_FUNC_WATCH_DOG_ENABLE";
    FunctionType[FunctionType["UNKNOWN_FUNC_WATCH_DOG_DISABLE"] = 183] = "UNKNOWN_FUNC_WATCH_DOG_DISABLE";
    FunctionType[FunctionType["UNKNOWN_FUNC_WATCH_DOG_KICK"] = 184] = "UNKNOWN_FUNC_WATCH_DOG_KICK";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xB9"] = 185] = "UNKNOWN_FUNC_UNKNOWN_0xB9";
    FunctionType[FunctionType["UNKNOWN_FUNC_RF_POWERLEVEL_GET"] = 186] = "UNKNOWN_FUNC_RF_POWERLEVEL_GET";
    FunctionType[FunctionType["UNKNOWN_FUNC_GET_LIBRARY_TYPE"] = 189] = "UNKNOWN_FUNC_GET_LIBRARY_TYPE";
    FunctionType[FunctionType["UNKNOWN_FUNC_SEND_TEST_FRAME"] = 190] = "UNKNOWN_FUNC_SEND_TEST_FRAME";
    FunctionType[FunctionType["UNKNOWN_FUNC_GET_PROTOCOL_STATUS"] = 191] = "UNKNOWN_FUNC_GET_PROTOCOL_STATUS";
    FunctionType[FunctionType["FUNC_ID_ZW_SET_PROMISCUOUS_MODE"] = 208] = "FUNC_ID_ZW_SET_PROMISCUOUS_MODE";
    FunctionType[FunctionType["FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER"] = 209] = "FUNC_ID_PROMISCUOUS_APPLICATION_COMMAND_HANDLER";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xD2"] = 210] = "UNKNOWN_FUNC_UNKNOWN_0xD2";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xD3"] = 211] = "UNKNOWN_FUNC_UNKNOWN_0xD3";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xD4"] = 212] = "UNKNOWN_FUNC_UNKNOWN_0xD4";
    FunctionType[FunctionType["UNKNOWN_FUNC_UNKNOWN_0xEF"] = 239] = "UNKNOWN_FUNC_UNKNOWN_0xEF";
    // Special commands for Z-Wave.me sticks
    FunctionType[FunctionType["UNKNOWN_FUNC_ZMEFreqChange"] = 242] = "UNKNOWN_FUNC_ZMEFreqChange";
    FunctionType[FunctionType["UNKNOWN_FUNC_ZMERestore"] = 243] = "UNKNOWN_FUNC_ZMERestore";
    FunctionType[FunctionType["UNKNOWN_FUNC_ZMEBootloaderFlash"] = 244] = "UNKNOWN_FUNC_ZMEBootloaderFlash";
    FunctionType[FunctionType["UNKNOWN_FUNC_ZMECapabilities"] = 245] = "UNKNOWN_FUNC_ZMECapabilities";
    FunctionType[FunctionType["UNKNOWN_FUNC_ZMESerialAPIOptions"] = 248] = "UNKNOWN_FUNC_ZMESerialAPIOptions";
})(FunctionType = exports.FunctionType || (exports.FunctionType = {}));

//# sourceMappingURL=Constants.js.map
